#Obtains configuration for RpasGlobalDomain target
#
# usage:
# oracle_retail_RpasGlobalDomain.pl <targetname> <metricname>
#   where <metricname> can be any of the following:
#     getPartitionDim
#     getAssoc

use strict;
use warnings;
use ecmAssoc;
use RpasDomainInfo;

my $domain = shift;
my $metricname = shift;
&usage() unless ($domain and $metricname);

if (RpasDomainInfo::setupEnvironment() eq 1)
{
   exit 0;
}

if ($metricname eq "getPartitionDim")
{
   printPartitionDim($domain);
}
elsif ($metricname eq "getAssoc")
{
   printAssociations($domain);
}
else
{
   die "Invalid metric name: ${metricname}\n";
}

exit 0;

# Gets the partition dimension of a global domain and returns the following format:
# em_result=<dim>
sub printPartitionDim {
   my $domain = shift;
   die "Domain not provided.\n" unless $domain;
   
   # getSubdomainsFull returns a hash containing the partition dimension, and an array
   # of subdomains.  We just need the 'dim' field.   
   my %info = &RpasDomainInfo::getSubdomainsFull($domain);
   my $dim = $info{'dim'};
   print "em_result=${dim}\n";
}

# Prints the associations to the RpasServerApp and subdomains
sub printAssociations {
   my $domain = shift;
   die "Domain name not provided\n" unless $domain;
   die "Domain is not a global domain\n" unless (&RpasDomainInfo::getType($domain) eq 'Global');

   print "em_result=${ecmAssoc::CONNECTS_TO}|$ENV{RPAS_HOME}|${ecmAssoc::ORACLE_RETAIL_RPAS_SERVER}|\n";

   #  getSubdomainsFull returns a hash containing the following information:
   # { 'dim' } - Partition dimension
   # { 'subdomains' } - An array of subdomains in the following format:
   #                              { 'path' } - Path to the subdomain
   #                              { 'pos'  } - Partition position
   my %info = &RpasDomainInfo::getSubdomainsFull($domain);
   my $subdomainsref = $info{ 'subdomains' };
   my @subdomains = @$subdomainsref;
   foreach my $line (@subdomains)   
   {
      my %subdomain = %$line;
      my $path = $subdomain{ 'path' };
      my $pos  = $subdomain{ 'pos'  };
      print "em_result=${ecmAssoc::CONTAINS}|${path}|${ecmAssoc::ORACLE_RETAIL_RPAS_SUB_DOMAIN}|\n";
   }
}


sub usage {
    die "Usage: oracle_retail_RpasGlobalDomain.pl <domain-path> <metricname>\n";
}
