#Obtains configuration for RpasServerApp target
#
# usage:
# oracle_retail_RpasServerApp.pl <targetname> <metricname>
#   where <metricname> can be any of the following:
#     getVersion
#     getAssoc

use strict;
use ecmAssoc;
use POSIX;
use RpasDomainInfo;

my $targetName = shift;
my $metricname = shift;
&usage() unless ($targetName and $metricname);

if (RpasDomainInfo::setupEnvironment() eq 1)
{
    exit 0;
}

my $targetType = $ecmAssoc::ORACLE_RETAIL_RPASSERVERAPP_TYPE;

if ($metricname eq "getVersion")
{
   printVersion();
}
elsif ($metricname eq "getAssoc")
{
   printAssociations();
}
else
{
   die "Invalid metric name: ${metricname}\n";
}

exit 0;

sub printVersion {
   my %versioninfo;
   open (IN, "$ENV{'RPAS_HOME'}/rpasVersion.ksh") 
      or die "Unable to open rpasVersion.ksh @ $ENV{'RPAS_HOME'}";

   while (<IN>)
   {
      next unless /^export (.+?)=(.+)$/;
      my $param = $1;
      my $value = $2;
      $value =~ s/^'(.*)'$/$1/;
      $versioninfo{$param} = $value;
   }
   close (IN);

   my $module  = $versioninfo{'MODULE'};
   my $release = $versioninfo{'RELEASE'};
   my $relDate = $versioninfo{'RELDATE'};

   # The release date comes in the wrong format.  Change it around before logging it.
   my ($wday, $month, $mday, $time, $timeZone, $year) = split ' ', $relDate;
   my $dispMonth = '00';
   if ($month eq 'Jan') {
      $dispMonth = '01';
   }
   elsif ($month eq 'Feb') {
      $dispMonth = '02';
   }
   elsif ($month eq 'Mar') {   
      $dispMonth = '03';
   }
   elsif ($month eq 'Apr') {
      $dispMonth = '04';
   }
   elsif ($month eq 'May') {
      $dispMonth = '05';
   }
   elsif ($month eq 'Jun') {
      $dispMonth = '06';
   }
   elsif ($month eq 'Jul') {
      $dispMonth = '07';
   }
   elsif ($month eq 'Aug') {
      $dispMonth = '08';
   }
   elsif ($month eq 'Sep') {
      $dispMonth = '09';
   }
   elsif ($month eq 'Oct') {
      $dispMonth = '10';
   }
   elsif ($month eq 'Nov') {
      $dispMonth = '11';
   }
   elsif ($month eq 'Dec') {
      $dispMonth = '12';
   }
   
   my $dispDate = $year.'-'.$dispMonth.'-'.$mday.' '.$time;
   
   print "em_result=${module}|${release}|${dispDate}\n";
}

# Prints all domains associated with this Rpas Server.
sub printAssociations {
   my @simples = &RpasDomainInfo::getDomains($ENV{RPAS_HOME}, 'Simple');
   foreach my $simple (@simples) {
      print "em_result=${ecmAssoc::CONNECTS_TO}|${simple}|${ecmAssoc::ORACLE_RETAIL_RPAS_SIMPLE_DOMAIN}|\n";
   }

   # For each Global Domain, list the domain and each of its subdomains.
   my @globals = &RpasDomainInfo::getDomains($ENV{RPAS_HOME}, 'Global');
   foreach my $global (@globals) {
      print "em_result=${ecmAssoc::CONNECTS_TO}|${global}|${ecmAssoc::ORACLE_RETAIL_RPAS_GLOBAL_DOMAIN}|\n";
      my %info = &RpasDomainInfo::getSubdomainsFull($global);
      my $subdomainsref = %info->{ 'subdomains' };
      my @subdomains = @$subdomainsref;
      foreach my $sub (@subdomains)   
      {
         my %subdomain = %$sub;
         my $path = %subdomain->{ 'path' };
         my $pos  = %subdomain->{ 'pos'  };
         print "em_result=${ecmAssoc::CONNECTS_TO}|${path}|${ecmAssoc::ORACLE_RETAIL_RPAS_SUB_DOMAIN}|\n";
      }
   }
}

sub usage {
    print "Usage: $0 <target-name> <metricname>\n";
}
