#Obtains configuration for RpasSimpleDomain target
#
# usage:
# oracle_retail_RpasSimpleDomain.pl <targetname> <metricname>
#   where <metricname> is:
#     getAssoc

use strict;
use warnings;
use ecmAssoc;
use RpasDomainInfo;

my $domain = shift;
my $metricname = shift;
&usage() unless (defined $domain && defined $metricname);

if (RpasDomainInfo::setupEnvironment() eq 1)
{
    exit 0;
}

if ($metricname eq "getAssoc")
{
   printAssociations();
}
else
{
   die "Invalid metric name: ${metricname}\n";
}

exit 0;

sub printAssociations {
   print "em_result=${ecmAssoc::CONNECTS_TO}|$ENV{RPAS_HOME}|${ecmAssoc::ORACLE_RETAIL_RPAS_SERVER}|\n";
}

sub usage {
    die "Usage: oracle_retail_RpasSimpleDomain.pl <domain-path> <metricname>\n";
}
