#Obtains configuration for RpasSubDomain target
#
# usage:
# oracle_retail_RpasSubDomain.pl <targetname> <metricname>
#   where <metricname> can be any of the following:
#     getPartitionPos
#     getAssoc

use strict;
use warnings;
use ecmAssoc;
use RpasDomainInfo;

my $domain = shift;
my $metricname = shift;
&usage() unless ($domain and $metricname);

if (RpasDomainInfo::setupEnvironment() eq 1)
{
    exit 0;
}

if ($metricname eq "getPartitionPos")
{
   printPartitionPosition($domain);
}
elsif ($metricname eq "getAssoc")
{
   printAssociations($domain);
}
else
{
   die "Invalid metric name: ${metricname}\n";
}

exit 0;

sub printPartitionPosition {
   my $domain = shift;
   die "Domain name not provided\n" unless $domain;
   
   my %info = RpasDomainInfo::getMasterInfo($domain);
   my $pos = $info{ 'Partition Pos' };
   print "em_result=${pos}\n";
}

# Prints the associations to the RpasServerApp and the Master domain.
sub printAssociations {
   my $domain = shift;
   die "Domain name not provided\n" unless $domain;
   print "em_result=${ecmAssoc::CONNECTS_TO}|$ENV{RPAS_HOME}|${ecmAssoc::ORACLE_RETAIL_RPAS_SERVER}|\n";
   
   my %masterInfo = &RpasDomainInfo::getMasterInfo($domain);
   my $master = $masterInfo{ 'Master' };
   my $pos    = $masterInfo{ 'Partition Pos' };
   print "em_result=${ecmAssoc::MEMBER_OF}|${master}|${ecmAssoc::ORACLE_RETAIL_RPAS_GLOBAL_DOMAIN}|\n";
}

sub usage {
    die "Usage: oracle_retail_RpasGlobalDomain.pl <domain-path> <metricname>\n";
}
