#  $Header: osconfig.pl 06-mar-2005.23:42:04 sacgoyal Exp $
# 
# Copyright (c) 2001, 2005, Oracle. All rights reserved.  
#
#    NAME
#      osconfig.pl
#
#    Description:
#      This script is used in the EMD to ccollect OS configuration info.
#      The expected o/p if the script executes successfully is
#  
#  em_result=<OS>|<OSReleaseLevel>|<PatchLevel>|<Platform>|<Uptime>|<IP Addr>
#
#    MODIFIED  (MM/DD/YY)
#    sacgoyal 03/06/05 - fix bug#4215387 
#    mbhoopat 03/10/04 - linux port 
#    nsharma  01/28/04 - Fix for united linux 
#    rzkrishn 07/28/03 - using nmupm for system boot time
#    vsekuboy 10/28/02 - Updated comments to reflect correct output
#    vsekuboy 10/24/02 - Changes for AIX and Tru64
#    vsekuboy 10/09/02 - Changes for HP and Linux
#    xxu      06/25/02 - remove /usr/local/bin/perl
#    njagathe 01/17/02 - Adding back more columns
#    njagathe 01/17/02 - Updating to only return 3 columns
#    vnukal   12/24/01 - fixing ip parsing glitch in 2.8
#    vnukal   10/22/01 - adding patch level and ip info to Config metric
#    vnukal   10/03/01 - reducing delay for top execution
#    vnukal   09/04/01 - Initial revision

#require "emd_common.pl";
use hostGenFunctions;

$ENV{PATH} = "/bin:/usr/bin:/usr/sbin:/usr/local/bin:/sbin:$ENV{EMDROOT}/bin";
chomp ($os = `uname -s`);
if ( $os eq "SunOS" || $os eq "AIX" || $os eq "OSF1" ) {
   chomp ($os_release_level = `uname -r`);
   chomp ($patchlevel = `uname -v`);

   if ( $os eq "SunOS" ) {
       chomp ($upsince = `nmupm bootTime`);
       @results = split(/=/, $upsince );
       $uptime = $results[1];
   }
   else {
     chomp ($upsince = `who -b`);
     $upsince =~ /system boot\s+([a-zA-Z0-9 :]+)/i ;
     $uptime = $1;
   }

   chomp($hostname = `hostname`);

   if ( $os eq "AIX" ) {
      chomp ($platform = `uname -M`);
      chomp($pingop = `ping $hostname 1 1 | head -1`); 
   }
   elsif ( $os eq "OSF1" ) {
      chomp ($platform = `uname -m`);
      chomp($pingop = `ping -c 1 $hostname | head -1`);
   }
   else {
      chomp ($platform = `uname -mi`);
      chomp($pingop = `ping -s $hostname 1 1`);
   }

   #get the first stuff between parenthesis.
   ($ip) = $pingop =~ m/\((\S+)\)/o; 
}
elsif ( $os eq "HP-UX") {
 
   chomp ($os_release_level = `uname -r`);
   chomp ($model = `uname -mi`);
 
   if ( $model == "ia64" ) {
      $platform="IA64";
   }
   else {
      $platform="PA-RISC";
   }
 
   chomp ($upsince = `who -b`);
   chomp ($patchlevel = `uname -v`);
 
   $upsince =~ /system boot\s+([a-zA-Z0-9 :]+)/i ;
   $uptime = $1;
 
   chomp($hostname = `hostname`);
   chomp($pingop = `/etc/ping $hostname -n 1`);
 
   #get the IP address
   $pingop =~ /bytes from (.*?):/;
   ($ip) = $1;
 
}
elsif ($os eq "Linux") {
   chomp ($platform = `uname -m`);
   chomp ($patchlevel = `uname -r`);

   $upData = `uptime`;
   @upData1 = split (",",$upData);
   @upData2 = split (" ",@upData1[0]);
   $uptime=join (" ", @upData2[2], @upData2[3]);

   if ( -r "/etc/SuSE-release" ) {
       $os_release_level=`cat /etc/SuSE-release | tr '\n' ' ' `;
   }
   elsif ( -r "/etc/redhat-release") {
      $os_release_level=`cat /etc/redhat-release | tr '\n' ' ' `;
   }
   elsif ( -r "/etc/UnitedLinux-release") {
      $os_release_level=`cat /etc/UnitedLinux-release | tr '\n' ' ' `;
   }
   $host = `hostname`;
   $_ = `ping -c1 $host`;

   if(/PING/) {
	   ($c1,$c2,$c3,$ignore) = split(/\s+/);
	   ($c1,$ip,$ignore) = split(/[\(\)]/, $c3);
   }
}

$os_release_level = trim($os_release_level);

print "em_result=$os|$os_release_level|$patchlevel|$platform|$uptime|$ip\n";




