# $Header: osconfigExt.pl 25-jun-2002.10:49:42 xxu Exp $
#
# osconfigExt.pl
# 
# Copyright (c) 2002, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      osconfigExt.pl - OS CONFIGuration EXTended
#
#    DESCRIPTION
#      This script is used in the EMD to collect extended
#      OS configuration info like OS Bits, max number of child procs
#      allowed, max open file per proc etc.
#      The expected o/p if the script executes successfully is
#           em_result=<OSBits>|<maxChildProcs>|<maxOpenFilePerProc>
#
#    NOTES
#      This script needs to be platform independent. The PLE team
#      can modify the script to make it truly platform independent.
#
#    MODIFIED   (MM/DD/YY)
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    dmshah      04/03/02 - dmshah_support_host_metris
#    dmshah      03/29/02 - Creation
# 

chomp ($os = `uname -s`);
chomp ($osver = `uname -r`);

$bits=32;

if ($os eq "SunOS")
{
  if($osver gt "6")
  {
     chomp ($bits = `isainfo -v`);
  }
}
else  ## ELSE BLOCK 1
{
  if ($os eq "AIX" )
  {
    chomp ($bits = `lslpp -l bos.64bit |grep bos`);
  }
  else ## ELSE BLOCK 2
  {
    if($os eq "HP-UX" )
    {
       if($osver gt "6")
       {
           chomp ($bits = `getconf KERNEL_BITS`);
       }
    }
    else ## ELSE BLOCK 3
    {
       if ($os eq "OSF1" ) 
       {
         $bits="64"
       }
    } ## END OF ELSE BLOCK 3
  } ## END OF ELSE BLOCK 2
} ## END OF ELSE BLOCK 1

chomp ($maxChildProcs = `getconf CHILD_MAX`);
chomp ($maxOpenFilePerProc = `getconf OPEN_MAX`);

print "em_result=$bits|$maxChildProcs|$maxOpenFilePerProc\n";

