set serveroutput on
set echo off
-- Insert a job with specified parameters
BEGIN
DECLARE l_job_targets MGMT_JOB_TARGET_LIST;
l_job_params MGMT_JOB_PARAM_LIST;
l_job_name varchar2(64);
l_stage_host varchar2(64);
l_stage_user varchar2(64);
l_stage_passwd varchar2(64);
l_comp_type varchar2(64);
l_comp_name varchar2(64);
l_comp_version varchar2(64);
l_hw_name varchar2(64);
l_stage_directory varchar2(64);
l_job_id RAW(16);
l_execution_id RAW(16);
l_schedule MGMT_JOB_SCHEDULE_RECORD;
l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
l_large_param CLOB;
l_large_text VARCHAR2(1024);

-- test
l_command_names  MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
l_run_as_root  MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
l_directive_types  MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();

l_creds MGMT_JOB_CRED_ARRAY := MGMT_JOB_CRED_ARRAY();
l_cred_rows MGMT_CRED_ROW_ARRAY := MGMT_CRED_ROW_ARRAY();
l_cred_record MGMT_CRED_RECORD;



days MGMT_JOB_INT_ARRAY := MGMT_JOB_INT_ARRAY();
months MGMT_JOB_INT_ARRAY := MGMT_JOB_INT_ARRAY();
BEGIN
    l_job_name := '&JobName';
    l_stage_host := '&StageHost';
    l_stage_user := '&StageUserName';
    l_stage_passwd := '&StagePassword';
    l_comp_name := '&CompPath';
    l_comp_version := '&CompVersion';
    l_hw_name := '&HardwareName';
    l_stage_directory := '&StageDirectory';

    l_job_targets := MGMT_JOB_TARGET_LIST();

    -- Submit the targets for the job. Extend jobTargets by as many
    -- targets as your job needs (or can handle)
    l_job_targets.extend(1);

    l_job_targets(1) := MGMT_JOB_TARGET_RECORD(l_stage_host, 'host');

    -- Submit the parameters for the job. All parameters that your job
    -- needs must be specified here
    l_job_params := MGMT_JOB_PARAM_LIST();
    l_job_params.extend(6);
    
    -- Examples of scalar parameters
    l_job_params(1) := MGMT_JOB_PARAM_RECORD('stageUserName', MGMT_JOBS.PARAM_TYPE_SCALAR, l_stage_user, null);
    l_job_params(2) := MGMT_JOB_PARAM_RECORD('stagePassword', MGMT_JOBS.PARAM_TYPE_SCALAR, l_stage_passwd, null);
    l_job_params(3) := MGMT_JOB_PARAM_RECORD('compPath', MGMT_JOBS.PARAM_TYPE_SCALAR, l_comp_name, null);
    l_job_params(4) := MGMT_JOB_PARAM_RECORD('compVersion', MGMT_JOBS.PARAM_TYPE_SCALAR, l_comp_version, null);
    l_job_params(5) := MGMT_JOB_PARAM_RECORD('hwName', MGMT_JOBS.PARAM_TYPE_SCALAR, l_hw_name, null);
    l_job_params(6) := MGMT_JOB_PARAM_RECORD('stageDir', MGMT_JOBS.PARAM_TYPE_SCALAR, l_stage_directory, null);

    -- Set up the schedule for the job. The schedule below is for
    -- an immediate, one-time job. It executes in the timezone of
    -- the repository. For examples of other types of schedules,
    -- comment out this section and uncomment one of the
    -- other sections below
    l_schedule := MGMT_JOB_SCHEDULE_RECORD(MGMT_JOBS.ONE_TIME_FREQUENCY_CODE, 
                                         SYSDATE,				                                         null, 50, 0, 0, 0, null, null,
                                         MGMT_JOBS.TIMEZONE_REPOSITORY, 
                                         0, 0, null);

 MGMT_JOBS.submit_job(l_job_name,
                         'CleanUpStageDataJob',
                         'CleanUpStageDataJob',
                         l_job_targets,
                         l_job_params,
                         l_schedule,
                         l_job_id,
                         l_execution_id,
                         null, 0);
   dbms_output.put_line('Job ' || l_job_name || ' successfully inserted');
   dbms_output.put_line('Job id is ' || l_job_id);
    dbms_output.put_line('Execution id is ' || l_execution_id);

END;
END;
/
COMMIT;
set serveroutput off
