:
#!/usr/local/bin/perl
# 
# $Header: createlinuxostar.pl 26-sep-2005.03:27:31 rmadampa Exp $
#
# createlinux0star.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      createlinux0star.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rmadampa    09/26/05 - adding caret sign for rpm-name search 
#    pshroff     08/31/05 - 
#    pshroff     08/29/05 - modifying folder-name from i386 to LinuxOSRoot 
#    pshroff     08/23/05 - validating for emagent dependent RPMs 
#    pshroff     08/08/05 - using hack for testing purpose=> ignore RPM 
#                           Versions 
#    pshroff     08/05/05 - exit error in case version mismatch 
#    pshroff     08/01/05 - removing unwanted mesg 
#    pshroff     06/30/05 - pshroff_map_shiphome- moved to emcore from emagent
#    rbhanush    06/06/05 - copying all kernel RPMs
#    rbhanush    05/05/05 - Adding rpms_list.txt and kickstart.cfg to tar
#    rbhanush    04/12/05 - escaping '+' char in rpm name
#    rbhanush    03/22/05 - rbhanush_oscomp
#    pshroff     02/24/05 - Creation
# 

use LWP::Simple;
 
my @dependent_rpms = (
        "redhat-release", "glibc", "setarch", "pdksh", "sysstat", 
        "chkconfig", "initscripts", "gcc"); 

my %not_found_dependent_rpms = @dependent_rpms;

if(!-e "/tmp/FDCD2512B3D349C4E030578CDF08494A")
{
    #actual code
    main();
}
else
{
    print "found hack file\n";
    hack();
}

sub main()
{
    

    $rpm_repository_url=$ARGV[0];
    $rpm_list_file=$ARGV[1];
    $comp_path=$ARGV[2];
    $tar_filename=$ARGV[3];
    $kickstart_file=$ARGV[4];
    
    $rpm_url=$rpm_repository_url."/RedHat/RPMS";
    $base_url=$rpm_repository_url."/RedHat/base";
    
    my $FILENOTFOUND = 404;
    
    my $pathSeperator="/";
    my $rpm_folder="LinuxOSRoot".$pathSeperator."RedHat".$pathSeperator."RPMS";
    my $base_folder="LinuxOSRoot".$pathSeperator."RedHat".$pathSeperator."base";
    my $exitstatus;
    $HEADER_FOLDER_NAME="headers";
    $HEADER_FILE_NAME="header.info";
    $HEADER_INFO_LOC=$HEADER_FOLDER_NAME.$pathSeperator.$HEADER_FILE_NAME;
    
    $comp_temp_loc=$comp_path.$pathSeperator;
    my $rpm_location=$comp_temp_loc.$rpm_folder.$pathSeperator;
    my $base_location=$comp_temp_loc.$base_folder.$pathSeperator;
    
    #Download URN/RedHat/RPMS/headers/header.info to local temp location
    $header_src=$rpm_url.$pathSeperator.$HEADER_INFO_LOC;
    $header_target=$comp_temp_loc.$HEADER_FOLDER_NAME.$pathSeperator.$HEADER_FILE_NAME;
    print "Copying header file $header_src to $header_target\n";
    mkdir $comp_temp_loc.$HEADER_FOLDER_NAME;
    my $header_status = getstore($header_src,$header_target);
    print "Status of header file copy is:$header_status\n";
    if($header_status == $FILENOTFOUND)
    {
        print "Failed copying header file $HEADER_FILE_NAME from RPM repository\n";
    }
    else
    {
        print "Copied $HEADER_FILE_NAME from RPM repository\n";
    }
    #Download header.info complete
    
    #Put all RPM entries from the header file in an array
    open HEADER_FILEHANDLE, "$header_target" or die "can't open a $!";
    while (<HEADER_FILEHANDLE>) 
    {
        chomp;
        push (@rpmentries_list, $_);
    }
    close HEADER_FILEHANDLE;
   
    #For each rpm package name in rpm_list_file, get the .rpm from the rpm repository
    #and copy to temp area.
    open RPMLIST_FILEHANDLE, "$rpm_list_file" or die "can't open a $!";
    
    $continue_flag="true";
    my $found_dependent_package_count = 0;
    
    print "EMAGENT Dependent RPM List=> @dependent_rpms \n";   
            
    while ($rpm_name = <RPMLIST_FILEHANDLE> )
    {
        chomp $rpm_name;
        $rpm_name=~s/\+/\\\+/; 
         
        my $packageName = removeVerAndRelInfo($rpm_name);
        
        #Excluding comps.rpm package
        next if $packageName eq "comps"; 
                
        @rpm_name_entrys = grep /:$rpm_name/, @rpmentries_list;
        #If no matching versions found, exit with error
        $totalMatchingRPMs=$#rpm_name_entrys;

        # find dependent RPMs
               
        if ($rpm_name=~"kernel")
        {
             
        }
        else
        {
           
           foreach $dependent_rpm (@dependent_rpms)
            {
                if ($dependent_rpm eq $packageName) 
                {           
                    delete ( $not_found_dependent_rpms{$dependent_rpm} );
                    $found_dependent_package_count = $found_dependent_package_count + 1;
                }
               
            }
             
        }

        # ignore kernel and emagent RPMs
        if($rpm_name=~"kernel")
        {
            next;   
        }
        if($rpm_name=~"emagent")
        {
            next;   
        }

        if($totalMatchingRPMs == -1)
        { 
            push (@missingrpms_list, "$rpm_name\n");
            $continue_flag="false";
        }
       
    }

    my $total_dependent_rpm_count = $#dependent_rpms + 1;
    
    if ($found_dependent_package_count eq $total_dependent_rpm_count) 
    {
        print "\nFound total $found_dependent_package_count Dependent RPMs\n";
    }
    else
    {
        my @not_found_rpms = %not_found_dependent_rpms;
        print "\n=================================================================\n";
        print "ERROR: The following EMAgent Dependent RPMs are not found in the Reference Installation";
        print "\n=================================================================\n";
        print "@not_found_rpms"; 
        print "\n=================================================================\n";
        print "Reference Installation Should have all the RPMs, which are " ;
        print "required by EM Agent RPM\n\n";
        
        exit 1;
    }

     if($continue_flag=~/false/)
     {
        print "\n=================================================================\n";
        print "ERROR: The following RPMs are not available in the repository";
        print "\n=================================================================\n";
        print "@missingrpms_list"; 
        print "\n=================================================================\n";
        print "RPM Repository Should have all the RPMs, which are " ;
        print "available at Reference Installation\n\n";
        
        exit 1;
     }
    
    close RPMLIST_FILEHANDLE;
    open RPMLIST_FILEHANDLE, "$rpm_list_file" or die "can't open a $!";
    
    my $kernel_flag = "false";
    my $sudo_flag = "false";

    while ($rpm_name = <RPMLIST_FILEHANDLE> )
    {
        chomp $rpm_name;
        $rpm_name=~s/\+/\\\+/; 
        
        print "INFO: Processing For : $rpm_name : \n";
        
         my $packageName = removeVerAndRelInfo($rpm_name);
    
        #Excluding comps.rpm package
        next if $packageName eq "comps"; 
        @rpm_name_entrys = grep /:$rpm_name/, @rpmentries_list;
              
        #ingore emagent RPMs
        if($rpm_name=~"emagent")
        {
            next;   
        }
        
        if($rpm_name=~"kernel")
        {
            # in case of kernel, need to fetch/copy all RPMs in Repository
            if ($kernel_flag=~/false/)
            {
                @rpm_name_entrys = grep /:kernel/, @rpmentries_list;
                
                print "Starting to copy kernel RPMs\n";
                foreach  $rpm_name_entry (@rpm_name_entrys) 
                {
                    print "entry from headers file (kernel rpm)::$rpm_name_entry \n";
                    copyRPMFromRepository($rpm_name_entry, $rpm_url, $rpm_location);
                    print "Copied kernel RPM:: $rpm_name_entry\n";
                }
                $kernel_flag = "true";
            }
         }
        else 
        {   
            
            if($packageName=~/sudo/)
            {
                $sudo_flag = "true";
            }
            
            $rpm_name_entry = @rpm_name_entrys[0];
            print "entry from headers file ::$rpm_name_entry \n";
            copyRPMFromRepository($rpm_name_entry, $rpm_url, $rpm_location);
        } # else ends here
        print "Copying file :$rpm_name DONE\n\n";
    } # while ends here
    
    print "Starting to copy sudo RPMs\n";
    
    if ($sudo_flag=~/false/)
    {
        print "Processing for sudo package \n";
        
        $packageName = "sudo";
        my @sudo_rpm_name_entrys = grep /:$packageName/, @rpmentries_list;
        
        foreach $matching_entry (@sudo_rpm_name_entrys)
        {
            @tmp = split (/\=/,$matching_entry);
            $rpmname_withcolon_withver = @tmp[0];
            $rpmname_withcolon_nover = removeVerAndRelInfo($rpmname_withcolon_withver);
            
            @tmp1=split(/:/,$rpmname_withcolon_nover);
            $packageName_tmp=@tmp1[1];
            
            if($packageName_tmp eq $packageName)
            {
                print "found matching sudo RPM entry: $packageName_tmp\n";
                @rpm_name_entrys=($matching_entry);
            }
        }
         
        foreach  $rpm_name_entry (@rpm_name_entrys) 
        {
            print "entry from headers file (sudo rpm)::$rpm_name_entry \n";
            copyRPMFromRepository($rpm_name_entry, $rpm_url, $rpm_location);
            print "Copied sudo RPM:: $rpm_name_entry\n";
        }
    }    # if sudo

    close RPMLIST_FILEHANDLE;
    
    #Copying base folder contents
    #Following files will be copied:
    # hdlist, hdlist2, hdstg2.img, netstg2.img, product.img, stage2.img
    copyBaseImageFiles($base_url, $base_location);
    
    #Updating comps.xml with the header file
    updateCompsXML($comp_temp_loc, $base_location);
    
    #Creating .tar file for all the RPMs got from the repository
    $command="cd $comp_temp_loc ; chmod -R 777 .; tar -cvf $tar_filename *";
    system($command);
    $exitstatus = $? >> 8;
    if ( $exitstatus != 0)
    {
        print "\n Failed while Creating Tar File for Linux OS Component \n";
        exit $exitstatus;
    }
} # main ends here
 



sub hack()
{
    $rpm_repository_url=$ARGV[0];
    $rpm_list_file=$ARGV[1];
    $comp_path=$ARGV[2];
    $tar_filename=$ARGV[3];
    $kickstart_file=$ARGV[4];
    
    $rpm_url=$rpm_repository_url."/RedHat/RPMS";
    $base_url=$rpm_repository_url."/RedHat/base";
    
    my $FILENOTFOUND = 404;
    
    my $pathSeperator="/";
    my $rpm_folder="LinuxOSRoot".$pathSeperator."RedHat".$pathSeperator."RPMS";
    my $base_folder="LinuxOSRoot".$pathSeperator."RedHat".$pathSeperator."base";
    my $exitstatus;
    $HEADER_FOLDER_NAME="headers";
    $HEADER_FILE_NAME="header.info";
    $HEADER_INFO_LOC=$HEADER_FOLDER_NAME.$pathSeperator.$HEADER_FILE_NAME;
    
    $comp_temp_loc=$comp_path.$pathSeperator;
    my $rpm_location=$comp_temp_loc.$rpm_folder.$pathSeperator;
    my $base_location=$comp_temp_loc.$base_folder.$pathSeperator;
    
    #Download URN/RedHat/RPMS/headers/header.info to local temp location
    $header_src=$rpm_url.$pathSeperator.$HEADER_INFO_LOC;
    $header_target=$comp_temp_loc.$HEADER_FOLDER_NAME.$pathSeperator.$HEADER_FILE_NAME;
    print "Copying header file $header_src to $header_target\n";
    mkdir $comp_temp_loc.$HEADER_FOLDER_NAME;
    my $header_status = getstore($header_src,$header_target);
    print "Status of header file copy is:$header_status\n";
    if($header_status == $FILENOTFOUND)
    {
        print "Failed copying header file $HEADER_FILE_NAME from RPM repository\n";
    }
    else
    {
        print "Copied $HEADER_FILE_NAME from RPM repository\n";
    }
    #Download header.info complete
    
    #Put all RPM entries from the header file in an array
    open HEADER_FILEHANDLE, "$header_target" or die "can't open a $!";
    while (<HEADER_FILEHANDLE>) 
    {
        chomp;
        push (@rpmentries_list, $_);
    }
    close HEADER_FILEHANDLE;
   
    #For each rpm package name in rpm_list_file, get the .rpm from the rpm repository
    #and copy to temp area.
    open RPMLIST_FILEHANDLE, "$rpm_list_file" or die "can't open a $!"; 
    
    my $kernel_flag = "false";
    my $sudo_flag = "false";

    while ($rpm_name = <RPMLIST_FILEHANDLE> )
    {
        

        chomp $rpm_name;
        $rpm_name=~s/\+/\\\+/;
        print "Copying file :$rpm_name\n";
        @rpm_name_entrys = grep /:$rpm_name/, @rpmentries_list;
        
        my $packageName = removeVerAndRelInfo($rpm_name);

        #Excluding comps.rpm package
        next if $packageName eq "comps";

        #If no matching versions found, copy the version available in the repository
        $totalMatchingRPMs=$#rpm_name_entrys;
        if($totalMatchingRPMs == -1)
        {
            print "WARNING: $rpm_name not available in the repository.\n";      
            @matching_rpm_name_entrys = grep /:$packageName/, @rpmentries_list;

            foreach $matching_entry (@matching_rpm_name_entrys)
            {
               @tmp = split (/\=/,$matching_entry);
               $rpmname_withcolon_withver = @tmp[0];
               $rpmname_withcolon_nover = removeVerAndRelInfo($rpmname_withcolon_withver);

               @tmp1=split(/:/,$rpmname_withcolon_nover);
               $packageName_tmp=@tmp1[1];

               if($packageName_tmp eq $packageName)
               {
                    print "found matching comps entry found: $packageName_tmp\n";
                    @rpm_name_entrys=($matching_entry);
               }
            }

            print "WARNING: Copying different version of rpm $packageName_tmp from repository for rpm $rpm_name\n";
        }
        
        #ignore emagent RPMs
        if($rpm_name=~"emagent")
        {
            next;   
        }

        if($rpm_name=~"kernel")
        {
            print "Starting to copy kernel RPMs\n";
            foreach  $rpm_name_entry (@rpm_name_entrys) 
            {
                print "entry from headers file (kernel rpm)::$rpm_name_entry \n";
                copyRPMFromRepository($rpm_name_entry, $rpm_url, $rpm_location);
                print "Copied kernel RPM:: $rpm_name_entry\n";
            }
        }
        else
        {
            if($packageName=~/sudo/)
            {
                $sudo_flag = "true";
            }
            $rpm_name_entry = @rpm_name_entrys[0];
            print "entry from headers file ::$rpm_name_entry \n";
            copyRPMFromRepository($rpm_name_entry, $rpm_url, $rpm_location);
        }

        print "Copying file :$rpm_name DONE\n\n";
    }
     
    print "Starting to copy sudo RPMs\n";
    
    if ($sudo_flag=~/false/)
    {
        print "Processing for sudo package \n";
        
        $packageName = "sudo";
        my @sudo_rpm_name_entrys = grep /:$packageName/, @rpmentries_list;
        
        foreach $matching_entry (@sudo_rpm_name_entrys)
        {
            @tmp = split (/\=/,$matching_entry);
            $rpmname_withcolon_withver = @tmp[0];
            $rpmname_withcolon_nover = removeVerAndRelInfo($rpmname_withcolon_withver);
            
            @tmp1=split(/:/,$rpmname_withcolon_nover);
            $packageName_tmp=@tmp1[1];
            
            if($packageName_tmp eq $packageName)
            {
                print "found matching sudo RPM entry: $packageName_tmp\n";
                @rpm_name_entrys=($matching_entry);
            }
        }
         
        foreach  $rpm_name_entry (@rpm_name_entrys) 
        {
            print "entry from headers file (sudo rpm)::$rpm_name_entry \n";
            copyRPMFromRepository($rpm_name_entry, $rpm_url, $rpm_location);
            print "Copied sudo RPM:: $rpm_name_entry\n";
        }
    }    # if sudo

    close RPMLIST_FILEHANDLE;
    
    #Copying base folder contents
    #Following files will be copied:
    # hdlist, hdlist2, hdstg2.img, netstg2.img, product.img, stage2.img
    copyBaseImageFiles($base_url, $base_location);
    
    #Updating comps.xml with the header file
    updateCompsXML($comp_temp_loc, $base_location);
    
    #Creating .tar file for all the RPMs got from the repository
    $command="cd $comp_temp_loc ; chmod -R 777 .; tar -cvf $tar_filename *";
    system($command);
    $exitstatus = $? >> 8;
    if ( $exitstatus != 0)
    {
        print "\n Failed while Creating Tar File for Linux OS Component \n";
        exit $exitstatus;
    }
} # hack ends here
 




#Copy RPMs from RPM repository
sub copyRPMFromRepository()
{
    my ($rpm_name_entry, $rpm_repository_url, $rpm_target_loc)=@_;
    my $pathSeperator="/";
    my $FILENOTFOUND = 404;
    
    #$rpm_name_entry = @rpm_name_entrys[0];
    @rpm_filename_list = split (/\=/,$rpm_name_entry);
    $rpm_filename=@rpm_filename_list[1];
    
    $rpm_src=$rpm_repository_url.$pathSeperator.$rpm_filename;
    $rpm_target=$rpm_target_loc.$rpm_filename;
    
    my $copy_status = getstore($rpm_src,$rpm_target);
    
    if($copy_status == $FILENOTFOUND)
    {
        print "Failed copying $rpm_filename from RPM repository\n";
    }
    else
    {
        print "Copied $rpm_filename from RPM repository\n";
    }
}

#Copying base folder contents
#Following files will be copied:
# hdlist, hdlist2, hdstg2.img, netstg2.img, product.img, stage2.img
sub copyBaseImageFiles()
{
    my ($base_repository_url, $base_target_location)=@_;
    
    copyFileFromRepository($base_repository_url, $base_target_location, "hdlist");
    copyFileFromRepository($base_repository_url, $base_target_location, "hdlist2");
    copyFileFromRepository($base_repository_url, $base_target_location, "hdstg2.img");
    copyFileFromRepository($base_repository_url, $base_target_location, "netstg2.img");
    copyFileFromRepository($base_repository_url, $base_target_location, "product.img");
    copyFileFromRepository($base_repository_url, $base_target_location, "stage2.img");
}

sub copyFileFromRepository()
{
    my ($source, $target, $filename)=@_;
    my $pathSeperator="/";
    my $FILENOTFOUND = 404;
    
    $source=$source.$pathSeperator.$filename;
    $target=$target.$filename;
    
    print "Copying base file $source from RPM repository to $target\n";
    
    my $copy_status = getstore($source,$target);
    
    if($copy_status == $FILENOTFOUND)
    {
    print "Failed copying $source from RPM repository location :$target\n";
    }
}

#This method removes version and release no information from the rpm package name.
#Example: Input: telnet-0.17-26 Output: telnet
sub removeVerAndRelInfo()
{
    my ($rpm_name)=@_;
    my (@rpm_info, $len, $count, $rpm_entry, $rpm_package_name);
    my (@rpm_name_no_ver);  
    
    @rpm_info = split /-/,$rpm_name ;
    $len = $#rpm_info;
    
    for($count=0;$count<=$len-2;$count++)
    {
    $rpm_entry=$rpm_info[$count];
    chomp $rpm_entry;
    push @rpm_name_no_ver, $rpm_entry;
    }
    
    $rpm_package_name = join "-",@rpm_name_no_ver;
    
    return $rpm_package_name;
    
}

#Update comps.xml with the header file
sub updateCompsXML()
{
    my ($comp_temp_loc, $base_location)=@_;
    
    print "\nUpdating comps.xml ...\n";
    print "Comp temp location: $comp_temp_loc\n";
    print "base folder location: $base_location\n";
    
    chdir $comp_temp_loc or die "Can not change to comp_temp_loc for updating comps.xml";
    my $cp_comps_xml="cp -f ../comps.xml $base_location";
    system($cp_comps_xml);
    $exitstatus = $? >> 8;
    if ( $exitstatus != 0)
    {
    print "\n Failed while Copying comps.xml file \n";
    exit $exitstatus;
    }
    print "Copied master comps.xml to $base_location \n";
    
    my $pathSeperator="/";
    my $comps_xml="comps.xml";
    my $comps_xml_path=$base_location.$comps_xml;
    my $tmp_comps_xml="comps1.xml";
    my $tmp_comps_xml_path=$base_location.$tmp_comps_xml;
    my $package_list="pkglist";
    my $package_list_path=$comp_temp_loc.$package_list;
    
    my $generate_comps_xml="/usr/share/comps-extras/getfullcomps.py comps.xml $comp_temp_loc LinuxOSRoot > $package_list_path";
    system($generate_comps_xml);
    $exitstatus = $? >> 8;
    if ( $exitstatus != 0)
    {
    print "\n Failed while generating comps.xml file \n";
    exit $exitstatus;
    }
    
    open OUT,">$tmp_comps_xml_path" or die "can not create comps1.xml file:$!";
    open READ,"$comps_xml_path" or die "can not read master comps.xml from $comps_xml_path:$!";
    my $comps_end_str="</comps>";
    
    while(<READ>)
    {
    if($_=~ $comps_end_str)
    {
        #Append package list file
        open READPACKAGE, "$package_list_path" or die "Can not read package section file $package_list_path:$!";
        while(<READPACKAGE>)
        {
        print OUT $_;
        }
        close READPACKAGE;
    }
    else
    {
            print OUT $_;
            }
    }
    print OUT $comps_end_str;
    
    my $remove_comps_xml="rm -rf $comps_xml_path";
    system($remove_comps_xml);
    $exitstatus = $? >> 8;
    if ( $exitstatus != 0)
    {
    print "\n Failed while removing temp comps.xml file \n";
    exit $exitstatus;
    }
    
    my $copy_comps_xml="mv $tmp_comps_xml_path $comps_xml_path";
    system($copy_comps_xml);
    $exitstatus = $? >> 8;
    if ( $exitstatus != 0)
    {
    print "\n Failed while copying generated comps.xml file \n";
    exit $exitstatus;
    }
    
    close READ;
    close OUT;
}


