#!/usr/local/bin/perl
# 
# $Header: linuxos_stage.pl 12-dec-2005.03:04:44 rattipal Exp $
#
# linuxos_stage.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      linuxos_stage.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#     Staging directive for linux os component
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rattipal    12/12/05 - Backport pshroff_bootfile_auto from main 
#    pshroff     11/30/05 - to support NAS mount commands for solaris as well as to use 
#                           one mount instead of three mounts in post section
#    suvmalho    09/20/05 - changing the default password encryption action to 
#                           enabled 
#    pshroff     09/03/05 - using 10.2agent RPM 
#    pshroff     08/29/05 - 
#    pshroff     08/24/05 - removing hardcoded timezone 
#    prayarot    08/21/05 - To support NAS 
#    pshroff     08/06/05 - using stagesharedmp in place of bootserver for 
#                           RPMs 
#    pshroff     07/31/05 - adding error handling exitstatus code 
#    pshroff     07/28/05 - adding oms.properties file in post section 
#    pshroff     07/24/05 - removed partitioning info
#    pshroff     07/21/05 - removing xconfig 
#    pshroff     06/30/05 - pshroff_map_shiphome
#    rbhanush    06/23/05 - removing isencrypted option 
#    rbhanush    06/10/05 - Adding more entries in kickstart
#    rbhanush    05/30/05 - Extracting rhelos.tar
#    rbhanush    05/24/05 - rbhanush_update_props
#    rbhanush    05/19/05 - Creation
# 

$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin";

use strict;

require "$ENV{EMDROOT}/sysman/admin/scripts/provisioning/provisionCommon.pl";

main();

sub main()
{
    print "Creating kickstart file\n";
    createAndAppendToKickstart("\n#Linux OS Part of Kickstart\n");
    print "Extracting rhelos.tar\n";
    my $tar_extract_cmd="tar -xvf rhelos.tar";
    system($tar_extract_cmd);
    my $exitstatus = $? >> 8;
    if ($exitstatus != 0)
    {
        print "\n Failed while untaring the OS Image Binary \n";
        exit $exitstatus;
    }

    #timezone
    my $osTimeZone = get_oraComponentProperty("NAME_TimeZone");
    my $useUtcClock = get_oraComponentProperty("NAME_UseUtcClock");
    my $osTimeZone_entry;
    if($useUtcClock eq "true")
    {
        $osTimeZone_entry="timezone --utc $osTimeZone \n";
    }
    else
    {
        $osTimeZone_entry="timezone $osTimeZone \n";
    }
    appendToKickstart($osTimeZone_entry);

    #my $dummy_passwd="rootpw --iscrypted $1$UOG2nAQn$J745.WTWWcluPTszuUgBy/";
    my $passwd= get_oraComponentProperty("NAME_RootPassword");

    #password encryption option
    my $passwd_encrypt= get_oraComponentProperty("NAME_RootPasswordEncrypt");
    my $passwd_entry="rootpw --iscrypted $passwd \n";
    my $passwd_encrypt_entry="authconfig --enablemd5 \n";
    if($passwd_encrypt eq "false")
    {
        $passwd_entry="rootpw $passwd \n";
        $passwd_encrypt_entry="authconfig \n";
    }
    appendToKickstart($passwd_entry);
    appendToKickstart($passwd_encrypt_entry);

    #text/install mode
    my $installMode = get_oraComponentProperty("NAME_InstallMode");
    
    my $textMode = "text\n";
    my $graphicMode = "\n";

    my $installMode_entry = ( $installMode eq "true") ? $graphicMode : $textMode;    
    appendToKickstart($installMode_entry);

    #Get Base URl and always relplace Stage Dir with BaseURl entry
    my $stageTopDir=get_oraProperty("NAME_StageSharedMountPoint");
    my $base_url = get_oraProperty("NAME_StageBaseUrl");
    print "\n Base URL is:$base_url\n";
    my (@url_info, $len, $count, $url_entry, $dir, $nfs_host_name, $nfs_host_dir);
    @url_info = split /\/+/ ,$base_url ;
    $len = $#url_info;
    for($count=1;$count<=$len;$count++)
    {
        $url_entry=$url_info[$count];
        if($count ==1)
        {
            $nfs_host_name = $url_info[$count];
        }
        if($count >1)
        {
            $nfs_host_dir = $nfs_host_dir."/".$url_info[$count];
        }
    }
    print "\n Host is:$nfs_host_name and Directory is :$nfs_host_dir\n";
    createNFSEntry($nfs_host_name, $nfs_host_dir, $stageTopDir);

    #Create link for ref-anaconda-ks.cfg for image directive
    my $currentfolder_cmd="pwd";
    my $currentfolder=`$currentfolder_cmd`;
    chomp $currentfolder;
    print "Current folder is: $currentfolder\n";

    #Remove link first
    my $remove_cmd="rm -rf ../ref-anaconda-ks.cfg";
    system($remove_cmd);
    $exitstatus = $? >> 8;
    if ($exitstatus != 0)
    {
        print "\n Failed while removing reference kickstart file link \n";
        exit $exitstatus;
    }

    #Create a new link
    my $createlink_cmd="ln -sf $currentfolder/anaconda-ks.cfg ../ref-anaconda-ks.cfg";
    system($createlink_cmd);
    $exitstatus = $? >> 8;
    if ($exitstatus != 0)
    {
        print "\n Failed while creating link for reference kickstart file \n";
        exit $exitstatus;
    }

    #Creating post section script
    createPostSectionFile($nfs_host_name, $nfs_host_dir, $stageTopDir);
    #Create package definition file
    createPackageSectionFileEx($nfs_host_name, $nfs_host_dir, $stageTopDir);
    appendToKickstart("\n\n");
}

#This method creates a new file holding package section of the kickstart file. 
#package-ks.cfg will be created.
#It assumes that rpms_list.txt file is present at the same level 
#where the current perl script is present.
sub createPackageSectionFileEx()
{
    my ($nfs_host_name,$nfs_host_dir,$stage_top_dir) = @_;

    my ($package_file, $full_rpm_name, $rpm_entry);
    #Create package-ks.cfg
    $package_file="package-ks.cfg";
    open OUT, ">$package_file" or die "Can not create rpm package file : $!" ;

    #Add the package header
    print OUT "\n\n%packages\n";

    #Get the current stage folder
    my $currentfolder_cmd="pwd";
    my $currentfolder=`$currentfolder_cmd`;
    chomp $currentfolder;
    #$currentfolder=~ s/$stage_top_dir/$nfs_host_dir/;

    my $rpms_location="/LinuxOSRoot/RedHat/RPMS";
    $rpms_location=$currentfolder.$rpms_location;
    chdir $rpms_location or die "Can not change to $rpms_location location";
    my $all_rpms="*.rpm";
    my $get_rpms_cmd="ls $all_rpms";
    my @rpms_for_kickstart=`$get_rpms_cmd`;
    my $exitstatus = $? >> 8;
    if ($exitstatus != 0)
    {
        print "\n Failed while getting the list of RPMs \n";
        exit $exitstatus;
    }

    foreach $full_rpm_name (@rpms_for_kickstart)
    {
        $rpm_entry=removeVerAndRelInfo($full_rpm_name);
        print OUT "$rpm_entry\n";
    }

    close OUT;
}

#This method removes version and release no information from the rpm package name.
#Example: Input: telnet-0.17-26 Output: telnet
sub removeVerAndRelInfo()
{
    my ($rpm_name)=@_;
    my (@rpm_info, $len, $count, $rpm_entry, $rpm_package_name);
    my (@rpm_name_no_ver);  

    @rpm_info = split /-/,$rpm_name ;
    $len = $#rpm_info;

    for($count=0;$count<=$len-2;$count++)
    {
        $rpm_entry=$rpm_info[$count];
        chomp $rpm_entry;
        push @rpm_name_no_ver, $rpm_entry;
    }

    $rpm_package_name = join "-",@rpm_name_no_ver;
    
    return $rpm_package_name;
}

# This method creates a new file holding post section of the kickstart file. 
# post section should be
#
#%post
# rpm --import /usr/share/rhn/RPM-GPG-KEY
# mkdir /emagent-extra
# mount <nas-server>:<nas-dir> /emagent-extra
# rpm -ivh /emagent-extra/emagent-10.2.0.0.0-1.i386.rpm
#
# mkdir /provision
#
# cp /emagent-extra/Images/<image-hw>/<os-comp>/oms.prop /provision
#
# cp /emagent-extra/Images/<image-hw>/oms.properties /provision
#
# cleanup
# umount /emagent-extra
# rm -rf /emagent-extra
#
# post-ks.cfg will be created.
sub createPostSectionFile()
{
    my ($nfs_host_name_mount,$nfs_host_dir_mount,$stage_top_dir) = @_;

    print "\ Mount host name:$nfs_host_name_mount, Mount Dir:$nfs_host_dir_mount\n";
      
    #Create post-ks.cfg
    my $post_file="post-ks.cfg";
    open OUT, ">$post_file" or die "Can not create post section file : $!" ;

    #Add the post header
    print OUT "\n%post\n";   

    #rpm --import /usr/share/rhn/RPM-GPG-KEY
    my $rpm_gpg_key="rpm --import /usr/share/rhn/RPM-GPG-KEY";
    print OUT "$rpm_gpg_key\n";

    my $emagent_extra_folder="/emagent-extra";
    #mkdir /emagent-extra
    my $create_folder="mkdir $emagent_extra_folder";
    print OUT "$create_folder\n";

    my $nfs_mount_src_loc=$nfs_host_name_mount.":".$nfs_host_dir_mount;
    my $mount_entry="mount ".$nfs_mount_src_loc." ".$emagent_extra_folder;
    print OUT "$mount_entry\n";

    #rpm -ivh emagent-10.2.0.0.0-1.i386.rpm 
    my ($rpm_install, $emagent_rpm_name, $stage_base_url, $emagent_rpm_entry);
    $rpm_install="rpm -ivh ";
    $emagent_rpm_name="emagent-10.2.0.0.0-1.i386.rpm";
    $stage_base_url=$emagent_extra_folder."/";
    $emagent_rpm_entry=$rpm_install.$stage_base_url.$emagent_rpm_name;
    print OUT "$emagent_rpm_entry\n"; 
 
    my $provision_folder="/provision"; 
    print OUT "mkdir $provision_folder\n";
 
     #Get the current stage folder
    my $currentfolder_cmd="pwd";
    my $currentfolder=`$currentfolder_cmd`;
    chomp $currentfolder;
    $currentfolder=~ s/$stage_top_dir/$emagent_extra_folder/;
    
    #cp /emagent-extra/oms.prop /usr/lib/oracle/emagent_10g/
    my $cp_oms_prop="cp $currentfolder/oms.prop $provision_folder";
    print OUT "$cp_oms_prop\n";
  
    #cp /emagent-extra/oms.properties /usr/lib/oracle/emagent_10g/
    my $cp_oms_properties="cp $currentfolder/../oms.properties $provision_folder";
    print OUT "$cp_oms_properties\n";

    my $cleanup_comment="#cleanup";
    print OUT "\n$cleanup_comment\n";
   
    my $umount="umount ".$emagent_extra_folder;
    print OUT "$umount\n"; 

    #rm -rf /emagent-extra
    my $rm_emagent_extra="rm -rf ".$emagent_extra_folder;
    print OUT "$rm_emagent_extra\n";

    close OUT;
}   

sub createNFSEntry()
{
    my ($mount_nfs_host_name,$mount_nfs_host_dir,$stage_top_dir) = @_;

    my $LinuxOSRootFolderName="LinuxOSRoot";

    #Get the ip address
    #my $ipaddress_cmd="hostname --ip-address";
    #my $stageserver_ip=`$ipaddress_cmd`;
    #chomp $stageserver_ip ;

    #Get the current folder
    my $redhat_loc_cmd="pwd";
    my $redhat_loc=`$redhat_loc_cmd`;
    chomp $redhat_loc ;
    $redhat_loc=~ s/$stage_top_dir/$mount_nfs_host_dir/;

    my $imagePath=$redhat_loc."/".$LinuxOSRootFolderName;

    #Create a new nfs entry
    my $nfs_entry="nfs --server $mount_nfs_host_name --dir $imagePath\n";

    appendToKickstart($nfs_entry);
}

sub appendToKickstart()
{
    my ($entry)=@_;
    
    my $ksfilename="linuxos-kickstart";
    #print "Writing entry $entry to kickstart file\n";
    
    open OUT, ">>$ksfilename" or die "Can find kickstart file" ;
    
    print OUT $entry;
    
    close OUT;
}

sub createAndAppendToKickstart()
{
    my ($entry)=@_;
    my $ksfilename="linuxos-kickstart";
    #print "Writing entry $entry to kickstart file\n";
    
    open OUT, ">$ksfilename" or die "Can find kickstart file" ;
    
    print OUT $entry;
    
    close OUT;
}
