#!/usr/local/bin/perl
# 
# $Header: network_stage.pl 01-aug-2005.06:27:40 pshroff Exp $
#
# network_stage.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      network_stage.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    pshroff     08/01/05 - 
#    pshroff     07/22/05 - removing static addrtype
#    pshroff     06/30/05 - pshroff_map_shiphome
#    rbhanush    06/23/05 - static fix 
#    rbhanush    06/21/05 - fixing static/dynamic entry 
#    rbhanush    06/19/05 - rbhanush_default_dirs
#    rbhanush    06/01/05 - Creation
# 

$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin";

use strict;

require "$ENV{EMDROOT}/sysman/admin/scripts/provisioning/provisionCommon.pl";

#Staging directive for network profile component

main();

sub main()
{
	print "Creating kickstart file\n";

	#Network Adapater Information
	my $deviceName = get_oraComponentProperty("NAME_NetworkConfig[0].NAME_DeviceName");
	my $addrType = get_oraComponentProperty("NAME_NetworkConfig[0].NAME_AddrType");
	
	my $networkprofile_entry;
	if($addrType=~/ADDR_Dynamic/)
	{
	    $addrType="dhcp";
	    
	    $networkprofile_entry="network --bootproto=$addrType --device=$deviceName";
	}
	else
	{
	    my $hostName = get_oraComponentProperty("NAME_NetworkConfig[0].NAME_Hostname");
	    my $domainName = get_oraComponentProperty("NAME_NetworkConfig[0].NAME_DomainName");
	    
	    my $ipAddr = get_oraComponentProperty("NAME_NetworkConfig[0].NAME_IPAddr");
	    my $subnetMask = get_oraComponentProperty("NAME_NetworkConfig[0].NAME_SubnetMask");
	    my $gateway = get_oraComponentProperty("NAME_NetworkConfig[0].NAME_Gateways");
	    my $dnsserver = get_oraComponentProperty("NAME_NetworkConfig[0].NAME_DNSServers");
	    
	    $addrType="static";
	    
	    $networkprofile_entry="network --device $deviceName --bootproto $addrType --ip $ipAddr --netmask $subnetMask --gateway $gateway --nameserver $dnsserver --hostname $hostName.$domainName\n";
	}


	appendToKickstart($networkprofile_entry);

}

sub appendToKickstart()
{
    
    my ($entry)=@_;
    
    my $ksfilename="network-kickstart";
    open OUT, ">$ksfilename" or die "Cant find kickstart file: $!" ;
	
    print OUT $entry;
    
    close OUT;
}

