#!/usr/local/bin/perl
# 
# $Header: provisionBootAndReset.pl 09-feb-2006.19:57:40 rattipal Exp $
#
# provisionBootAndReset.pl
# 
# Copyright (c) 2005, 2006, Oracle. All rights reserved.  
#
#    NAME
#      provisionBootAndReset.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rattipal    02/09/06 - Backport rattipal_bootreset from main 
#    rattipal    02/02/06 - Fix 4997566 
#    rmadampa    09/25/05 - changing reboot path 
#    prayarot    08/23/05 - adding default path in env 
#    pshroff     07/05/05 - adding error handling code=> to exit with failure, 
#                           in case of errors 
#    pshroff     06/30/05 - pshroff_map_shiphome
#    pshroff     06/21/05 - to corrupt both hda and sda drive 
#    pshroff     04/16/05 - modfying to update the atual command instead of mkdir command used for testing 
#    prayarot    04/13/05 - prayarot_intg_mar18
#    prayarot    04/11/05 - Creation
# 
$ENV{PATH} = "/sbin:/bin:/usr/bin:/usr/local/bin:/usr/sbin";

use strict;


main();

sub main()
{
    clearBootSector();
    rebootMachine();
}

sub clearBootSector()
{
    my $exitstatus;
    my $mbr;
    my $mbrCorruptCommand;
    my $fname="/boot/grub/device.map";
    my $mbrpathcommand;
    
    if ( -e $fname && -r $fname)
    {
	$mbrpathcommand= "grep \'(hd0)\' $fname  | tr -s \" \" | cut -f 2 -d \" \"";
    $mbr=`$mbrpathcommand`;
	chomp($mbr);
	}
    else
    {
	$mbrpathcommand="mount | grep \" / \" | cut -f 1 -d \" \"";
	$mbr=`$mbrpathcommand`;
	chomp($mbr);
	$mbr=~ s/(.*?)(\d+)$/$1/;
    }
    
    $mbrCorruptCommand="dd if=/dev/zero of=$mbr bs=512 count=1";
    system($mbrCorruptCommand);
    $exitstatus = $? >> 8;
    if ($exitstatus != 0)
    {
	print "\n Failed to Corrupt the Boot Sector on $mbr\n";
	exit $exitstatus;
    }
    print "\n Successfuly Corrupted the Boot Sector on $mbr \n";
}

sub rebootMachine()
{
    my $rebootCommand = "reboot";
    system($rebootCommand);
    my $exitstatus = $? >> 8;
    
    if ($exitstatus != 0)
    {
	print "\n Failed to Reboot the target machine \n";
	exit $exitstatus;
    }
    print "\n Successfully executed the command to reboot the target machine \n";
}

