# 
# $Header: provisionCommon.pl 11-jan-2006.01:43:57 pshroff Exp $
#
# provisionCommon.pl
# 
# Copyright (c) 2005, 2006, Oracle. All rights reserved.  
#
#    NAME
#      provisionCommon.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This script will be used by the directives script writer to access
# directive/component/assignment properties. Its a utility script and can be 
# used by the executor code as well as directive script to get propertyValue, 
# given the propertyName.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    pshroff     01/03/06 - adding regex start/end exp for using propName as 
#                           it is in regEx eval 
#    pshroff     01/11/06 - Backport pshroff_bug-4921988 from main 
#    rattipal    12/08/05 - Backport pshroff_stage_url from main 
#    pshroff     11/07/05 - modifying to fix bug related to = token 
#    pshroff     11/28/05 - removing test code to fix bug#4761838 
#    rattipal    12/08/05 - Backport pshroff_bug-4761838 from main 
#    pshroff     12/01/05 - removing extra newline and print mesg 
#    pshroff     12/01/05 - removing extra newline and print mesg 
#    rattipal    12/12/05 - Backport pshroff_bootfile_auto from main 
#    pshroff     09/02/05 - removing debug mesg printing 
#    pshroff     08/23/05 - removing prefix "." to support standalonedirectives 
#    pshroff     06/30/05 - pshroff_map_shiphome
#    pshroff     05/13/05 - adding get_oraComponentFilename method 
#    pshroff     04/19/05 - better indentation plus removed unwanted methods/variables...
#    pshroff     04/13/05 - Creation
# 
use strict;

first();

sub first()
{
    print "\n";
}

sub get_oraComponentFilename()
{
    my $filename = $ENV{COMPONENT_FILENAME};
    return $filename;
}


sub get_oraDirectiveProperty()
{
    my ($propertyName) = @_;

    my $output;
    my $rootPropertyPath;
    my $fullPropertyName;

    $rootPropertyPath = $ENV{DIRECTIVEPATH} ;

    if ($rootPropertyPath) 
    {
        $fullPropertyName =  $rootPropertyPath . ".$propertyName";
    }
    else
    {
        $fullPropertyName =  $propertyName;
    }
  
    return get_oraProperty($fullPropertyName);
}

sub get_oraComponentProperty()
{
    my ($propertyName) = @_;
    my $output;
    my $rootPropertyPath;
    my $fullPropertyName;
    
    $rootPropertyPath = $ENV{COMPONENTPATH} ; 
    
    if ($rootPropertyPath) 
    {
        $fullPropertyName =  $rootPropertyPath . ".$propertyName";
    }
    else
    {
        $fullPropertyName =  $propertyName;
    }

    return get_oraProperty($fullPropertyName);

}

sub get_oraProperty()
{
    my ($propertyName) = @_;

    my $propertyFilePath;
    my $propertyVal;

    print "\n get_oraProperty: Property Name is $propertyName ";

    $propertyFilePath = $ENV{PROPERTY_FILEPATH};
 
    $propertyVal = getPropertyValue($propertyFilePath, $propertyName);

    return $propertyVal;
}


sub getPropertyValue()
{
    my ($propertyFile, $propertyName) = @_;
    
    my $token = "=";

    my $output = getKeyValue($propertyName, $propertyFile, $token);
    
    return $output;
}

sub getKeyValue()
{
    my ($inputKey, $propertyFile, $token) = @_;
    my ($value, $property);

    open FILEHANDLE, "<$propertyFile" or die "can't open $propertyFile $!";

    while ($property = <FILEHANDLE> )
    {
        if($property =~ m/\Q$inputKey\E\s*$token\s*(.+)/)
        {
            my $value = $1;
            close (FILEHANDLE);
            return trim($value);
        }

    }
    close (FILEHANDLE);

    return;

};


sub trim
{
    my @out = @_;
    for (@out) 
    {
        s/^\s+//;
        s/\s+$//;
    }
    return wantarray ? @out : $out[0];
};



sub stripComments()
{
    my ($entry)=@_;
    if($entry =~ /^[\#]/)
    {
	    $entry =~ s/\#//;
    }
    return $entry;
}

sub findAndReplace()
{
    my ($string, $find, $replace) = @_;
                                                                                
    $string =~ s/$find/$replace/g ;
                                                                                
    return $string;
};
 
                                                                                        
sub trimZeroes()
{
    my @value = @_;
                                                                                
    for (@value)
    {
        s/0+$//;
    }
    return $value[0];
};
