#!/usr/local/bin/perl
#
# $Header: AS-INSTALL-10.1.2.0.2.pl 05-dec-2005.21:21:23 rattipal Exp $
#
# AS-INSTALL-10.1.2.0.2.pl
#
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      AS-INSTALL-10.1.2.0.2.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rattipal    12/05/05 - Backport rattipal_mytrans from main 
#    rattipal    11/09/05 -rattipal update 
#    kashukla    09/09/05 - kashukla_bug-4592807
#    kashukla    09/07/05 - Creation
#


$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin";

use strict;

require "$ENV{EMDROOT}/sysman/admin/scripts/provisioning/provisionCommon.pl";


main();

sub main()
{
    print "\nInstalling Single Instance Application Server";
    my $exitstatus ;

    #get the path where the AS shiphome is located on the target machine.
    my $currentfolder_cmd="pwd";
    my $currentfolder=`$currentfolder_cmd`;
    chomp $currentfolder;
    print "\nCurrent folder is: $currentfolder";

    #get the name of the tar file associated with the AS component.
    my $binaryFile = get_oraComponentFilename();

    # installFilePath variable stores the location of the AS tar file.
    print "\nComponent binary filename is $binaryFile";
    my $installFilePath="$currentfolder/$binaryFile";
    print "\nComponent binary filepath is $installFilePath";


    #constants
    my $ORACLE_HOME = "ORACLE_HOME";
    my $ORACLE_HOME_NAME = "ORACLE_HOME_NAME";
    my $AS_PASSWD = "AS_PASSWD";
    my $LANGUAGE = "LANGUAGE";
    my $INSTANCE_NAME = "INSTANCE_NAME";
    my $INSTALL_USER = "INSTALL_USER";
    my $WORKING_DIR = "WORKING_DIR";

    # Get all the AS Component properties specified by user during creation time.
    my $oracleHome = get_oraComponentProperty($ORACLE_HOME);
    my $oracleHomeName = get_oraComponentProperty($ORACLE_HOME_NAME);
    my $asPasswd = get_oraComponentProperty($AS_PASSWD);
    my $language = get_oraComponentProperty($LANGUAGE);
    my $instanceName = get_oraComponentProperty($INSTANCE_NAME);
    my $installUser = get_oraComponentProperty($INSTALL_USER);
    my $workingDir = get_oraComponentProperty($WORKING_DIR);

    # Location of the default Response file.
    my $defaultResponseFile = $workingDir."/Disk1/stage/Response/10.1.2.0.2ASInstall.rsp";

    # Log file for the installation
    my $logFile = "/tmp/as-installer.out";

    # Data Structure that will hold the command line parameters.
    my %cmdLineParam;

    # Check if the user has specified the required Component properties.
    # If not, exit displaying proper error message

    my $errorMsg = "";
    my $flag = 0;

    if (!($oracleHome=~/null/ || $oracleHome eq '')) 
    {
        print "\nUser supplied ORACLE_HOME:$oracleHome";
        $cmdLineParam{$ORACLE_HOME} = $oracleHome;
    }
    else
    {
        $flag = 1;
        $errorMsg = $errorMsg." $ORACLE_HOME";
    }

    if (!($oracleHomeName=~/null/ || $oracleHomeName eq '')) {
        print "\nUser supplied ORACLE_HOME_NAME:$oracleHomeName";
        $cmdLineParam{$ORACLE_HOME_NAME} = $oracleHomeName;
    }
    else
    {
        $flag = 1;
        $errorMsg = $errorMsg." $ORACLE_HOME_NAME";
    }

    if ($asPasswd=~/null/ || $asPasswd eq '')
    {
        $errorMsg = $errorMsg." $AS_PASSWD";
        $flag = 1;
    }

    if (!($instanceName=~/null/ || $instanceName eq '')) {
        print "\nUser supplied INSTANCE_NAME:$instanceName";
    }
    else {
        $errorMsg = $errorMsg." $INSTANCE_NAME";
        $flag = 1;
    }

    if (!($installUser=~/null/ || $installUser eq '')) {
        print "\nUser supplied $INSTALL_USER:$installUser";
    }
    else {
        $errorMsg = $errorMsg." $INSTALL_USER";
        $flag = 1;
    }

    if (!($workingDir=~/null/ || $workingDir eq '')) {
        print "\nUser supplied $WORKING_DIR:$workingDir";
        $workingDir = $workingDir."/";
    }
    else {
        $errorMsg = $errorMsg." $WORKING_DIR";
        $flag = 1;
    }

    if ($flag) {
        print "\nUser didnt specify $errorMsg. Specify as AS Component. Installation aborted. Exiting ... ";
        exit 1;
    }


    if (!($language=~/null/ || $language eq ''))
    {
        print "\nUser supplied LANGUAGE:$language";
        $cmdLineParam{"COMPONENT_LANGUAGES"} = "{\"$language\"}";
    }

    #add some commandLine params that are required for installation.

    $cmdLineParam{"LOCATION_FOR_DISK2"} = $workingDir."Disk2";
    $cmdLineParam{"LOCATION_FOR_DISK3"} = $workingDir."Disk3";
    $cmdLineParam{"LOCATION_FOR_DISK4"} = $workingDir."Disk4";

    # update the command Line params
    my $commandLine = &updateCommand(\%cmdLineParam);

    # create the working directory as $installUser user.
    system("sudo -u $installUser mkdir -p $workingDir");  
    $exitstatus = $? >> 8;
    if ($exitstatus != 0)
    {
        print "\nFailed while creating $workingDir directory.";
        exit $exitstatus;
    }

    chdir $workingDir; 
    $exitstatus = $? >> 8;
    if ($exitstatus != 0)
    {
        print "\nFailed while changing the directory.";
        cleanup($workingDir,$installUser);
        exit $exitstatus;
    } 

    # Untar the AS Shiphome as $installUser user.
    print "\nUntaring the AS Shiphome, This will take sometime. Please wait...";
    my $command = `sudo -u $installUser tar -zxvf $installFilePath`;
    $exitstatus = $? >> 8;
    if ($exitstatus != 0)
    {
        print "\nFailed while untaring the AS Shiphome.";
        cleanup($workingDir,$installUser);
        exit $exitstatus;
    }


    # Modify the response file to include instance and password info.
    system("sudo -u $installUser chmod 777 $defaultResponseFile");
    open (INFO, ">> $defaultResponseFile");
    print INFO "\niASinstanceName=\"$instanceName\"";
    print INFO "\niASinstancePW=\"$asPasswd\"";
    print INFO "\noracle.iappserver.instance:szl_InstanceInformation={\"$instanceName\",\"$asPasswd\",\"$asPasswd\"}";
    close (INFO);
    system("sudo -u $installUser chmod 755 $defaultResponseFile"); 



    # Run runInstaller as $installUser user.
    my $runInstaller = $workingDir."/Disk1/runInstaller -silent -ignoreSysPrereqs -waitForCompletion -noConfig $commandLine -responseFile $defaultResponseFile > $logFile";

    print "\nExecuting runInstaller This will take sometime. Please wait...";
    print "\n$runInstaller";

    $command = `sudo -u $installUser $runInstaller`;
    $exitstatus = $? >> 8;
    print "\n Exit Code: $exitstatus";

    if ($exitstatus != 0 && $exitstatus !=1)
    {
        print "\nFailed while Executing runInstaller";
        print "\nSee log file:$logFile for details";
        cleanup($workingDir,$installUser);
        exit $exitstatus;
    } 

    print "\nExecuting root.sh This will take sometime. Please wait...";

    my $rootExec=`echo | $oracleHome/root.sh -silent -waitForCompletion`;
    $exitstatus = $? >> 8;                                                  

    if ($exitstatus != 0)
    {
        print "\n Failed while executing root.sh";
        cleanup($workingDir,$installUser);
        exit $exitstatus;
    }

    # Now run the config tool command
    #set env variables
    delete($ENV{"CONSOLE_CFG"});
    delete($ENV{"EMSTATE"});
    $ENV{$ORACLE_HOME} = $oracleHome;
    $ENV{"LD_LIBRARY_PATH"} = "$oracleHome/lib:$ENV{LD_LIBRARY_PATH}";
    $ENV{"PERL5LIB"} = "$oracleHome/perl/lib:$oracleHome/perl/lib/5.6.1:$oracleHome/perl/lib/site_perl/5.6.1:$
    oracleHome/perl/lib/5.6.1/i686-linux:$oracleHome/perl/lib/5.6.1/i686-linux/auto";


    my $configCmd = `su -m $installUser $oracleHome/cfgtoollogs/configToolCommands >> $logFile`;
    $exitstatus = $? >> 8;
    print "\n Exit Code: $exitstatus";

    if ($exitstatus != 0 && $exitstatus !=1)
    {
        print "\nFailed while Executing Config Tools Commands";
        print "\nSee log file:$logFile for details";
        cleanup($workingDir,$installUser);
        exit $exitstatus;
    }

    cleanup($workingDir,$installUser);
    print "\nSuccessfully Installed the AS";
    exit 0;
}


sub cleanup()
{
    my $workingDir = $_[0];
	my $installUser = $_[1];
    system("sudo -u $installUser rm -rf $workingDir");  

    my $exitstatus = $? >> 8;
    if ($exitstatus != 0)
    {
        print "\nFailed while removing $workingDir dir";
        exit $exitstatus;
    }
}

sub updateCommand()
{
    my $hashref = $_[0];
    my $command;
    while ( my ($key, $value) = each(%$hashref) ) {
        $command = "$command $key=\"$value\"";
    }
    return $command;
}
