#!/usr/local/bin/perl
# 
# $Header: DB-INSTALL-10.2.pl 05-dec-2005.21:21:26 rattipal Exp $
#
# DB-INSTALL-10.2.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      DB-INSTALL-10.2.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rattipal    12/05/05 - Backport rattipal_mytrans from main 
#    rattipal    11/09/05 - To update the directives. 
#    kashukla    08/26/05 - kashukla_bug-4495359
#    kashukla    08/24/05 - Creation
#
$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin";

use strict;

require "$ENV{EMDROOT}/sysman/admin/scripts/provisioning/provisionCommon.pl";


main();

sub main()
{
    print "\nInstalling Enterprise Edition Database";
    my $exitstatus ;

    # Location of the Components dir.
    my $currentfolder_cmd="pwd";
    my $currentfolder=`$currentfolder_cmd`;
    chomp $currentfolder;
    print "\nCurrent folder is: $currentfolder";

    # Tar file associated with the component.
    my $binaryFile = get_oraComponentFilename();

    print "\nComponent binary filename is $binaryFile";
    my $installFilePath="$currentfolder/$binaryFile";
    print "\nComponent binary filepath is $installFilePath";


    # Constants
    my $ORACLE_HOME = "ORACLE_HOME";
    my $ORACLE_HOME_NAME = "ORACLE_HOME_NAME";
    my $INSTALL_TYPE = "INSTALL_TYPE";
    my $LANGUAGE = "LANGUAGE";
    my $INSTALL_USER = "INSTALL_USER";
    my $WORKING_DIR = "WORKING_DIR";
    my $DB_PASSWD = "DB_PASSWD";
    my $ORACLE_SID = "ORACLE_SID";

    # Get the property value specifed by the user.
    my $oracleHome = get_oraComponentProperty($ORACLE_HOME);
    my $oracleHomeName = get_oraComponentProperty($ORACLE_HOME_NAME);
    my $installType = get_oraComponentProperty($INSTALL_TYPE);
    my $language = get_oraComponentProperty($LANGUAGE);
    my $workingDir = get_oraComponentProperty($WORKING_DIR);
    my $installUser = get_oraComponentProperty($INSTALL_USER);
    my $oracleSid = get_oraComponentProperty($ORACLE_SID);
    my $dbPasswd = get_oraComponentProperty($DB_PASSWD);

    my $logFile = "/tmp/db-install.out";
    my $defaultResponseFile = $workingDir."/Disk1/response/10.2DBInstall.rsp";

    # Data Structure to hold property value.
    my %cmdLineParam;

    my $errorMsg = "";
    my $flag = 0;

    if (!($oracleHome=~/null/ || $oracleHome eq '')) 
    {
        $cmdLineParam{$ORACLE_HOME} = $oracleHome;
        print "\nUser supplied $ORACLE_HOME:$oracleHome";
    }
    else
    {
    	$errorMsg = $errorMsg." $ORACLE_HOME";
	$flag = 1;
    }

    if (!($oracleHomeName=~/null/ || $oracleHomeName eq ''))
    {
        $cmdLineParam{$ORACLE_HOME_NAME} = $oracleHomeName;
        print "\nUser supplied $ORACLE_HOME_NAME:$oracleHomeName";
    }
    else
    {
    	$errorMsg = $errorMsg." $ORACLE_HOME_NAME";
	$flag = 1;
    }

    if (!($oracleSid=~/null/ || $oracleSid eq ''))
    {
        $cmdLineParam{"s_dbSid"} = $oracleSid;
	$cmdLineParam{"s_globalDBName"} = $oracleSid;
        print "\nUser supplied $ORACLE_SID:$oracleSid";
    }
    else
    {
    	$errorMsg = $errorMsg." $ORACLE_SID";
	$flag = 1;
    }

    if ($dbPasswd=~/null/ || $dbPasswd eq '')
    {
    	$errorMsg = $errorMsg." $DB_PASSWD";
	$flag = 1;
    }


    if ($workingDir=~/null/ || $workingDir eq '')
    {
    	$errorMsg = $errorMsg." $WORKING_DIR";
	$flag = 1;
    }

    if ($installUser=~/null/ || $installUser eq '')
    {
    	$errorMsg = $errorMsg." $INSTALL_USER";
	$flag = 1;
    }


    if ($flag) {
	print "\nUser didnt specify $errorMsg. Specify as DB Component's property. Installation aborted. Exiting ....";
	exit 1;
    }

    if (!($installType=~/null/ || $installType eq ''))
    {
        $cmdLineParam{$INSTALL_TYPE} = $installType;
        print "\nUser supplied $INSTALL_TYPE:$installType";
    }


    if (!($language=~/null/ || $language eq ''))
    {
        $cmdLineParam{"SELECTED_LANGUAGES"} = "{\"$language\"}";
        $cmdLineParam{"COMPONENT_LANGUAGES"} = "{\"$language\"}";
        print "\nUser supplied $LANGUAGE:$language";
    }

    my $commandLine = &updateCommand(\%cmdLineParam);
    
    # Create the directory as install user.
    system("sudo -u $installUser mkdir -p $workingDir");  
    $exitstatus = $? >> 8;
    if ($exitstatus != 0)
    {
        print "\nFailed while creating $workingDir directory.";
        exit $exitstatus;
    }

    chdir $workingDir; 
    $exitstatus = $? >> 8;
    if ($exitstatus != 0)
    {
        print "\nFailed while changing the directory.";
        cleanup($workingDir, $installUser);
        exit $exitstatus;
    } 

    # Untar the shiphome as $installUser user.
    print "\nUntaring the DB Shiphome, This will take sometime. Please wait...";
    my $command = `sudo -u $installUser tar -zxvf $installFilePath`;
    $exitstatus = $? >> 8;
    if ($exitstatus != 0)
    {
        print "\nFailed while untaring the DB Shiphome.";
        cleanup($workingDir, $installUser);
        exit $exitstatus;
    }

    # Modify the response file to include the passwd information.
    system("sudo -u $installUser chmod 777 $defaultResponseFile");
    open (INFO, ">> $defaultResponseFile");
    print INFO "\nb_useSamePassword=true";
    print INFO "\ns_superAdminSamePasswd=\"$dbPasswd\"";
    print INFO "\ns_superAdminSamePasswdAgain=\"$dbPasswd\"";
    close (INFO);
    system("sudo -u $installUser chmod 755 $defaultResponseFile"); 


    # Run runInstaller command.
    my $runInstaller = $workingDir."/Disk1/runInstaller -silent -ignoreSysPrereqs -waitForCompletion -noConfig $commandLine -responseFile $defaultResponseFile  > $logFile";

    print "\nExecuting runInstaller This will take sometime. Please wait...";
    print "\n$runInstaller";


    $command = `sudo -u $installUser $runInstaller`;
    $exitstatus = $? >> 8;
    
    if ($exitstatus != 0)
    {
        print "\nFailed while Executing runInstaller";
        print "\nSee log file:$logFile for details";
        cleanup($workingDir, $installUser);
        exit $exitstatus;
    }



    # run root.sh also 
    print "\nExecuting root.sh This will take sometime. Please wait...";

    my $rootExec=`$oracleHome/root.sh -silent -waitForCompletion`;
    $exitstatus = $? >> 8;                                                  

    if ($exitstatus != 0)
    {
        print "\n Failed while executing root.sh";
        cleanup($workingDir, $installUser);
        exit $exitstatus;
    }

	# Now run the config tool command
    # Set env variables
    delete($ENV{"CONSOLE_CFG"});
    delete($ENV{"EMSTATE"});
    $ENV{$ORACLE_HOME} = $oracleHome;
    $ENV{"LD_LIBRARY_PATH"} = "$oracleHome/lib:$ENV{LD_LIBRARY_PATH}";
    $ENV{"PERL5LIB"} = "$oracleHome/perl/lib:$oracleHome/perl/lib/5.6.1:$oracleHome/perl/lib/site_perl/5.6.1:$oracleHome/perl/lib/5.6.1/i686-linux:$oracleHome/perl/lib/5.6.1/i686-linux/auto";


    my $configCmd = `su -m $installUser $oracleHome/cfgtoollogs/configToolAllCommands >> $logFile`;
    $exitstatus = $? >> 8;
    print "\n Exit Code: $exitstatus";

    if ($exitstatus != 0 && $exitstatus !=1)
    {
        print "\nFailed while Executing Config Tools Commands";
        print "\nSee log file:$logFile for details";
        cleanup($workingDir,$installUser);
        exit $exitstatus;
    }

    cleanup($workingDir, $installUser);
    print "\nSuccessfully Installed the DB";
    exit 0;
}

sub cleanup()
{
    my $workingDir = $_[0];
    my $installUser = $_[1];
    system("sudo -u $installUser rm -rf $workingDir");  

    my $exitstatus = $? >> 8;
    if ($exitstatus != 0)
    {
        print "\nFailed while removing $workingDir dir";
        exit $exitstatus;
    }
}

sub updateCommand()
{
    my $hashref = $_[0];
    my $command;
    while ( my ($key, $value) = each(%$hashref) ) {
        $command = "$command $key=\"$value\"";
    }
    return $command;
}
