# 
# $Header: disklayout-stage-directive.pl 05-aug-2005.12:03:44 pshroff Exp $
#
# disklayout_stage.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      disklayout_stage.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    pshroff     08/05/05 - pshroff_stagepath_dirs
#    pshroff     06/30/05 - Creation


$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin";

use strict;

require "$ENV{EMDROOT}/sysman/admin/scripts/provisioning/provisionCommon.pl";

#Staging directive for disk layout component

main();

sub main()
{
    print "Creating kickstart file\n";
    
    createAndAppendToKickstart("\n#Disk Layout Part of Kickstart\n");
    appendToKickstart("clearpart --all --initlabel\n");

    #root (/) partition information
    
    my $diskDeviceNameProperty="NAME_Partitions[0].NAME_DiskDeviceName";
    
    my $diskDeviceName = get_oraComponentProperty($diskDeviceNameProperty);
    my $i = 0;
    
    while ($diskDeviceName)
    {
        my $fileSystemType = get_oraComponentProperty("NAME_Partitions[$i].NAME_FileSysType");
        my $partitionSize = get_oraComponentProperty("NAME_Partitions[$i].NAME_PartitionSize");
     
        my $partition_entry;
 
        $diskDeviceName =~ s/\/dev\///;
    
        if ($fileSystemType=~/FS_swap/)
        {
            $fileSystemType="swap"; 

            $partition_entry="part $fileSystemType --ondisk $diskDeviceName --size $partitionSize";
        }
       else
       {
           if ($fileSystemType=~/FS_ext3/)
           {
                $fileSystemType = "ext3";
           }
           else
           {
                if ($fileSystemType=~/FS_ext2/)
                {
                    $fileSystemType = "ext2";
                }
           }
           
           my $mountPoint = get_oraComponentProperty("NAME_Partitions[$i].NAME_MountPoint");
     
           $partition_entry="part $mountPoint --fstype $fileSystemType --ondisk $diskDeviceName --size $partitionSize";
          
        }
        print "partition entry to add for partition-$i is $partition_entry\n";
        appendToKickstart("$partition_entry\n");
     
        # go for next partition ..
        $i = $i + 1;
        $diskDeviceNameProperty= "NAME_Partitions[$i].NAME_DiskDeviceName";
        $diskDeviceName = get_oraComponentProperty($diskDeviceNameProperty);
        if ($diskDeviceName eq "")
        {
            last;
        }
    }
    appendToKickstart("\n\n");
    
}

sub appendToKickstart()
{
    my ($entry)=@_;
    
    my $ksfilename="disklayout-kickstart";
    print "Writing entry $entry to kickstart file\n";
    
    open OUT, ">>$ksfilename" or die "Can find kickstart file" ;
    
    print OUT $entry;
    
    close OUT;
}


sub createAndAppendToKickstart()
{
    my ($entry)=@_;
    my $ksfilename="disklayout-kickstart";
    print "Writing entry $entry to kickstart file\n";
    
    open OUT, ">$ksfilename" or die "Can find kickstart file" ;
    
    print OUT $entry;
    
    close OUT;
}
 


