# 
# $Header: network-stage-directive.pl 05-aug-2005.12:03:45 pshroff Exp $
#
# network_stage.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      network_stage.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    pshroff     08/05/05 - pshroff_stagepath_dirs
#    pshroff     06/30/05 - Creation
#
 

$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin";

use strict;

require "$ENV{EMDROOT}/sysman/admin/scripts/provisioning/provisionCommon.pl";

#Staging directive for network profile component

main();

sub main()
{
    print "Creating Network Kickstart file\n";

    createAndAppendToKickstart("\n#Network Part of Kickstart\n");

    my $DeviceNameProperty = "NAME_NetworkConfig[0].NAME_DeviceName";

    my $deviceName = get_oraComponentProperty($DeviceNameProperty); 

    my $i = 0;
    while ($deviceName) 
    { 
        my $addrType = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_AddrType");
       
        my $networkprofile_entry;
        
        if($addrType=~/ADDR_Dynamic/)
        { 
            $networkprofile_entry="network --bootproto=dhcp --device=$deviceName\n"; 
        }
        else
        {    
            my $hostName = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_Hostname");
            my $domainName = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_DomainName");
            my $ipAddr = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_IPAddr");
            my $subnetMask = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_SubnetMask");
            my $gateway = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_Gateways");
            my $dnsserver = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_DNSServers");
            $networkprofile_entry="network --device $deviceName --bootproto static --ip $ipAddr --netmask $subnetMask --gateway $gateway --nameserver $dnsserver --hostname $hostName.$domainName\n";
        }        
        
        appendToKickstart($networkprofile_entry);

        # go for next interface ..
        $i = $i + 1;
        $DeviceNameProperty= "NAME_NetworkConfig[$i].NAME_DeviceName";
        $deviceName = get_oraComponentProperty($DeviceNameProperty);
        if ($deviceName eq "")
        {
            last;
        }

    }
    appendToKickstart("\n\n");
}


sub appendToKickstart()
{
    my ($entry)=@_;
    
    my $ksfilename="network-kickstart";
    print "Writing entry $entry to kickstart file\n";
    
    open OUT, ">>$ksfilename" or die "Can find kickstart file" ;
    
    print OUT $entry;
    
    close OUT;
}


sub createAndAppendToKickstart()
{
    my ($entry)=@_;
    my $ksfilename="network-kickstart";
    print "Writing entry $entry to kickstart file\n";
    
    open OUT, ">$ksfilename" or die "Can find kickstart file" ;
    
    print OUT $entry;
    
    close OUT;
}


