# $Header: batserver.pl
#
# batserver.pl
# 
# Copyright (c) 2002, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME:       batserver.pl - PeopleSoft Process Scheduler Discovery
#   DESCRIPTION
#       Used to discover PeopleSoft Process Scheduler configuration settings.
#   RETURNS:    em_result=<property>|<value>
#   NOTES
#       The prcsschd.psft file is created when PSEMAgent registers to PSEMHUB.
#
#   MODIFIED    (MM/DD/YY)
#   pparida     10/16/07 - Fix bug 6492554: Use CCR_CONFIG_HOME for OCM log,
#                          state and config dirs.
#   ndutko      02/12/06 - Initial PSFT Target checkin - for MTAMURA 
#   ndutko      02/12/06 - Initial PSFT Target checkin - for MTAMURA 
#   mtamura     09/22/05 - Creation
# 

use strict;
use ias::simpleXPath;
use psft::ccr;

my ($query, $file, $type) = @ARGV;

my $ccrHomeState = $ENV{CCR_CONFIG_HOME} . "/state";
my $toPrint="em_result=";


# validate parameters.
if ((@ARGV) < 2)
{
    printf "%s\n\n", "Outputs PeopleSoft Process Scheduler configuration settings.";
    printf "%s\n\n", "batserver.pl ccrHomeState xmlquery";
    printf "%s\t%s\n", "  ccrHomeState", "Specifies the path to CCR state directory.";
    printf "%s\t%s\n", "  xmlquery", "Specifies xpath query used to find configuration setting.";
    printf "%s\t%s\n", "  fileName", "Specifies file name of the PeopleSoft dump file.";
}
if ($ccrHomeState eq '')
{
    printf "%s\n", "em_warning=The ccr state directory was not specified.";
    exit;
}
if ($query eq '')
{
    printf "%s\n", "em_warning=The xpath query for was not specified.";
    exit;
}
if ($file eq '')
{
    printf "%s\n", "em_warning=The xml dump file was not specified.";
    exit;
}

my $registryFile = "$ccrHomeState/temp/".$file;

if( -f $registryFile)
{
    # prcsschd.psft file found.
    my @topLevelComponents = simpleXPathQuery($registryFile, "components/prcsschd");
    for my $topLevelComponent (@topLevelComponents)
    {
        # found a domain.
        my $domain = $$topLevelComponent{'domain'};
        my $configpath = $$topLevelComponent{'configpath'};
        
        # get hostname
        my $host;
        my @myhosts = simpleXPathQuery($registryFile, 'components/prcsschd/domain_info/domain');
        for my $myhost (@myhosts)
        {
            if ($$myhost{'hostname'} ne '')
            {
                $host = $$myhost{'hostname'};
            }
        }
        
        # now search for the specified configuration settings.
      		if( $type == 1 ) {
                # output database languages installed.
				output_columns($query,$registryFile);# end for - configuration settings 
			}else{
				# output database languages installed.
				output_namevalues($query,$registryFile);# end for - configuration settings
			}
    } # end for - domain
}

# parse table sections
sub output_columns
{
    my $query = $_[0];
    my $registryFile = $_[1];
    my @subComponents = simpleXPathQuery($registryFile, "components/prcsschd/$query");
	my $keyval;
    my $valval;
   if(defined @subComponents)
    {
				for (my $i = 0; $i < @subComponents; $i++){   # looping through all the properties of the configuration setting.
				 # looping through all the properties of the configuration setting.
					 my $hashref = $subComponents[$i];
					 my %hash = %$hashref;
					    $toPrint="em_result=";
						foreach my $key (sort keys %hash){
							$toPrint = $toPrint.$hash{$key}.'|';
						}
						print "$toPrint\n";	
				} # end for - configuration settings
    }
} # end sub - columns

# parse key/value pair sections
sub output_namevalues
{
    my $query = $_[0];
    my $registryFile = $_[1];
	my $keyval;
    my $valval;
    my @subComponents = simpleXPathQuery($registryFile, "components/prcsschd/$query");
	if(defined @subComponents){
		for (my $i = 0; $i < @subComponents; $i++) {               
                # looping through all the properties of the configuration setting.
                my $hashref = $subComponents[$i];
                my %hash = %$hashref;
				   while ( my ($key, $value) = each %hash) {
                    $keyval = $key;
                    $valval = $value;
					 printf "em_result=%s|%s\n", $keyval, $valval;

                }
               
        } # end for - configuration settings
	} # end if 
} # end sub - output_namevalues
