# $Header: ccr.pm
#
# ccr.pm
# 
# Copyright (c) 2005, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME:       ccr.pm - Common routines for PeopleSoft CCR
#   DESCRIPTION
#       Used to handle common routines for the CCR process.
#   SUBS:    getCCRDumpFiles - the file to the peoplesoft configuration dump.
#   NOTES
#
#   MODIFIED    (MM/DD/YY)
#   ndutko      03/12/09 - Fixes to support the correct form of
#                          simpleXPathQuery()
#   pparida     10/17/07 - XbranchMerge pparida_bug-6492554 from st_emll_10.2.7
#   pparida     10/15/07 - Fix bug 6492554: Use CCR_CONFIG_HOME for OCM log,
#                          state and config dirs.
#   ndutko      02/12/06 - Initial PSFT Target checkin - for MTAMURA 
#   ndutko      02/12/06 - Initial PSFT Target checkin - for MTAMURA 
#   mtamura     09/22/05 - Creation
# 

use strict;

use File::Copy;
use File::Spec;

sub getCCRDumpFiles
{
    my $psftDumpDir = $_[0];
    my $ccrHomeDumpDir = $_[1];
    my $prefix = $_[2];

    opendir(DIR,$psftDumpDir);
    my @files = grep {/^$prefix.*\.psft$/} readdir(DIR);
    if (defined @files)
    {
        foreach my $file (@files)
        {
            move(File::Spec->catdir($psftDumpDir, $file),
                 File::Spec->catdir($ccrHomeDumpDir, 'temp', $file));
        }
    }
    else
    {
        closedir (DIR);
        $ccrHomeDumpDir = File::Spec->catdir($ccrHomeDumpDir,'temp');
        opendir(DIR, $ccrHomeDumpDir);
        @files = grep {/^$prefix.*\.psft$/} readdir(DIR);
    }
    closedir (DIR);
    return @files;
}
return 1;
