# $Header: database.pl
#
# database.pl
# 
# Copyright (c) 2002, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME:       database.pl - PeopleSoft Database Discovery
#   DESCRIPTION
#       Used to discover PeopleSoft Database configuration settings.
#   RETURNS:
#       type 1 returns database info em_result=<guid>|<property>|<value>
#       type 2 returns installed languages em_result=<guid>|<language>
#       type 3 returns installed patches em_result=<guid>|<fixoprid>|<maintlogtype>|<updateid>
#       type 4 returns tools version em_result=<guid>|<property>|<value>
#       type 5 returns rows of name value pairs em_result=<guid>|<property>|<value>
#       type 6 returns rows of tables em_result=<guid>|columnvalue
#   NOTES
#       The database.psft file is created when PSEMAgent registers to PSEMHUB.
#
#   MODIFIED    (MM/DD/YY)
#   pparida     10/16/07 - Fix bug 6492554: Use CCR_CONFIG_HOME for OCM log,
#                          state and config dirs.
#   ndutko      02/12/06 - Initial PSFT Target checkin - for MTAMURA 
#   ndutko      02/12/06 - Initial PSFT Target checkin - for MTAMURA 
#   mtamura     09/22/05 - Creation
# 

use strict;
use ias::simpleXPath;
use psft::ccr;

my ($type, $file, $query) = @ARGV;

my $ccrHomeState = $ENV{CCR_CONFIG_HOME} . "/state";
my $toPrint="em_result=";

# validate parameters.
if ((@ARGV) < 2)
{
    printf "%s\n\n", "Outputs PeopleSoft Database configuration settings.";
    printf "%s\n\n", "database.pl type fileName";
    printf "%s\t%s\n", "  type", "Specifies the type of database information to output.";
    printf "%s\t%s\n", "  fileName", "Specifies file name of the PeopleSoft dump file.";
	printf "%s\t%s\n", "  xmlquery", "Specifies xpath query used to find configuration setting.";
    
}
if ($ccrHomeState eq '')
{
    printf "%s\n", "em_warning=The ccr state directory was not specified.";
    exit;
}
if ($type eq '')
{
    printf "%s\n", "em_warning=The type of database information was not specified.";
    exit;
}
if ($file eq '')
{
    printf "%s\n", "em_warning=The xml dump file was not specified.";
    exit;
}
if (($type == 5 || $type == 6) && ($query eq '')) {
	printf "%s\n", "em_warning=Query not specified.";
    exit;
}
my $registryFile = "$ccrHomeState/temp/".$file;

if( -f $registryFile)
{   # database.psft file found.
    my @topLevelComponents = simpleXPathQuery($registryFile, "components/app");
    for my $topLevelComponent (@topLevelComponents)
    {   # found a guid.
        my $guid = $$topLevelComponent{'guid'};
        
        if ($type == 1)
        {   # output database info properties.
            output_db_name_value($guid, 'database_info/database', $registryFile);
        }
        elsif ($type == 2)
        {   # output database languages installed.
            output_languages($guid, $registryFile);
        }
        elsif ($type == 3)
        {   # output database patches installed.
            output_patches($guid, $registryFile);
        }
        elsif ($type == 4)
        {   # output database version properties.
            output_db_name_value($guid, 'database_version/database', $registryFile);
        } elsif ($type == 5)
        {   # output name value properties.
			 output_namevalues($guid, $query, $registryFile);
        } elsif ($type == 6)
        {   # output table rows.
            output_columns($guid, $query, $registryFile);
        }
    } # end for - domain
}

sub output_languages
{
    my $guid = $_[0];
    my $registryFile = $_[1];

    my @subComponents = simpleXPathQuery($registryFile, 'components/app[@guid="'.$guid.'"]/languages/language');
    if(defined @subComponents)
    {
        for (my $i = 0; $i < @subComponents; $i++)
        {   # looping through all the languages.
            my $language = $subComponents[$i]{'name'};
            printf "em_result=%s\n", $language;
        } # end for - configuration settings
    } # end if - configuration settings found
} # end sub - output_languages

sub output_patches
{
    my $guid = $_[0];
    my $registryFile = $_[1];
    my $test = simpleXPathQuery($registryFile, 'components/app[@guid="'.$guid.'"]/patches/patch');
    my @subComponents = simpleXPathQuery($registryFile, 'components/app[@guid="'.$guid.'"]/patches/*/');
    if(defined @subComponents)
    {   # patches were found in this database.
        for (my $i = 0; $i < @subComponents; $i++)
        {   # looping through all the properties of the configuration setting.
            my $fixoprid = $subComponents[$i]{'fixoprid'};
            my $maintlogtype = $subComponents[$i]{'maintlogtype'};
            my $updateid = $subComponents[$i]{'updateid'};
            printf "em_result=%s|%s|%s\n", $fixoprid, $maintlogtype, $updateid;
        } # end for - configuration settings
    } # end if - configuration settings found
} # end sub - output_patches

sub output_db_name_value
{
    my $guid = $_[0];
    my $query = $_[1];
    my $registryFile = $_[2];
    my @subComponents = simpleXPathQuery($registryFile, 'components/app[@guid="'.$guid.'"]/'.$query);
    if(defined @subComponents)
    {   # the specified configuration setting was found.
        my $keyval;
        my $valval;

        for (my $i = 0; $i < @subComponents; $i++)
        {   # looping through all the properties of the configuration setting.
            my $hashref = $subComponents[$i];
            my %hash = %$hashref;
            while ( my ($key, $value) = each %hash) {
                $keyval = $key;
                $valval = $value;
            }
            printf "em_result=%s|%s\n", $keyval, $valval;
        } # end for - configuration settings
    } # end if - configuration settings found
} # end sub - output_db_name_value

# parse table sections
sub output_columns
{   my $guid = $_[0];
    my $query = $_[1];
    my $registryFile = $_[2];
    my @subComponents = simpleXPathQuery($registryFile, 'components/app[@guid="'.$guid.'"]/'.$query);
	
	my $keyval;
    my $valval;
   if(defined @subComponents)
    {
				for (my $i = 0; $i < @subComponents; $i++){   # looping through all the properties of the configuration setting.
				 # looping through all the properties of the configuration setting.
					 my $hashref = $subComponents[$i];
					 my %hash = %$hashref;
					    $toPrint="em_result=";
						foreach my $key (sort keys %hash){
							$toPrint = $toPrint.$hash{$key}.'|';
						}
						print "$toPrint\n";	
				} # end for - configuration settings
    }
} # end sub - output_columns

# parse key/value pair sections
sub output_namevalues
{
    my $guid = $_[0];
    my $query = $_[1];
    my $registryFile = $_[2];
    my $keyval;
    my $valval;
    my @subComponents = simpleXPathQuery($registryFile, 'components/app[@guid="'.$guid.'"]/'.$query);
	if(defined @subComponents){
		for (my $i = 0; $i < @subComponents; $i++) {               
                # looping through all the properties of the configuration setting.
                my $hashref = $subComponents[$i];
                my %hash = %$hashref;
				   while ( my ($key, $value) = each %hash) {
                    $keyval = $key;
                    $valval = $value;
					 printf "em_result=%s|%s\n", $keyval, $valval;
                }
               

        } # end for - configuration settings
	} # end if 
} # end sub - output_namevalues
