# $Header: psft_appsrv_assoc.pl
#
# psft_appsrv_assoc.pl
# 
# Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME:       psft_appsrv_assoc.pl - association script for Peoplesoft Application Server
#   DESCRIPTION
#       Returns information on targets that the peoplesoft application server
#       configuration is related to
#   RETURNS:    em_result=<association_type>|<target_name>|<target_type>|<target_properties>
#   NOTES
#       association_type: one of the types listed in ecmAssoc.pm
#       target_name: the target_name of the associated target
#       target_type: the target_type of the associated target
#       target_properties: related information that may help determine true target name given the target_type
#
#   MODIFIED    (MM/DD/YY)
#   nmittal     02/16/10 - 9323287
#   pparida     10/16/07 - Fix bug 6492554: Use CCR_CONFIG_HOME for OCM log,
#                          state and config dirs.
#   ndutko      02/12/06 - Initial PSFT Target checkin - for MTAMURA 
#   ndutko      02/12/06 - Initial PSFT Target checkin - for MTAMURA 
#   mtamura     12/02/05 - Creation
# 

use strict;
#
# relationship types are defined in ecmAssoc.pm
#
use ecmAssoc;
use ias::simpleXPath;
use psft::ccr;

my ($file) = @ARGV;

my $ccrHomeState = $ENV{CCR_CONFIG_HOME} . "/state";

if ($ccrHomeState eq '')
{
    printf "%s\n", "em_warning=The ccr state directory was not specified.";
    exit;
}
if ($file eq '')
{
    printf "%s\n", "em_warning=The xml dump file was not specified.";
    exit;
}
#******************************************
#     Global Variables
#*****************************************
    my $result = ();
#
# as new relationships are exposed, add them here
# we start off with name server relationships
#

    # create relationship to the peoplesoft database
    my $registryFile = "$ccrHomeState/temp/".$file;

    if( -f $registryFile)
    {
        my @topLevelComponents = simpleXPathQuery($registryFile, "components/appserv");
        for my $topLevelComponent (@topLevelComponents)
        {
            # found a domain.
            my $domain = $$topLevelComponent{'domain'};
            my $configpath = $$topLevelComponent{'configpath'};
            
            # get guid
            my $guid;
            my @myguid = simpleXPathQuery($registryFile, 'components/appserv/domain_info/domain');
            for my $myguid (@myguid)
            {
                if ($$myguid{'guid'} ne '')
                {
                    $guid = $$myguid{'guid'};
                }
            }
            my $dbname;
            my @startupComponents = simpleXPathQuery($registryFile, 'components/appserv/cfg/startup');
            for my $startupComponents (@startupComponents)
            {
                if ($$startupComponents{'dbname'} ne '')
                {
                    $dbname = $$startupComponents{'dbname'};
                }
            }
            printf "em_result=%s|%s|%s|%s\n",
                    $ecmAssoc::MEMBER_OF,
                    $dbname."_".$guid,
					$ecmAssoc::PSFT_DATABASE,
                    $guid;
        } # end for - domain
    } # end if - file
1;
# End of the Program
