# $Header: psft_database_assoc.pl
#
# psft_database_assoc.pl
# 
# Copyright (c) 2005, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME:       psft_database_assoc.pl - association script for Peoplesoft Database
#   DESCRIPTION
#       Returns information on targets that the peoplesoft database
#       configuration is related to
#   RETURNS:    em_result=<association_type>|<target_name>|<target_type>|<target_properties>
#   NOTES
#       association_type: one of the types listed in ecmAssoc.pm
#       target_name: the target_name of the associated target
#       target_type: the target_type of the associated target
#       target_properties: related information that may help determine true target name given the target_type
#
#   MODIFIED    (MM/DD/YY)
#   pparida     10/16/07 - Fix bug 6492554: Use CCR_CONFIG_HOME for OCM log,
#                          state and config dirs.
#   ndutko      02/12/06 - Initial PSFT Target checkin - for MTAMURA 
#   ndutko      02/12/06 - Initial PSFT Target checkin - for MTAMURA 
#   mtamura     12/02/05 - Creation
# 

use strict;
#
# relationship types are defined in ecmAssoc.pm
#
use ias::simpleXPath;
use ecmAssoc;
use emdcommon;
my @ias_assoc_results;

my ($file) = @ARGV;
my $tnsParams;
my $tnsHash;
my $oracleHome;

require "$ENV{EMDROOT}/sysman/admin/scripts/semd_common.pl";

my $ccrHomeState = $ENV{CCR_CONFIG_HOME} . "/state";

if ($ccrHomeState eq '')
{
    printf "%s\n", "em_warning=The ccr state directory was not specified.";
    exit;
}
if ($file eq '')
{
    printf "%s\n", "em_warning=The xml dump file was not specified.";
    exit;
}
$oracleHome = $ENV{USER_ORACLE_HOME};
if ($oracleHome eq '')
{
    printf "%s\n", "em_warning=The environment variable ORACLE_HOME needs to be defined.";
    exit;
}

require "$ENV{CCR_HOME}/sysman/admin/scripts/db/net/listenerUtil.pl";
#******************************************
#     Global Variables
#*****************************************
      my $result = ();
#
# as new relationships are exposed, add them here
# we start off with name server relationships
#

    # create relationship to the database
    my $registryFile = "$ccrHomeState/temp/".$file;

    if( -f $registryFile)
    {
        my @topLevelComponents = simpleXPathQuery($registryFile, "components/app");
        for my $topLevelComponent (@topLevelComponents)
        {   # found a guid.
            my $guid = $$topLevelComponent{'guid'};
            my @subComponents = simpleXPathQuery($registryFile, 'components/app[@guid="'.$guid.'"]/database_info/database');
            if(defined @subComponents)
            {   # the specified configuration setting was found.
                my $keyval;
                my $valval;
                my $dbtype;
                my $dbname;
        
                for (my $i = 0; $i < @subComponents; $i++)
                {   # looping through all the properties of the configuration setting.
                    my $hashref = $subComponents[$i];
                    my %hash = %$hashref;
                    while ( my ($key, $value) = each %hash)
                    {
                        $keyval = $key;
                        $valval = $value;
                        if ($keyval eq 'dbname')
                        {
                            $dbname = $valval;
                        }
                        elsif ($keyval eq 'dbtype')
                        {
                            $dbtype = $valval
                        }
                    }
                } # end for - configuration settings
                if ($dbtype eq 'ORACLE')
                {
                    my $tnsFile;
                    my $connDesc = tnsLookup($dbname);
                    if (length($connDesc) > 0)
                    {
                        getAssocFromConnDesc($connDesc);
                    }


#                    printf "em_result=%s|%s|%s|%s\n",
#                            $ecmAssoc::CONNECTS_TO,
#                            "",
#                            $ecmAssoc::ORACLE_DATABASE_TYPE,
#                            $dbname;
                    foreach $result (@ias_assoc_results)
                    {
                      print $result;
                    }
                }
            } # end if - configuration settings found
        } # end for - domain
    } # end if - file


sub tnsLookup
{
  # look up the input parameter to see if it's in the list of tns aliases
  my $tnsAlias = uc(shift);
  my ($resultParams,$resultHash) = getTnsAliases();
  if (defined(${$resultHash}{$tnsAlias}))
  {
    return ${$resultHash}{$tnsAlias};
  }
}

sub getTnsAliases
{
  # make sure we only get tnsnames.ora parsed once
  if (!defined($tnsParams))
  {
    my $tnsFile;
    if (defined($ENV{TNS_ADMIN}))
    {
      $tnsFile = "$ENV{TNS_ADMIN}/tnsnames.ora";
    }
    else
    {
      $tnsFile = "$oracleHome/network/admin/tnsnames.ora";
    }
    ($tnsParams,$tnsHash) = parseOracleConfigFileWithOrder($tnsFile);
  }
  return ($tnsParams,$tnsHash);
}

sub getAssocFromConnDesc
{
  my $connDesc = shift;
  # pick off host:port:sid or host:service_name sets in TNS descriptor
  # Host/Port info is in ADDRESS, Service Name/SID is in CONNECT_DATA
  my $addresses = getParamValueListFor($connDesc,"ADDRESS");
  my $connectData = getParamValueListFor($connDesc,"CONNECT_DATA");
  my $sidOrService = "";
  my ($addrInfo,$connInfo);
  foreach $addrInfo(@$addresses)
  {
    foreach $connInfo(@$connectData)
    {
      if (defined($connInfo->{SERVICE_NAME}))
      {
        $sidOrService = $connInfo->{SERVICE_NAME};
      }
      elsif (defined($connInfo->{SID}))
      {
        $sidOrService = $addrInfo->{PORT}.":".$connInfo->{SID};
      }
      push(@ias_assoc_results, "em_result=$ecmAssoc::CONNECTS_TO||$ecmAssoc::ORACLE_DATABASE_TYPE|$addrInfo->{HOST}:$sidOrService\n");
    }
  }
}
1;
# End of the Program
