# $Header: psft_websrv_assoc.pl
#
# psft_websrv_assoc.pl
# 
# Copyright (c) 2005, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME:       psft_websrv_assoc.pl - association script for Peoplesoft Web Server
#   DESCRIPTION
#       Returns information on targets that the peoplesoft web server
#       configuration is/are related to
#   RETURNS:    em_result=<association_type>|<target_name>|<target_type>|<target_properties>
#   NOTES
#       association_type: one of the types listed in ecmAssoc.pm
#       target_name: the target_name of the associated target
#       target_type: the target_type of the associated target
#       target_properties: related information that may help determine true target name given the target_type
#
#   MODIFIED    (MM/DD/YY)
#   pparida     10/16/07 - Fix bug 6492554: Use CCR_CONFIG_HOME for OCM log,
#                          state and config dirs.
#   ndutko      02/12/06 - Initial PSFT Target checkin - for MTAMURA 
#   ndutko      02/12/06 - Initial PSFT Target checkin - for MTAMURA 
#   mtamura     12/02/05 - Creation
# 

use strict;
#
# relationship types are defined in ecmAssoc.pm
#

my ($file) = @ARGV;

use ecmAssoc;
use ias::simpleXPath;
use psft::ccr;
use Digest::MD5 qw(md5 md5_hex md5_base64);
use File::Basename;

my $ccrHomeState = $ENV{CCR_CONFIG_HOME} . "/state";

if ($ccrHomeState eq '')
{
    printf "%s\n", "em_warning=The ccr state directory was not specified.";
    exit;
}
if ($file eq '')
{
    printf "%s\n", "em_warning=The xml dump file was not specified.";
    exit;
}
#******************************************
#     Global Variables
#*****************************************
      my $result = ();
#
# as new relationships are exposed, add them here
# we start off with name server relationships
#

    # create relationship to the peoplesoft database
    my $registryFile = "$ccrHomeState/temp/".$file;

    if( -f $registryFile)
    {
        my @topLevelComponents = simpleXPathQuery($registryFile, "components/webserver");
        for my $topLevelComponent (@topLevelComponents)
        {
            # found a domain.
            my $domain = $$topLevelComponent{'domain'};
            my $configpath = $$topLevelComponent{'configpath'};
            my $site = $$topLevelComponent{'site'};
            
            # get guid
            my $guid;
            my $host;
            my @myguid = simpleXPathQuery($registryFile, 'components/webserver/site_info/site');
            for my $myguid (@myguid)
            {
                if ($$myguid{'guid'} ne '')
                {
                    $guid = $$myguid{'guid'};
                }
                elsif ($$myguid{'hostname'} ne '')
                {
                    $host = $$myguid{'hostname'};
                }
            }
            printf "em_result=%s|%s|%s|%s\n",
                    $ecmAssoc::MEMBER_OF,
                    "",
                    $ecmAssoc::PSFT_DATABASE,
                    $guid;
            my $psftwebFile = $configpath.'/webserv/'.$domain.'/piaInstallLog.xml';
            if( -f $psftwebFile)
            {
                my @webInstall = simpleXPathQuery($psftwebFile, 'PeopleSoft-Internet-Architecture-Domain[@name="'.$domain.'"]/Misc-Information/WebServer');
                for my $webInstall (@webInstall)
                {
                    # found a domain.
                    my $installPath = $$webInstall{'Path'};
                    my $installType = $$webInstall{'Type'};
                    my $prefix;
                    my $oraTargetType;
                    if ($installType eq 'weblogic')
                    {
                        $prefix = "BEA";
                        $oraTargetType = "bea";
                        $installPath = dirname($installPath);;
                    }
                    else
                    {
                        $prefix = "IBM";
                        $oraTargetType = "ibm";
                    }
                    my $targetName = $prefix."_".$installPath;
                    if( length($targetName) > 256)
                    {
                        $targetName = $prefix."_".uc md5_base64($installPath);
                    }
                    printf "em_result=%s|%s|%s|%s\n",
                            $ecmAssoc::DEPENDS_ON,
                            $targetName,
                            $oraTargetType,
                            $installPath;
                }
            }
            else
            { # must be oas webserver.
                printf "em_result=%s|%s|%s|%s\n",
                        $ecmAssoc::DEPENDS_ON,
                        "",
                        $ecmAssoc::ORACLE_IAS_TYPE,
                        $host.":".$configpath;
                printf "em_result=%s|%s|%s|%s\n",
                        $ecmAssoc::DEPENDS_ON,
                        "",
                        $ecmAssoc::OC4J_TYPE,
                        $host.":".$configpath.":".$domain;
            }
        } # end for - domain
    } # end if - file
1;
# End of the Program
