# $Header: webserver.pl
#
# webserver.pl
# 
# Copyright (c) 2002, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME:       webserver.pl - PeopleSoft Web Server Discovery
#   DESCRIPTION
#       Used to discover PeopleSoft Web Server configuration settings.
#   RETURNS:    em_result=<site>|<property>|<value>
#   NOTES
#       The webserver.psft file is created when PSEMAgent registers to PSEMHUB.
#
#   MODIFIED    (MM/DD/YY)
#   nmittal     04/13/10 - 9557227
#   pparida     10/16/07 - Fix bug 6492554: Use CCR_CONFIG_HOME for OCM log,
#                          state and config dirs.
#   ndutko      02/12/06 - Initial PSFT Target checkin - for MTAMURA 
#   ndutko      02/12/06 - Initial PSFT Target checkin - for MTAMURA 
#   mtamura     09/22/05 - Creation
# 

use strict;
use ias::simpleXPath;
use psft::ccr;

my ($query, $file) = @ARGV;

my $ccrHomeState = $ENV{CCR_CONFIG_HOME} . "/state";

# validate parameters.
if ((@ARGV) != 2)
{
    printf "%s\n\n", "Outputs PeopleSoft Web Server configuration settings.";
    printf "%s\n\n", "webserver.pl ccrHomeState query";
    printf "%s\t%s\n", "  ccrHomeState", "Specifies the path to CCR state directory.";
    printf "%s\t%s\n", "  query", "Specifies xpath query used to find configuration setting.";
    printf "%s\t%s\n", "  fileName", "Specifies file name of the PeopleSoft dump file.";
}
if ($ccrHomeState eq '')
{
    printf "%s\n", "em_warning=The ccr state directory was not specified.";
    exit;
}
if ($query eq '')
{
    printf "%s\n", "em_warning=The xpath query for was not specified.";
    exit;
}
if ($file eq '')
{
    printf "%s\n", "em_warning=The xml dump file was not specified.";
    exit;
}

my $registryFile = "$ccrHomeState/temp/".$file;

if( -f $registryFile)
{
    # webserver file found.
    my @topLevelComponents = simpleXPathQuery($registryFile, "components/webserver");
    for my $topLevelComponent (@topLevelComponents)
    {
        # found a domain.
        my $domain = $$topLevelComponent{'domain'};
        my $configpath = $$topLevelComponent{'configpath'};
        my $site = $$topLevelComponent{'site'};
        
        # get hostname
        my $host;
        my @myhosts = simpleXPathQuery($registryFile, "components/webserver/site_info/site");
        for my $myhost (@myhosts)
        {
            if ($$myhost{'hostname'} ne '')
            {
                $host = $$myhost{'hostname'};
            }
        }
        
        my @subComponents = simpleXPathQuery($registryFile, "components/webserver/$query");
        if(defined @subComponents)
        {
            # the specified configuration setting was found.
            my $keyval;
            my $valval;
    
            for (my $i = 0; $i < @subComponents; $i++)
            {               
                # looping through all the properties of the configuration setting.
                my $hashref = $subComponents[$i];
                my %hash = %$hashref;
                while ( my ($key, $value) = each %hash) {
                    $keyval = $key;
                    $valval = $value;
                }
                my $trimlen = 1995;
                if (length($valval) > $trimlen)
                {
                    use integer;
                    my $mod = (length($valval) / $trimlen);
                    my $startpos = 0;
                    my $endpos = $trimlen;
                    my $trimval;
                    for (my $i = 0; $i < $mod; $i++)
                    {
                        $trimval  = substr($valval, $startpos, $endpos);
                        printf "em_result=%s|%s\n", $keyval."-".$i, $trimval;
                        $startpos += $trimlen;
                    }
                    if ((length($valval) % $trimlen) > 0)
                    {
                        $trimval  = substr($valval, $startpos, $endpos);
                        printf "em_result=%s|%s\n", $keyval."-".$mod, $trimval;
                    }
                    no integer;
                }
                else
                {
                    printf "em_result=%s|%s\n", $keyval, $valval;
                }
            } # end for - configuration settings
        } # end if - configuration settings found
    } # end for - domain
}
