#!/usr/local/bin/perl
# 
# $Header: clsInterconn.pl 07-jul-2006.02:06:34 rstorrie Exp $
#
# clsInterconn.pl
# 
# Copyright (c) 2004, 2006, Oracle. All rights reserved.  
#
#    NAME
#      clsInterconn.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rstorrie    07/07/06 - Fix to script where oifcfg returns an error, do 
#                           not return these lines 
#    rstorrie    07/07/06 - Fix to script where oifcfg returns an error, do 
#                           not return these lines 
#    xuliu       04/05/05 - using qualified hostname 
#    xuliu       10/07/04 - xuliu_mov_rac_f
#    xuliu       07/08/04 - xuliu_rac_interconn
#    xuliu       07/01/04 - Creation
# 
require "emd_common.pl";

$crsHome = $ENV{EM_CRS_HOME};

$crsHome = $ENV{CRS_HOME} if ($crsHome eq "");

if ($crsHome eq "" || $crsHome eq "#CRS_HOME#")
{
    EMD_PERL_DEBUG("Ignore cluster interconnect metric: no CRS_HOME is found in the cluster\n");
}
else
{
    # we call oifcfg to get the information
    $o = `$crsHome/bin/oifcfg getif`;
    
    if ($?)
    {
        EMD_PERL_ERROR("'$crsHome/bin/oifcfg getif' error: $? $! $o");
    }
    else
    {
        EMD_PERL_DEBUG("'$crsHome/bin/oifcfg getif' returned: $o");
        
        @lines = split /\n/, $o;
        
        foreach $ln (@lines) 
        {
            # $ln is in format of "if_name  subnet  scope  type"
            # e.g. eth0  10.10.10.0  global  cluster_interconnect
            
            next if ($ln =~ /^\s*$/);

            @attrs = split /  /, $ln;


            if ($attrs[2] !~ /global/i)
            {
                ($attrs[2]) = gethostbyname($attrs[2]); # fully qualified host name
            }
            
            if ($attrs[3] =~ /cluster_interconnect/i)
            {
                $attrs[3] = "NO";
            }
            elsif ($attrs[3] =~ /public/i)
            {
                $attrs[3] = "YES";
            }
            else
            {
                $attrs[3] = "";
            }    
            
            EMD_PERL_DEBUG("Interconn: $attrs[0]|$attrs[2]|$attrs[1]||$attrs[3]|");
            # output in format of if_name|node|subnet|ip|public
            # only print the line if it doesnt have an error
            if ($ln !~ /^\s*PRIF/)
            {
                print "em_result=$attrs[0]|$attrs[2]|$attrs[1]||$attrs[3]\n";
            }
        }    
    }        
}
   
