#!/usr/local/bin/perl
# 
# $Header: clusterconfig.pl 21-oct-2005.14:12:20 xuliu Exp $
#
# clusterconfig.pl
# 
# Copyright (c) 2002, 2005, Oracle. All rights reserved.  
#
#    NAME
#      clusterconfig.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      Script that calls cemutlo or cemutls to get cluster
#      version and os info as the dynamic properties of a
#      cluster target.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    xuliu       10/21/05 - bug 4667678 
#    xuliu       11/18/04 - clusterName
#    xuliu       10/07/04 - xuliu_mov_rac_f
#    xuliu       09/13/04 - active crs version 
#    xuliu       06/28/04 - active crs version, crs software ver, etc 
#    xuliu       11/05/03 - EMDROOT for 92 cluster 
#    xuliu       06/30/03 - use CRS_HOME to locate cemutl
#    xuliu       01/20/03 - log
#    xuliu       11/20/02 - uname to get OS inf
#    xuliu       11/15/02 - xuliu_nov_06
#    xuliu       11/12/02 - Creation
# 
require "emd_common.pl";
require "semd_common.pl";

$rootDir = $ENV{EM_CRS_HOME};

$rootDir = $ENV{CRS_HOME} if ($rootDir eq "");

$isVendorCW = 1;

if ($rootDir eq "" || $rootDir eq "#CRS_HOME#")
{
    #No CRS is known to the cluster
    $rootDir = $ENV{EMDROOT};
    
    $clsName = getClusterName($rootDir);

    $o = `$rootDir/bin/cemutls -w 2>&1`;
    if ($?) 
    {
        $errMsg .= "'$rootDir/bin/cemutls -w': $? $! $o\n";
    }    
    else
    {
        if ($o =~ /(.*)\:(.*)\:(.*)/)
        {
          $v = ($2 ne "")? $1 . "." . $2 : $1;
          $vendor = $3;
        }
        else
        {
           $errMsg .= "Unknown format of the output: $o\n";
        }    
    }
}    
else
{
    #There is a CRS home in this cluster

    $clsName = getClusterName($ENV{EMDROOT}, $rootDir);

    # bug 4667678
    my $oldOH = $ENV{ORACLE_HOME};
    $ENV{ORACLE_HOME} = $rootDir;

    $o = `$rootDir/bin/cemutls -w 2>&1`;
    
    EMD_PERL_ERROR("In CRS Home: $rootDir/bin/cemutls -w: $o");
    
    if ($?)
    {
        #if ($o =~ /struct size 0/)
        #{
            # No vendor clusterware is in use
            $isVendorCW = 0;
        #}    
    }
    
    $o = `$rootDir/bin/cemutlo -w 2>&1`;
    
    if ($?) 
    {
        $errMsg .= "'$rootDir/bin/cemutlo -w': $? $! $o\n";
    }
    else
    {
        if ($o =~ /(.*)\:(.*)\:(.*)/)
        {
          $v = ($2 ne "")? $1 . "." . $2 : $1;
          $vendor = $3;
        }
        else
        {
           $errMsg .= "Unknown format of the output: $o\n";
        }    
    }

    #Active CRS Version
    $o = `$rootDir/bin/crsctl query crs activeversion 2>&1`;
    if ($?)
    {
        $errMsg .= "$rootDir/bin/crsctl query crs activeversion: $? $! $o\n";
    }
    else
    {
        if ($o =~ /\[([\d|\.]+)\]/)
        {
            $CRSVersion = $1;
        }
        else
        {
          $errMsg .= "Unknown output format of $rootDir/bin/crsctl query crs activeversion: $o\n";
        }        
    }
    
    # 10.1 crsctl doesn't return the version. 
    if ($CRSVersion eq "")
    {
        if ($v eq "1.1")
        {
            $CRSVersion = "10.1";
        }
    }

    # restore ORACLE_HOME
    $ENV{ORACLE_HOME} = $oldOH;    
}

if ($errMsg ne "")
{
    EMD_PERL_ERROR($errMsg);
}

    
print "em_result=", $v, "|", $vendor, "|", $isVendorCW, "|", $CRSVersion, "|", $clsName, "\n";
