#!/usr/local/bin/perl
# 
# $Header: cmcfg_params.pl 11-oct-2005.23:08:34 dkapoor Exp $
#
# cmcfg_params.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      cmcfg_params.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    dkapoor     10/11/05 - dkapoor_bug-4552252
#    dkapoor     10/11/05 - Creation
# 
strict;
use File::Spec;
require "$ENV{EMDROOT}/sysman/admin/scripts/emd_common.pl";

my ($oracle_home) = @ARGV;

EMD_PERL_DEBUG("In cmcfg_params for  oh=[$oracle_home]");

my $configFile = File::Spec->catdir($oracle_home,"oracm","admin","cmcfg.ora");

if( !(-f $configFile))
{
    EMD_PERL_DEBUG("The cmcfg.ora file \"$configFile\" not found.");
    exit;
}
my $CONFIG_FILE_READER;
if(open(CONFIG_FILE_READER, $configFile))
{
    my $line;
    while($line = <CONFIG_FILE_READER>)
    {
	chomp $line;

   	# Trim off the characters after comment character and any leading whitespace.
	$line =~ s/^\s*([^#]*).*/$1/;
	next if ( length($line) == 0 );
	my ( $property, $value ) = ( $line =~ /\s*(.*)\s*=\s*(.*)\s*/ );
        print "em_result=$property|$value|$configFile\n" if (!($property eq ""));
    }
}
else
{
    EMD_PERL_INFO("Could not open the config.ora file =$configFile");
    print STDERR "em_error=Could not open the cmcfg.ora file=\"$configFile\":$!\n";
    exit (-1);
}
