#!/usr/local/bin/perl
# 
# $Header: crs_status_cluster.pl 21-oct-2005.14:12:20 xuliu Exp $
#
# crs_status_cluster.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      crs_status_cluster.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    xuliu       10/21/05 - bug 4667678 
#    ysun        07/15/05 - ysun_bug-4458582
#    ysun        07/15/05 - Creation
# 

require "emd_common.pl";
require "semd_common.pl";

$rootDir = shift(@ARGV); # CRSHome
$rootDir = $ENV{CRS_HOME} if ($rootDir eq "");
$rootDir = $ENV{ORACLE_HOME} if ($rootDir eq "");
$rootDir = $ENV{EMDROOT} if ($rootDir eq "");

EMD_PERL_DEBUG("**crs home is: $rootDir");

# bug 4667678
my $oldOH = $ENV{ORACLE_HOME};
$ENV{ORACLE_HOME} = $rootDir;

$crsIsUp = 1;
$failedCount = 0;
if ($rootDir eq "")
{
    $cmd = "$ENV{EMDROOT}/bin/lsnodes";
}
else
{
    $cmd = "$rootDir/bin/olsnodes";
}

chomp($nodes = `$cmd 2>&1`);
if ($?)
{
    EMD_PERL_ERROR("**$cmd:  $? $! $nodes");
}
else
{
    @nlist = split(/\n/, $nodes);
    $nodes =~ s/\n/,/g;
    EMD_PERL_DEBUG("**Node List: $nodes");
}

if ($nodes eq "")
{
    #No node list
    $crsIsUp = 0;
    $o = "No cluster node list";
}    
else
{
    #check if the executable is available
    
    chomp ($o = `$rootDir/bin/cluvfy comp crs -n $nodes 2>&1`);
	#or die "Failed to run the cluvfy command";
    
    if ($?)
    {
        # search backwards for the failed node list
        $flag = "node(s):";

        if ($o =~ /$flag/)
        {
            $where = index($o, $flag) + length($flag);
            $fnodes = substr($o, $where,length($o) );
            $fnodes =~ s/^\s+//;
            $fnodes =~ s/\s+$//;
            EMD_PERL_DEBUG("**failed node list:($fnodes)");
            @fnlist = split(/,/, $fnodes);
            $failedCount = scalar(@fnlist);

            if ( scalar(@nlist) != scalar (@fnlist))
            {
                $crsIsUp = 1;
            }
            else
            {
                $crsIsUp = 0;
            }
        }
    }
    else
    {
        $crsIsUp = 1;
    }

    
    $o =~ s/\n/ /g;
}

if ($errMsg ne "")
{
    EMD_PERL_ERROR($errMsg);
}

$o =~ s/\n/ /g;

$ENV{ORACLE_HOME} = $oldOH;

print "em_result=", $crsIsUp, "|", $failedCount, "|", $o, "\n";

