#!/usr/local/bin/perl
# 
# $Header: dbIntrconn.pl 07-jul-2005.15:39:36 xuliu Exp $
#
# dbIntrconn.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      dbIntrconn.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    xuliu       07/07/05 - 4472067: get all info from cluster_interconnects
#    xuliu       04/14/05 - xuliu_bug-4283639
#    xuliu       04/05/05 - Creation
# 

use strict;
use DBI;

require "emd_common.pl";
require "semd_common.pl";

my %stdinArgs = get_stdinvars();
my $username = $stdinArgs{"EM_TARGET_USERNAME"};
my $password = $stdinArgs{"EM_TARGET_PASSWORD"};
my $address = $ENV{EM_TARGET_ADDRESS};
my $role = $ENV{EM_TARGET_ROLE};
my $mode = 0;
my $tgtName = $ENV{EM_TARGET_NAME};

###### DEBUG ####
#my $username = "sys";
#my $password = "oracle";
#$role="SYSDBA";
#$address = "(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=stacg40)(PORT=1521))(CONNECT_DATA=(SID=db102)))";
##################

if($role =~ /SYSDBA/i)
{
  $mode = 2;
}
elsif($role =~ /SYSOPER/i)
{
  $mode = 4;
}

EMD_PERL_DEBUG("Start collection of interconnect for target $tgtName ...");

my $lda = DBI->connect('dbi:Oracle:', "$username@".$address, "$password", 
    {ora_session_mode => $mode, PrintError => 0, RaiseError => 0})
    or die "em_error=Could not connect to $username/$address: $DBI::errstr\n";

my $clsIntrconSql = "SELECT name, ip_address, is_public, source FROM v\$cluster_interconnects order by name, ip_address";
my $ro_cur = $lda->prepare($clsIntrconSql)
    or disconnect_N_die($lda, "em_error=prepare($clsIntrconSql): $DBI::errstr\n");

$ro_cur->execute()
    or disconnect_N_die($lda, "em_error=ro_cur->execute(): $DBI::errstr\n");

my @arow;
my @intrconns;

EMD_PERL_DEBUG("v\$cluster_interconnects has the following:");
while (@arow = $ro_cur->fetchrow_array())
{
    EMD_PERL_DEBUG(join(",", @arow));
    my @a = @arow;
    push(@intrconns, \@a);
}

$ro_cur->finish;

$lda->disconnect;

if (defined(@intrconns))
{
    my ($eth, $ip, $is_public, $source);
    my ($pre_eth, $pre_ip) = ("", "");
    for (my $i=0; $i<@intrconns; $i++)
    {
       my $r = $intrconns[$i];
       EMD_PERL_DEBUG("$i: $r->[0], $r->[1], $r->[2], $r->[3]");
       
       $eth = (defined($r->[0]))? $r->[0] : "";
       $ip = (defined($r->[1]))? $r->[1] : "";
       $is_public = (defined($r->[2]))? $r->[2] : "";
       $source = (defined($r->[3]))? $r->[3] : "";
   
       $eth = "n/a" if ($eth eq "");
       $ip = "n/a" if ($ip eq "");
       
       if ($pre_eth eq $eth && $pre_ip eq $ip)
       {
           EMD_PERL_DEBUG("[$eth, $ip] already processed. Skip ($eth, $ip, $is_public, $source)");
       }
       else
       {  
           $pre_eth = $eth;
           $pre_ip = $ip;
           EMD_PERL_DEBUG("Output: em_result=$eth|$ip|$is_public|$source");
           print "em_result=$eth|$ip|$is_public|$source\n";
       }    
    }      
}           

sub disconnect_N_die
{
   my ($con, $msg) = @_;
   $con->disconnect;
   die($msg);
}


