#!/usr/local/bin/perl
# 
# $Header: dbIntrconnType.pl 07-jul-2005.15:39:37 xuliu Exp $
#
# dbIntrconnType.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      dbIntrconnType.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    xuliu       07/07/05 - 4472067: get all info from cluster_interconnects 
#    xuliu       04/14/05 - xuliu_bug-4283639
#    xuliu       04/05/05 - Creation
# 

use strict;
use DBI;

require "emd_common.pl";
require "semd_common.pl";

my %stdinArgs = get_stdinvars();
my $username = $stdinArgs{"EM_TARGET_USERNAME"};
my $password = $stdinArgs{"EM_TARGET_PASSWORD"};
my $address = $ENV{EM_TARGET_ADDRESS};
my $role = $ENV{EM_TARGET_ROLE};
my $mode = 0;
my $tgtName = $ENV{EM_TARGET_NAME};

###### DEBUG ####
#my $username = "sys";
#my $password = "oracle";
#$role="SYSDBA";
#$address = "(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=stacg40)(PORT=1521))(CONNECT_DATA=(SID=db102)))";
##################

if($role =~ /SYSDBA/i)
{
  $mode = 2;
}
elsif($role =~ /SYSOPER/i)
{
  $mode = 4;
}

EMD_PERL_DEBUG("Start collection of interconnect type for target $tgtName ...");

my $lda = DBI->connect('dbi:Oracle:', "$username@".$address, "$password", 
    {ora_session_mode => $mode, PrintError => 0, RaiseError => 0})
    or die "em_error=Could not connect to $username/$address: $DBI::errstr\n";

my $clsIntrconSql = "SELECT name, is_public FROM v\$cluster_interconnects order by name";
my $ro_cur = $lda->prepare($clsIntrconSql)
    or disconnect_N_die($lda, "em_error=prepare($clsIntrconSql): $DBI::errstr\n");

$ro_cur->execute()
    or disconnect_N_die($lda, "em_error=ro_cur->execute(): $DBI::errstr\n");

my @arow;
my @intrconns;

EMD_PERL_DEBUG("v\$cluster_interconnects has the following:");
while (@arow = $ro_cur->fetchrow_array())
{
    EMD_PERL_DEBUG(join(",", @arow));
    my @a = @arow;
    push(@intrconns, \@a);
}

$ro_cur->finish;

$lda->disconnect;


if (defined(@intrconns))
{
    
    my ($eth, $is_public);
    my $pre_eth = "";
    
    for (my $i=0; $i<@intrconns; $i++)
    {
       my $r = $intrconns[$i];
              
       $eth = (defined($r->[0]))? $r->[0] : "";
       $is_public = (defined($r->[1]))? $r->[1] : "";
       
       $eth = "Unknown" if ($eth eq "");
       if ($is_public eq "YES")
       {
            $is_public = "Public";
       }elsif ($is_public eq "NO")
       {
            $is_public = "Private";
       }
       else
       {
            $is_public = "Unknown";
       }     
       
       if ($eth ne $pre_eth)
       {
           $pre_eth = $eth;
           EMD_PERL_DEBUG("Output: em_result=$eth|$is_public");
           print "em_result=$eth|$is_public\n";
       }
       else
       {
           EMD_PERL_DEBUG("$eth already processed, skip ($eth, $is_public)");
       }     
    }      
}           

sub disconnect_N_die
{
   my ($con, $msg) = @_;
   $con->disconnect;
   EMD_PERL_ERROR("disconnect_N_die: $msg");
   die($msg);
}


