#!/usr/local/bin/perl
# 
# $Header: srvConfig_params.pl 11-oct-2005.23:08:34 dkapoor Exp $
#
# srvConfig_params.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      srvConfig_params.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    dkapoor     10/11/05 - dkapoor_bug-4552252
#    dkapoor     10/11/05 - Creation
# 
strict;
require "$ENV{EMDROOT}/sysman/admin/scripts/semd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/rac/clusterCommon.pl";

EMD_PERL_DEBUG("In cmcfg_params");

my $configFile = getSrvConfigFile();

if(!$configFile ||  !(-f $configFile))
{
    EMD_PERL_DEBUG("The srvConfig file \"$configFile\" not found.");
    exit ;
}
my $CONFIG_FILE_READER;
if(open(CONFIG_FILE_READER, $configFile))
{
    my $line;
    while($line = <CONFIG_FILE_READER>)
    {
	chomp $line;

   	# Trim off the characters after comment character and any leading whitespace.
	$line =~ s/^\s*([^#]*).*/$1/;
	next if ( length($line) == 0 );
	my ( $property, $value ) = ( $line =~ /\s*(.*)\s*=\s*(.*)\s*/ );
        print "em_result=$property|$value|$configFile\n" if (!($property eq ""));
    }
}
else
{
    EMD_PERL_INFO("Could not open the srvConfig file=$configFile");
    print STDERR "em_error=Could not open the srcConfig file=\"$configFile\":$!\n";
    exit (-1);
}
