#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/racVotedisk.pl /main/1 2009/06/30 10:14:41 nmittal Exp $
#
# racVotedisk.pl
# 
# Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      racVotedisk.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    raankire   06/17/09 - Creation
#    
###################################################################### 
use strict;
use File::Spec;
require "semd_common.pl";
require "emd_common.pl";

##Getting the CRSHome
my @crsHomes = getCRSHomes();

my $CRSHome=$crsHomes[$#crsHomes];

my $oracle_home=$ENV{ORACLE_HOME};
##If the CRShome is null then set Oracle Home as CRSHome
if (!defined $CRSHome) {
        $CRSHome=$oracle_home;
}

my @voting_disk;
my $voting_disk_size;

my $crsctl_file=File::Spec->catfile( $CRSHome, "bin", "crsctl" );

if (-f $crsctl_file) {
                EMD_PERL_DEBUG("crsctl File found:$crsctl_file");
                my $i;
                my @cmd_output=`$crsctl_file query css votedisk`;
                my $status_exit=$?;
                EMD_PERL_DEBUG("crsctl command output status:$status_exit, Please see the following output");
##Now logging the output of the crsctl command for easy debugging
                foreach my $output_debug (@cmd_output) {
                EMD_PERL_DEBUG("$output_debug \n");
                }

                my $cmd_output_size=@cmd_output;
                if ($status_exit == 0) {
##Checking for Zero output
                        if ($cmd_output_size == 0 || $cmd_output_size== -1) {
                                print "em_result= \n";
                        }
##Checking for single row output with only comment
                        elsif ($cmd_output_size == 1) {
                                my $comment_str_tmp=$cmd_output[0];
                                $comment_str_tmp=~ s/^\s+//;
                                $comment_str_tmp=~ s/\s+$//;
                                $comment_str_tmp=substr $comment_str_tmp,0,7;
                                if (lc($comment_str_tmp) eq "located") {
                                        print "em_result= \n";
                                }
                        }
##Now Checking for the other patterns of output
                        else {
                                foreach $i (0..($#cmd_output)) {
##For crsctl command the list might be a comment saying: Located 1 voting disk(s).
##So checking whether the line is a comment
                                        my $comment_str=substr $cmd_output[$i],0,7;
                                        $comment_str=~ s/^\s+//;
                                        $comment_str=~ s/\s+$//;
                                        if (lc($comment_str) ne "located") {
                                                EMD_PERL_DEBUG("The output line is not a comment");
##Basically the output of the crsctl query css votedisk may vary for different platforms
##Here checking whether the voting disk is in between '()'
##So first taking the part after the character '('
                                                my @res_1=split(/\(/,$cmd_output[$i]);
                                                my $res_1_size=@res_1;
                                                if ($res_1_size != 0 && $res_1_size >= 2 ) {
##now taking the second part which is before the character ')'
                                                my @res_1_part2=split(/\)/,$res_1[1]);
                                                my $res_1_part2_size=@res_1_part2;
                                                 if ($res_1_part2_size != 0 && $res_1_part2_size >= 2 ) {
                                                        EMD_PERL_DEBUG("Printing the result:coming under '()' case");
                                                        $voting_disk_size=$#voting_disk+1;
                                                        $voting_disk[$voting_disk_size]=$res_1_part2[0];
                                                        #print "em_result=".$res_1_part2[0];
                                                 }
                                                }
                                                else {
                                                        my $j;
                                                        my @res_2=split(/ /,$cmd_output[$i]);
                                                        my $res_2_size=@res_2;
                                                        if ($res_2_size != 0 && $res_2_size >= 3 ) {
                                                                my $res_2_tmp=$cmd_output[$i];
                                                                $res_2_tmp=~ s/\s+/ /g;
                                                                $res_2_tmp=~ s/^\s+//;
                                                                $res_2_tmp=~ s/\s+$//;
                                                                my @res_2_final=split(/ /,$res_2_tmp);
                                                                my $res_2_final_size=@res_2_final;
                                                        if ($res_2_final_size != 0 && $res_2_final_size >=3 ) {
                                                                $voting_disk_size=$#voting_disk+1;
                                                                $voting_disk[$voting_disk_size]=$res_2_final[$#res_2_final];

                                                        }
                                                        }
                                                }
                                        }
                                }
                        }
                }
}
else {
        EMD_PERL_DEBUG("crsctl File NOT found");
}
foreach my $k (@voting_disk) {
        EMD_PERL_DEBUG("Printing the result:coming under Normal case");
        print "em_result=$k\n";
}

