#!/usr/local/bin/perl
# 
# $Header: hostRunningProducts.pl 26-jul-2007.07:11:04 jsutton Exp $
#
# hostRunningProducts.pl
# 
# Copyright (c) 2006, 2007, Oracle. All rights reserved.  
#
#    NAME
#      hostRunningProducts.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsutton     07/26/07 - Pick up existing shared OH work
#    jsutton     07/25/07 - Shared home work
#    dkapoor     09/27/06 - don't hold onto the processes in memory: scaling
#                           issue
#    dkapoor     09/20/06 - change of proc.cc dir to state/temp
#    dkapoor     09/15/06 - XbranchMerge dkapoor_proc_windows_port from main
#    dkapoor     09/07/06 - debug
#    dkapoor     09/06/06 - don't parse source type other than R
#    dkapoor     08/30/06 - parse mapping details
#    dkapoor     07/27/06 - Creation
# 

use strict;
require "semd_common.pl";

use File::Spec;
use ias::simpleXPath;

my $proc_file = File::Spec->catdir($ENV{CCR_CONFIG_HOME},"state","temp","proc.cc");

EMD_PERL_DEBUG("In hostRunningProducts looking for $proc_file.");

my $g_version = "10.1";

if(-e $proc_file)
{
  EMD_PERL_DEBUG("$proc_file found.");
  
  my $filter = File::Spec->catdir($ENV{EMDROOT},"sysman","admin","scripts","runningProducts","filter.xml");

  my $mapper = File::Spec->catdir($ENV{EMDROOT},"sysman","admin","scripts","runningProducts","mapper.xml");

  printProducts($proc_file,$filter,$mapper);
}

#Print Products
#Does the OS proc filteration and prod mapping.
sub printProducts
{
  my ($proc_file,$filter_file,$mapper) = @_;

  my %productMappings;
  if (-e $mapper)
  {
    EMD_PERL_DEBUG("$mapper exists, apply it.");
    my @mappings = simpleXPathQuery($mapper, 'Mappings/mappingDetails'); 
    foreach my $mappingsTag (@mappings)
    {
       $g_version = $$mappingsTag{'Version'};  
       last;
    }
   
      EMD_PERL_DEBUG("Version=$g_version.");
      my @mappings = simpleXPathQuery($mapper, 'Mappings/Mapping'); 
      foreach my $mapping (@mappings)
      {
        EMD_PERL_DEBUG("Get Expression for Product= $$mapping{'ProductID'}");
        my @mappingExps = simpleXPathQuery($mapper, 'Mappings/Mapping[@ProductID="'.$$mapping{'ProductID'}.'"]/RegularExpressions/RegularExpression'); 
        my $exps = '';
        foreach my $mappingExp (@mappingExps)
        {
          EMD_PERL_DEBUG("Mapping Expression for Product= $$mapping{'ProductID'} is [". $$mappingExp{'exp'}."]");
          my $type = $$mappingExp{'SourceType'};
          $type =~ s/^\s*|\s*$//g; 
          if($type ne 'R' && $type ne '')
          {
	     EMD_PERL_DEBUG("source type=[$type]. Ignore the non 'R' source type expressions");
             next;
          } 

          if($exps ne '')
          { 
            $exps = "$exps|"; 
          }
          my $ignoreCase = $$mappingExp{'IgnoreCase'};
          EMD_PERL_DEBUG("IgnoreCase=$ignoreCase.");
          if (defined $ignoreCase && $ignoreCase eq 'Y')
          {
            $ignoreCase = '(?i)';
          }
          else
          {
            $ignoreCase = '';
          }

          $exps = "$exps". $ignoreCase .$$mappingExp{'exp'};
        }
        if($exps ne '')
        {
          $productMappings{$$mapping{'ProductID'}} = $exps;
          EMD_PERL_DEBUG("Complete Mapping Expression for Product= $$mapping{'ProductID'} is [$exps]");
        }
      }
  }

  if(-e $proc_file)
  {
    EMD_PERL_DEBUG("$proc_file exists, apply it.");
    my $filters =''; 
    if (-e $filter_file)
    {
      my @filterExps = simpleXPathQuery($filter_file, 'Filters/Filter/RegularExpressions/RegularExpression'); 
      foreach my $filterExp (@filterExps)
      {
        if( $filters ne '')
        {
           $filters = "$filters|";
        }
        my $ignoreCase = $$filterExp{'IgnoreCase'};
        EMD_PERL_DEBUG("IgnoreCase=$ignoreCase.");
        if (defined $ignoreCase && $ignoreCase eq 'Y')
        {
          $ignoreCase = '(?i)';
        }
        else
        {
          $ignoreCase = '';
        }

        $filters = "$filters".$ignoreCase.$$filterExp{'exp'};
      }
    }
    #Trim leading and trailing spaces in the filters.
    $filters =~ s/^\s*|\s*$//g;
    EMD_PERL_DEBUG("Filters =$filters");
    my $PROC_FILE;
    #Read the proc file
    if (open(PROC_FILE, $proc_file)) 
    {
      my $line;
      while ($line = <PROC_FILE>) 
      {
        chomp($line);
        $line =~ s/^\s*|\s*$//g;
        next if ($line eq '' || $line =~ /[^\x09\x20-\x7E]/);
        my $filter;

        #Apply filters on each line
        if ($filters ne '' && $line =~ /$filters/) 
        {
          #This process can be filtered
          EMD_PERL_DEBUG("$line is FILTERED OUT.");
        }
        else
        {
          #This process needs to be processed
          EMD_PERL_DEBUG("[".$line ."] is VALID");
          printAProduct($line,\%productMappings);
        }
      }
   } 
   else 
   {
     EMD_PERL_DEBUG("Could not open $proc_file");
   }
   close(PROC_FILE);
  }
}

#Print a product
#Try to map to a product, otherwise print unmapped
sub printAProduct
{
      my ($proc,$productMappings) = @_;
      my $mappedProduct = -1;
      foreach my $product (keys %$productMappings)
      {
          #Check if this process maps to this product
          EMD_PERL_DEBUG("Checking if [$proc] maps product_id=$product based on expression=[$productMappings->{$product}]");
          if ($proc =~ /$productMappings->{$product}/) 
          {
            EMD_PERL_DEBUG("$proc is mapped to $product");
            $mappedProduct = $product;
            #Process mapped, end the loop
            last;	
          }
      }
      printResult($proc,$mappedProduct);
}

#Prints the result
#If the process is more than the max limit of 4000, truuncates it to 
#the max size.
#Also, converts any column separator char '|' in the process to '='.
sub printResult
{
  my ($proc,$mappedProduct) = @_;
  $proc  =~ s/\|/=/g;
  print "em_result=".substr($proc,0,4000)."|$mappedProduct|$g_version\n";
}
