# $Header: emll/sysman/admin/scripts/siebel_assoc.pl /main/8 2012/08/13 12:36:44 suhkaul Exp $
#
# siebel_assoc.pl
#
# Copyright (c) 2006, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      siebel_assoc.pl - returns the associations between siebel targets
#
#    DESCRIPTION
#        This script parses the siebel_assoc.cfg file and returns the associations between siebel targets
#
#         OUTPUT:
#          em_result=<PropertyName=PropertyValue>|
#                  where <PropertyName> is the property name
#              <PropertyValue> is the property value
#
#
#    MODIFIED   (MM/DD/YY)
#    suhkaul     07/11/12 -  Fixing Bug  14460217,Reverting back to old display names of targets
#    jsutton     07/26/07 - Pick up existing shared OH work
#    jsutton     07/25/07 - Shared home work
#    vesriniv    03/14/07 - creation
#
#
use strict;
# association types are defined in ecmassoc.pm
use ecmAssoc;
require "emd_common.pl";

my $targetName = $ARGV[0];
my $targetType = $ARGV[1];
my $p_host = $ARGV[2];
my $p_oracleHome = $ARGV[3];
my $p_agentOracleHome = $ARGV[4];
my $p_gatewayHost  = $ARGV[5];

my $sep = $^O =~ m/MSWin32/ ? "\\" : "\/";
my $oraHome = $ENV{CCR_CONFIG_HOME}.$sep."state".$sep."temp";

my $siebelConf   = $oraHome.$sep."siebel_config.cfg";
my $line;
my $targetBeginFound = 0;
my $targetEndFound = 0;
my $result = 0;
my $count = 0 ;
my $enterprise;
my $server;
my $group;
my $gatewayHost;
my $targetName1;
my $targetName2;

if ( $targetName =~ /(.*?)_(.*?)_.*/gis ) {
        $targetName1 =  $1;
	$targetName2 =  $1."_".$2;
}

elsif ( $targetName =~ /(.*?)_.*/gis ) {
        $targetName1 =  $1;
	$targetName2 =  $targetName;
}
else { $targetName1 =  $targetName;}


open (SIEBELCONF, "$siebelConf");

while (my $line = <SIEBELCONF>)
{
   if($targetBeginFound == 0)
   {
 	  $targetBeginFound = &checkTargetBegin($line);
   }
   else
   {
       $targetEndFound = &checkTargetEnd($line);
       if($targetEndFound == 0)
       {
          $result = &checkTargetValidity($line);
	  if($result  == -1)
          {
	     $targetBeginFound = 0;
	     $targetEndFound = 0;
	     $result = 0;
          }
       }
       else
       {
   	 last;
       }	
    }
}

close SIEBELCONF;
if($targetBeginFound == 1 && $targetEndFound == 1)
{

 if($targetType eq $ecmAssoc::SIEBEL_ENTERPRISE)
 {
   print "em_result=".$ecmAssoc::DEPENDS_ON."|".$gatewayHost."|".$ecmAssoc::SIEBEL_GATEWAY."|".$p_host.";".$p_oracleHome.";\n";
   print "em_result=".$ecmAssoc::CONNECTS_TO."||".$ecmAssoc::ORACLE_DATABASE_TYPE."|".$gatewayHost.";".$targetName.";\n";
 }
 elsif($targetType eq $ecmAssoc::SIEBEL_SERVER)
 {
   print "em_result=".$ecmAssoc::MEMBER_OF."|".$enterprise."|".$ecmAssoc::SIEBEL_ENTERPRISE."|".$p_gatewayHost.";".$p_agentOracleHome.";\n";
 }
 elsif($targetType eq $ecmAssoc::SIEBEL_COMPGROUP)
 {
   print "em_result=".$ecmAssoc::MEMBER_OF."|".$server."|".$ecmAssoc::SIEBEL_SERVER."|".$p_host.";".$p_oracleHome.";\n";
 }
 elsif($targetType eq $ecmAssoc::SIEBEL_COMPONENT)
 {
   print "em_result=".$ecmAssoc::MEMBER_OF."|".$group."|".$ecmAssoc::SIEBEL_COMPGROUP."|".$p_host.";".$p_oracleHome.";\n";
 }
}

 # This sub routine dwichecks whether the current Target block is the correct block
 # by comparing propertyName and values with the input arugments.
 # 
 
sub checkTargetValidity
{
    my($line) =  @_;
    my($propertyName, $propertyValue) = &retrieveConfigParamsForAssoc($line);
    if( $propertyName eq "OcmProxyOracleHome")
    {
      if(!($propertyValue eq $p_oracleHome))
      {
         $result = -1;
      }
     }
     elsif($propertyName eq "host")
     {
      if(!($propertyValue eq $p_host))
       {
   	   $result = -1;
       }
     }
     elsif($propertyName eq "SIEBEL_ENTERPRISE")
     {
         $enterprise = $propertyValue;
     }
     elsif($propertyName eq "SIEBEL_SERVER")
     {
         $server =  $propertyValue;
     }
     elsif($propertyName eq "SIEBEL_COMPGROUP")
     {
         $group = $propertyValue;
     }
     elsif($propertyName eq "SIEBEL_GATEWAY")
     {
	$gatewayHost = $propertyValue;
     }

    return $result;
}



# This sub routine checks whether the input line is Target begining
# Sample:
#<Target TYPE="Siebel_Enterprise" NAME="SBA_80">
sub checkTargetBegin
{
        my($line) =  @_;
        my $result = 0;
        my $searchString1 = "<Target TYPE=\"".$targetType."\" NAME=\"".$targetName."\">";
	#my $searchString2 = "<Target TYPE=\"".$targetType."\" NAME=\"".$targetName."\">";
	if($line =~ $searchString1)
	{	
		$result = 1;
		
	}
	#elsif($line =~ $searchString2)
	#{	
	#	$result = 1;}
	
	else 
	{
		$result = 0;
	}
		
	return $result;	
}

# This sub routine checks whether the input line is Target ending
# Sample:
#</Target>
sub checkTargetEnd
{
        my($line) =  @_;
        my $result = 0;
        my $searchString = "</Target>";
        if($line =~ $searchString)
        {
                $result = 1;
        }
        else
        {
                $result = 0;
        }
        return $result;
}


# This sub routine retrieves Property Name and its Value from the input line
# Sample:
#<Property NAME="deduptypetype" VALUE="None" />
sub retrieveConfigParamsForAssoc
{
        my($line) =  @_;

        my $propertyNameIndex= rindex($line,"NAME=\"");
        my $propertyValueIndex = rindex($line,"VALUE=\"");
        my $lineEndIndex = rindex($line,"/>");

        my $propertyName = substr($line,$propertyNameIndex+6,$propertyValueIndex-($propertyNameIndex+8));
        my $propertyValue = substr($line,$propertyValueIndex+7,$lineEndIndex-($propertyValueIndex+9));

        return ($propertyName, $propertyValue);
}
