# $Header: emll/sysman/admin/scripts/siebel_config.pl /main/12 2012/09/03 23:07:00 ckannusa Exp $
#
# siebel_config.pl
#
# Copyright (c) 2006, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      siebel_config.pl - returns statistics about the siebel target
#
#    DESCRIPTION
#	 This script parses the siebel_config.cfg file and returns the system properties
#	 specific to the given Siebel target.
#
# 	 Sample Siebel Target Entry in siebel_config.cfg:
#	 <Target TYPE="Siebel_Server NAME="iwinaam33">
#	 	 <Property NAME="keyfilename" VALUE="null" />
#	     <Property NAME="configuratordllname" VALUE="sscsbc.dll" />
#	     <Property NAME="lang" VALUE="enu" />
#	     <Property NAME="actuatereportcastlang" VALUE="LANG_INDEPENDENT" />
#	     <Property NAME="actuateroxdir" VALUE="\\Siebel Reports\\" />
#	     <Property NAME="cfgtempdir" VALUE="C:\\sba80\\siebsrvr\\temp" />
#	     <Property NAME="notifyhandler" VALUE="AdminEmailAlert" />
#	     <Property NAME="cfgscriptingdll" VALUE="sscfbas.dll" />
#	     <Property NAME="certfilename" VALUE="null" />
#	     <Property NAME="cfgclientrootdir" VALUE="C:\\sba80\\siebsrvr" />
#	 </Target>
#	
#	  OUTPUT:
#   	   em_result=<PropertyName=PropertyValue>|
#   		   where <PropertyName> is the property name
#   	       <PropertyValue> is the property value
#
#
#    MODIFIED   (MM/DD/YY)
#    suhkaul     07/11/12 -  Fixing Bug  14460217,Reverting back to old target names
#    rnag        07/08/09 - adding ini check
#    rnag        05/24/09 - adding siebenv parameters
#    rnag        05/02/09 - modifying windows entries
#    rnag        04/20/09 - removing newline characters
#    rnag        03/17/09 - adding tns data config property
#    jsutton     07/26/07 - Pick up existing shared OH work
#    jsutton     07/25/07 - Shared home work
#    vesriniv    03/13/07 - Creation
#

use strict;
# association types are defined in ecmassoc.pm
use ecmAssoc;
use hostUtil;
require "emd_common.pl";
require "semd_common.pl";

my $sudoInventory = 0;
my $targetName = $ARGV[0];
my $targetType = $ARGV[1];
my $p_host = $ARGV[2];
my $p_oracleHome = $ARGV[3];
#Use this switch to collect product name and version for ECM_INSTALLED_PRODUCTS
if ($ARGV[4] eq "SUDO_INV"){
    $sudoInventory = 1;
}

my $product_version;
my $product_name;

my $sep = $^O =~ m/MSWin32/ ? "\\" : "\/";
my $oraHome = $ENV{CCR_CONFIG_HOME}.$sep."state".$sep."temp";
my @configArray = ();
my $siebelConf = $oraHome.$sep."siebel_config.cfg";
my $line;
my $finalOutput = "emresult=";
my $targetBeginFound = 0;
my $targetEndFound = 0;
my $result = 0 ;
my $count ;
my $host;
my $oracleHome;
my $targetName1;
my $targetName2;

my $osType = "";
$osType = get_osType();     # get the OS type

#Since target name is according to new naming : ie <SC>_<SCG>_<SS>_<SE>_<SG>
#It can have 0, 1,2 or more "_"'s
#Name that was used earlier was : <SC> OR <SG> etc
#Name of each target can further be having "_" : Ex - In target Name:  SBA_81_SDCV48i009
#Earlier used target name for Siebel Enterprise can either be SBA or SBA_81 or if it doesnt have any "_", then it is the name of the target :Ex gateway : SDCV48i009

if ( $targetName =~ /(.*?)_(.*?)_.*/gis ) {
        $targetName1 =  $1;
	$targetName2 =  $1."_".$2;
}

elsif ( $targetName =~ /(.*?)_.*/gis ) {
        $targetName1 =  $1;
	$targetName2 =  $targetName;
}
else { $targetName1 =  $targetName;}




open (SIEBELCONF, "$siebelConf");
while (my $line = <SIEBELCONF>)
{
	if($targetBeginFound == 0)
	{
		$targetBeginFound = &checkTargetBegin($line);
	}
	else
	{
		$targetEndFound = &checkTargetEnd($line);
		if($targetEndFound == 0)
		{
			$result = &checkTargetValidity($line);
			if($result == -1)
			{
			   @configArray = (); 
			   $targetBeginFound = 0;
			   $targetEndFound = 0;
			   $result = 0;
			}
			else
			{
			my($propertyName, $propertyValue) = &retrieveConfigParams($line);
			# Product Name and Version is required for sudo inventory metric
			if ($propertyName eq "SERVER_VERSION")
			{
				$product_name = trim($propertyValue);
			}
			if ($propertyName eq "COMP_GROUP_FULL_NAME")
			{
				$product_version = trim($propertyValue);
			}
			if(($targetType eq $ecmAssoc::SIEBEL_ENTERPRISE) && ($propertyName eq "connect"))
			{
			#in windows,the sid names are case-insensitive,so we  convert and store the 'connect' property in upper  case.This enables consistent mtching during database association.However in unix,both SID and tns are case-sensitive.
				if($osType eq "WIN")
				{
					$propertyValue=uc trim($propertyValue);
				}

			}
                           $finalOutput .= "$propertyName|$propertyValue";
			   push(@configArray, $finalOutput);
		   	   $finalOutput = "em_result=";
			}
		}
		else
		{
			if ($sudoInventory == 1)
			{
				#output for  ECM_INSTALLED_PRODUCT metric	
				print "em_result="."$product_version|$product_name"."\n";
			}
			else
			{
				foreach $result (@configArray)
				{
					print $result."\n";
				}

			}
			last;
		}
	}
}

close SIEBELCONF;

# This sub routine checks whether the input line is Target begining
# Sample:
#<Target TYPE="Siebel_Enterprise" NAME="SBA_80">
sub checkTargetBegin
{
	my($line) =  @_;
	my $result = 0;
	my $searchString1 = "<Target TYPE=\"".$targetType."\" NAME=\"".$targetName."\">";
	#my $searchString2 = "<Target TYPE=\"".$targetType."\" NAME=\"".$targetName."\" DISPLAY_NAME=\"".$targetName2."\">";
	if($line =~ $searchString1)
	{	
		$result = 1;
		#$targetName = $targetName1;
		
	}
	#elsif($line =~ $searchString2)
	#{	
	#	$result = 1;
		#$targetName = $targetName2;
	#}	
	else 
	{
		$result = 0;
	}
	$count = $count + 1 ;
	#print $count."\n" ;
		
	return $result;		
}

# This sub routine checks whether the input line is Target ending
# Sample:
#</Target>
sub checkTargetEnd
{
	my($line) =  @_;
	my $result = 0;
	my $searchString = "</Target>";
	if($line =~ $searchString)
	{
		$result = 1;
	}
	else
	{
		$result = 0;
	}	
	return $result;		
}

# This sub routine retrieves Property Name and its Value from the input line
# Sample:
#<Property NAME="deduptypetype" VALUE="None" />
sub retrieveConfigParams
{
	my($line) =  @_;
	my $result;
	
	my $propertyNameIndex= rindex($line,"NAME=\"");
	my $propertyValueIndex = rindex($line,"VALUE=\"");
	my $lineEndIndex = rindex($line,"/>");

	my $propertyName = substr($line,$propertyNameIndex+6,$propertyValueIndex-($propertyNameIndex+8));

	my $propertyValue = substr($line,$propertyValueIndex+7,$lineEndIndex-($propertyValueIndex+9));
	
	#$result = "$propertyName|$propertyValue";
        return ($propertyName, $propertyValue)
#	return $result;
}

# This sub routine checks whether the current Target block in the siebel_config.cfg file is the correct
# ior not by comparing various propertyName and Values.
#
sub checkTargetValidity
{
        my($line) =  @_;
        my($propertyName, $propertyValue) = &retrieveConfigParams($line);

        if($propertyName eq "host")
        {
           if($propertyValue eq $p_host)
           {
                   $host = $host;
           }
           else
           {
                  $result = -1;
           }
        }
        elsif($propertyName eq 'OcmProxyOracleHome')
        {
           if($propertyValue eq $p_oracleHome)
           {
                   $oracleHome= $propertyValue;
           }
           else
           {
                  $result = -1;
           }
        }
        return $result;
} 
