# $Header: emll/sysman/admin/scripts/siebel_local_config.pl /main/7 2011/02/17 21:46:42 suhkaul Exp $
#
# siebel_config.pl
#
# Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      siebel_local_config.pl - returns statistics about the siebel server target
#
#    DESCRIPTION
#	 This script parses the langauge files in sisbel server installation
#    and returns the enabled languages
#
#	  OUTPUT:
#   	   em_result=<Enabled Languaged=Languages>
#
#
#    MODIFIED   (MM/DD/YY)
#    suhkaul     01/09/11 - Fixing Bug 10093704
#    rnag        08/04/09 - enable local collection
#    vesriniv    04/25/07 - add base.txt
#    vesriniv    04/03/07 - Creation
#

use strict;
# association types are defined in ecmassoc.pm
require "semd_common.pl";
use hostUtil;
my $targetName = $ARGV[0];
my $targetType = $ARGV[1];
my $osType = "";
$osType = get_osType();     # get the OS type
my $servicenamepresent = 1 ;




my $ccrHome = $ENV{'CCR_HOME'};
my $sep = $^O =~ m/MSWin32/ ? "\\" : "\/";
my $line;

my $productHome = $ENV{'LL_ORACLE_HOME'};
my $pos;
my $delimccrHome;
my $installdir = "$ccrHome${sep}..${sep}";

	EMD_PERL_DEBUG("CCR Home = $ccrHome\n");
	EMD_PERL_DEBUG("CCR Product Home = $productHome\n");

#For the case where the ccr is installed at siebel root or the server home,
#we would be collecting the local config for the siebel server here.
#If the ccr is installed at gateway home ,then the gateway collector 
#should not go about collecting server config.
#It should be left to the server collector itself.
$delimccrHome="$ccrHome${sep}";
$pos=index($delimccrHome,"${sep}gtwysrvr${sep}");

if($pos < 0)
{
	#If the collector is installed at the siebel root,the nwe need to adjust the  installdir of the collector accordingly.
	$pos=index($delimccrHome,"${sep}siebsrvr${sep}");
	if($pos < 0)
	{
	$installdir = "$ccrHome${sep}..${sep}siebsrvr${sep}";
	}

	EMD_PERL_DEBUG("Server Install dir = $installdir\n");
	searchLangFiles();
	getBaseInfo();

#get the environment variables specified in siebenv.sh
	getPerfEnvVars();
	#get the odbc maiiping from ini file
	getDBConnect();
	#Now get the DSN values in tnsnames.ora 
	getDSNInfo();

}

##
# retrieve language specific files under siebel server directory.
##
sub searchLangFiles
{
   # construct 'bin' directory under siebel server installdir
   my $bin = "${installdir}bin";


   my @langdirs = <${bin}/*/translation.txt>;
   my $entry;
   my $output="";
   foreach $entry (@langdirs)
   {
      # need to extract part of file indicated by '*' above -
      # simply split at '/' characters and extract all but last
      # element of the resulting array.
      #
      # check if the code below ('/') works on windows and Unix!
      my @base = split('/', $entry);
      my $basesize = @base;
      my $language = $base[$basesize - 2];
      $output = $output."".$language.";";
      #print "em_result = ${installdir}/${language}.txt\n";
   }

      print "em_result=Enabled Languages|".$output."\n";
}

##
# retrieve information from  base.txt.
##
sub getBaseInfo
{
    my $baseFileLoc  = $installdir.$sep."base.txt";
    my $result="";
    open (BASEFILE, "$baseFileLoc");
    while (my $line = <BASEFILE>)
    {
	chomp($line);    
        $result = $result.$line." \\";
	EMD_PERL_DEBUG("Line = $line\n");
	EMD_PERL_DEBUG("Result = $result\n");
    }
    chop($result);
    print "em_result=Base File Contents|".$result."\n";

}

# retrieve environment variables from siebenv.
##
sub getPerfEnvVars
{
	my $result;
	my $siebenvpath=&getSiebEnvFile();
	EMD_PERL_DEBUG("  siebenv location  : $siebenvpath \n");
	if((defined $siebenvpath) && (length($siebenvpath) > 0))
	{
    		&printEnvVars($siebenvpath);
	}

}
#This function returns the path to the siebenv
sub getSiebEnvFile()
{
	my $siebenvfile="";
	my $siebenvfilepath="";
	if($osType eq "WIN")
	{
		#Look for siebenv.sh in the default location
		$siebenvfile = "${installdir}\\bin\\siebenv.bat";
		if(-e $siebenvfile)
		{
			$siebenvfilepath="${installdir}\\bin\\siebenv.bat";
		}
	}
	else
	{
		$siebenvfile = "${installdir}/siebenv.sh";
		if(-e $siebenvfile)
		{
			$siebenvfilepath=$siebenvfile;
		}
	}
	$siebenvfilepath=trim($siebenvfilepath);
	return $siebenvfilepath;
}
#This function parses the siebenv ,to print out hte config environment variables
sub printEnvVars()
{
	my($siebfile) =  @_;

	open (IN, "<$siebfile") or EMD_PERL_DEBUG("Unable to open $! \n",$siebfile);

	my $var;
	my $line;
	my $val;
	my $lenarr;
	my @array=();
	my @siebarr=();

	while(<IN>)
	{
	@siebarr=split(/;/);
	$line = $siebarr[0];
	chomp($line);
	if ( $line =~ /OSD/ )
	{
		EMD_PERL_DEBUG(" env var  entry : $line \n");	
		 $_= $line;
		($var,$val)=/^(.*?)=(.*)$/;
		if(length($var) ne 0)
		{
			@array=split(' ',$var);
			$lenarr=@array;
			#env can ve set as export <var> = <val>
			#or <var>=<val>;export <var>
			if($lenarr==1)
			{
			$var=$array[0];
			}
			elsif($lenarr==2)
			{
			$var=$array[1];
			}
			else
			{
				$var='';
			}

			EMD_PERL_DEBUG(" env var : $var entry : $val \n");	
			if($var ne ''){
				 print "em_result=".$var."|".$val."\n"; 
			}
		}	
	}

	}
}
#This function parses the odbc ini
sub getDBConnect()
{
	my $dsnInfo="";
	my $siebodbcini = "${installdir}\/sys\/.odbc.ini";
	my $key="";
	my $connectMap= "";
	my $line;
	my $f;
	my @a=();
	my $subKey;

	my $error="No errors\n";
	
	my $odbcnode;
	my $rootininode="HKEY_LOCAL_MACHINE/SOFTWARE/ODBC/ODBC.INI/";
	my $subkey;
	EMD_PERL_DEBUG(" getDBConnect: open ini entries fir $osType\n");
	if($osType eq "WIN")
	{
		eval {
		require Win32::TieRegistry;
		import Win32::TieRegistry;
		$Win32::TieRegistry::Registry->Delimiter("/");
		$key = $Win32::TieRegistry::Registry->{"HKEY_LOCAL_MACHINE/SOFTWARE/ODBC/ODBC.INI/"} or $error="ERROR , $^E\n";
		EMD_PERL_DEBUG(" getDBConnect:  registry error $error \n");




		my @members=keys( %{$key} );
		
		foreach (@members){
			if (m/^(.*)\/$/) {
			#This represents the child nodes o fthe ODBC INI node
			$odbcnode=$1;
			$subkey=$Win32::TieRegistry::Registry->{$rootininode.$odbcnode."/"} or $error="ERROR , $^E\n";
			EMD_PERL_DEBUG(" getDBConnect:  child node => $odbcnode  ERROR: $error \n");


			my @valArr=keys(%{$subkey});
			foreach  (@valArr) {
				if (m/^\/(.*)$/) {
				if ($1  =~ /^ServerName$/) {
			#in windows the tnsname is case insensitive ,owing to the fact taht the windows service always treats service names in upper case.so we store the tns names in upper case.
				my $connectname=uc trim($subkey->{"/ServerName"});
				$odbcnode=uc trim($odbcnode);
				EMD_PERL_DEBUG(" getDBConnect: connect-node value $connectname\n");



				$connectMap= $connectMap.$odbcnode."~".$connectname;
				$connectMap= $connectMap."#";
				}
				}
			}
			}
		}
		}#end of eval
	}
	else
	{
		EMD_PERL_DEBUG(" getDBConnect: open ini file from : $siebodbcini \n");
        open (IN, "<$siebodbcini") or EMD_PERL_DEBUG("Unable to open $! \n",$siebodbcini);

		while(<IN>)
		{

		$line = $_;
		chomp($line);
		EMD_PERL_DEBUG("getDBConnect:  ini file entry : $line \n");	
		if ($line =~ /^\[(\S+)\]/) {
			$f=$1;	
		}
		if ($line =~ /ServerName/) {
                @a = split("=", $line);
		$odbcnode =uc trim($a[1]);#unix has shown case-insensitivity too.
                $connectMap= $connectMap.$f."~".$odbcnode;
			$connectMap= $connectMap."#";
		}
		}
	}

		EMD_PERL_DEBUG(" server odbcDSN property : $connectMap\n");	
		print "em_result=odbcDSN|".$connectMap."\n";
}
# retrieve database information from  tnsname.
##
sub getDSNInfo
{
	my $result;
	my $tnsfilepath=&getoraDSNpath();
	EMD_PERL_DEBUG("  tnsnames location  : $tnsfilepath \n");

	if((defined $tnsfilepath) && (length($tnsfilepath) > 0))
	{
             my $fragment =  substr $tnsfilepath, -1, 1;
		if($fragment ne ";")
		{
			$tnsfilepath=$tnsfilepath.";";
		}
    		$result=&getDSN($tnsfilepath);
	}
    	print "em_result=hostDSNinfo|".$result."\n";

}
#This function returns the path to the tnsnames
sub getoraDSNpath()
{
	my $tnsfile="";
	my $tnsfilepath="";
	my $error="";
	EMD_PERL_DEBUG("The OS : $osType \n");
	EMD_PERL_DEBUG("oracle home :  $ENV{ORACLE_HOME}  tnsadmin : $ENV{TNS_ADMIN} \n");

	
	if($osType eq "WIN")
	{
		eval {
		require Win32::TieRegistry;
		import Win32::TieRegistry;
		$Win32::TieRegistry::Registry->Delimiter("/");
	
		#We scrape the registry for all oracle homes
		my $rootoranode="HKEY_LOCAL_MACHINE/SOFTWARE/ORACLE/";
		my $key = $Win32::TieRegistry::Registry->{"HKEY_LOCAL_MACHINE/SOFTWARE/ORACLE/"} or $error="ERROR , $^E\n";
		EMD_PERL_DEBUG(" getDSN:  oracle home registry error $error \n");


		my $subkey="";
		my $orahome="";
		my $sidpresent=0;
		my $orahomeloc="";
		my @members=keys( %{$key} );
		
		foreach (@members){
		if (m/^(.*)\/$/) {
		#This represents the child nodes o fthe ORACLE node
		$orahome=$1;
		$subkey=$Win32::TieRegistry::Registry->{$rootoranode.$orahome."/"} or $error="ERROR , $^E\n";
		EMD_PERL_DEBUG(" getDSN:  child ora node => $orahome  ERROR: $error \n");


		my @valArr=keys(%{$subkey});
		foreach  (@valArr) {
			if (m/^\/(.*)$/) {

						if ($1  =~ /^ORACLE_SID$/) {
						$sidpresent=1;
						$servicenamepresent=0;
						}				

						if ($1  =~ /^ORACLE_HOME$/){
						$orahomeloc=$subkey->{"/ORACLE_HOME"};
						EMD_PERL_DEBUG(" getDSN: oracla home location value $orahomeloc\n");
						}
			}
		}
		# && ($sidpresent eq 1))
		if((length($orahomeloc ne 0))) 
		{
			$tnsfile = "$orahomeloc\\network\\admin\\tnsnames.ora";
			if(-e $tnsfile)
			{
				$tnsfilepath=$tnsfile.";".$tnsfilepath;
			}
		}
		$orahomeloc="";
		$sidpresent=0;

		}
		}#iterating members
		}#end of eval
	}
	else
	{
		#Look for tnsnames.oraa in the default location
		if(($tnsfilepath eq "") &&(defined $ENV{TNS_ADMIN})){
			$tnsfile = "$ENV{TNS_ADMIN}/tnsnames.ora";
			if(-e $tnsfile)
			{
				$tnsfilepath=$tnsfile;
			}
		}
		#the remaining are used for solaris
		if($tnsfilepath eq ""){
			$tnsfile = "/etc/tnsnames.ora";
			if(-e $tnsfile)
			{
				$tnsfilepath=$tnsfile;
			}
			elsif (-e "/var/opt/oracle/tnsnames.ora")
			{
				$tnsfilepath="/var/opt/oracle/tnsnames.ora";
			}
		}
		#if still not discovered,go to oratab
		if($tnsfilepath eq ""){
		my $tabfile = q{/etc/oratab};
		open (ORATAB,$tabfile) or EMD_PERL_DEBUG("Unable to open $! \n",$tabfile);
		my @oratab=<ORATAB>; # slurp in the whole file
		chomp @oratab; # remove end of line char

		#exclude entries whch are comments
		my $currhome;
		my @tabstr = grep(/^\w/,@oratab);


		foreach  $currhome (@tabstr) {
		if ( $currhome !~ m/^$/) {
		# split data out of first element
		my ($database, $oh, $startFlag) = split(/:/,$currhome);
		if((length($oh  ne 0)) && ($oh ne ""))
		{
			$tnsfile = "$oh//network//admin//tnsnames.ora";
			if(-e $tnsfile)
			{
			$tnsfilepath=$tnsfile.";".$tnsfilepath;
			}
		}
		}
		}#end of iterating oracle homes

		}#end of checking oratab
	}
	$tnsfilepath=trim($tnsfilepath);
	return $tnsfilepath;
}
#This function parses the tnsnames.ora
sub getDSN()
{
	my $dsnInfo="";
	my($tnsarg) =  @_;
	my $sid;
	my $host;
	my $port;
	my $dsn;
	my $line;
	my $outline;
     
      my $tnsfile;



	my $isopened;
	my @tnsArr = split(';', $tnsarg);
	for my $tnsfile  (@tnsArr) {
		$isopened=open (IN, "<$tnsfile");
		if(!$isopened)
		{
			next;
		}

		while(<IN>)
		{
			$line = $_;
			if($line!~/^#/)
			{
			chomp($line);
			$outline = $outline.$line;
			if ( $line =~ /SID|SERVICE|SERVICE_NAME/i )
			{
				EMD_PERL_DEBUG(" tns entry : $outline \n");
				 $_= $outline;
				($dsn,$host,$port,$sid)=/(\w+)(?=.*\(HOST\s*=(.*?)\))?(?=.*\(PORT\s*=(.*?)\))?(?=.*\((?:SID|SERVICE|SERVICE_NAME)\s*=(.*?)\))?/i;

				if(($sid) && ($host) && ($port)){
					$host=trim($host);
					$port=trim($port);
					$sid=trim($sid);
				#In windows and unix,convert the TNS to upper-case.Both of them have shown insensitivity to case of TNS adressname.
					$dsn=uc trim($dsn);
					$dsnInfo=$dsnInfo . $dsn . "~";
					$dsnInfo=$dsnInfo .$host . ":" . $port . ":" . $sid . "#"; 
				$outline ="";
				}
			}
			}
		}#close the file handle
			close(IN);
		
	}#iterating tnsArr
	EMD_PERL_DEBUG("DSN xml :  $dsnInfo \n");
	

	return $dsnInfo;
}
