#!/usr/local/bin/perl
# 
# $Header: smtp_service_test.pl 14-jul-2005.03:36:37 vesriniv Exp $
#
# smtp_service_test.pl
# 
# Copyright (c) 2003, 2005, Oracle. All rights reserved.  
#
#    NAME
#      smtp_service_test.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vesriniv    07/14/05 - fix success string 
#    fsalim      07/08/05 - fix4478756
#    fsalim      07/04/05 - To return the error status message 
#    mbisarya    12/12/04 - to change for recipient email id 
#    tjaiswal    11/12/04 - tjaiswal_test_type_impl
#    skpanigr    11/04/04 - Updated the result to return Txn name and Beacon name
#    skpanigr    11/04/04 - Modified instance variables to USER input variables
#    skpanigr    11/04/04 - Creation
# 
use Net::SMTP;
use Time::HiRes;
use Getopt::Long; # set up to accept user input

####
# This script sends a test email to the mail server specified.
# returns down status if the server could not be contacted.
#
    
# Common params
#$target_name=$ENV{EM_TARGET_NAME};
## FOR NT look for COMPUTERNAME
#$agent_host=$ENV{HOST};

#SMTP parameters
GetOptions(\%cmdLine,
            "BeaconName=s",
            "TxnName=s",
            "retryinterval=i",
            "numretries=i",
            "smtp_address=s",
            "smtp_recipient_id=s",
            "smtp_sender_id=s");

my $beaconName = $cmdLine{"BeaconName"};
my $txnName = $cmdLine{"TxnName"};
my $smtp_address = $cmdLine{"smtp_address"};
my $smtp_recipient_id = $cmdLine{"smtp_recipient_id"};
my $smtp_sender_id = $cmdLine{"smtp_sender_id"};
my $smtp_fail_count = $cmdLine{"numretries"};
my $retryinterval = $cmdLine{"retryinterval"};


#default
$smtp_fail_count = 6 unless (exists  $cmdLine{"numretries"});
$retryinterval = 5 unless (exists  $cmdLine{"retryinterval"});

# metrics
######
# $connect_time
# $time_to_send
# $total_time
# $errTxt
####
$total_time = 0;
$connect_time = 0;
$time_to_send = 0;
$errTxt = "Success";

print "Service $smtp_address, $smtp_timeout : Sender $smtp_sender_id : Recipient $smtp_recipient_id\n";

$start_time = Time::HiRes::time();

# the number of failed login try 
$fail_count = 0;

do 
{
     	sleep $retryinterval if $fail_count >0;

	if (defined $smtp_timeout)
	{
		$smtp = Net::SMTP->new($smtp_address, Timeout=>$smtp_timeout);
	}
	else
	{
		$smtp = Net::SMTP->new($smtp_address, Timeout=>60);
	}

	if (defined $smtp) 
        {
          $status = 1;
        }
	else 
        {
          $fail_count++;
        }
	print "SMTP Login Count = $fail_count, status = $status\n";
}while ($fail_count < $smtp_fail_count && $status == 0);



### The content of the email can be made rich
### with time when the email was sent, from where it was sent, for which 
### target it was sent etc.

if($status==1)
{
    $connect_time = Time::HiRes::time() - $start_time;
    $start_time = Time::HiRes::time();
    $smtp->mail($smtp_sender_id);
    $smtp->to($smtp_recipient_id);
   
    # send a large message, maybe an attachement too
    $smtp->data();
    $smtp->datasend("To: $smtp_recipient_id\n");
    $smtp->datasend("Subject: Test message\n");
    $smtp->datasend("\n");
    $smtp->datasend("Test message from smtp_test script\n");

    $smtp->dataend();

    $time_to_send = Time::HiRes::time() - $start_time;    

    $total_time = toMilliSec($connect_time + $time_to_send);
    $connect_time = toMilliSec($connect_time);  
    $time_to_send = toMilliSec($time_to_send);

    print "Connect Time = $connect_time\n";
    print "Time To Send= $time_to_send\n";
    print "Total Time = $total_time\n";
    #print "em_result=$status|$total_time|$connect_time|$time_to_send\n";
    printf ("em_result=$txnName|$beaconName|$status|$total_time|$connect_time|$time_to_send|$errTxt\n");
    $smtp->quit;  
}
else
{
    $errTxt = "Could not connect to smtp server, please check machine name and port number"; 
    print "Connection failed\n";
    $status = 0;
    printf ("em_result=$txnName|$beaconName|$status|$total_time|$connect_time|$time_to_send|$errTxt\n");
}

sub toMilliSec 
{
    my ( $time_in_sec) = @_;
    return $time_in_sec * 1000;
}

