#!/usr/bin/sh
#
# $Header: snapshotDataCollect.sh 24-jan-2003.16:43:48 goramamo Exp $
#
# Program
#
# Copyright (c) 2002, Oracle Corporation.  All rights reserved.  
#
#   NAME snapshotDataCollect.sh
#
#   DESCRIPTION
#       Creates a /tmp/hostname_snapshot.tar file 
#       contains hardware and software data
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#     goramamo   11/21/02 - Make changes as per Ptdpm0.pm
#     rmenon     10/19/02 - rmenon_bug_fixes_and_rt_changes
#     goramamo   03/04/02 - Created
#
#*************************************************

echo "Start time "
date "+ %m/%d/%y %H:%M:%S"

# Create required Directories

       direc=/tmp/`hostname`_snapshot
       rm    -rf $direc
       mkdir -p $direc/etc/default
       mkdir -p $direc/pkg
       mkdir -p $direc/getent
       mkdir -p $direc/ndddev
       currdir=`pwd`

# Automatic  Collections

       sh -c "LC_ALL=C /usr/bin/uname -s"  > $direc/unames.out
       sh -c "LC_ALL=C /usr/bin/uname -r"  > $direc/unamer.out
       sh -c "LC_ALL=C /usr/bin/uname -v"  > $direc/unamev.out
       sh -c "LC_ALL=C /usr/bin/uname -mi" > $direc/unamemi.out
       sh -c "LC_ALL=C /usr/bin/mach    "  > $direc/mach.out
       sh -c "LC_ALL=C /usr/bin/arch -k "  > $direc/archk.out
       sh -c "LC_ALL=C /usr/bin/hostname"  > $direc/hostname.out

       sh -c "LC_ALL=C /usr/sbin/nslookup `hostname`" > $direc/nslookuphost.out
       sh -c "LC_ALL=C /usr/bin/getent hosts `hostname`" > $direc/getent/`hostname`.out
       sh -c "LC_ALL=C /usr/bin/getent hosts 127.0.0.1"  > $direc/getent/127.0.0.1.out
       sh -c "LC_ALL=C /usr/bin/showrev  "  > $direc/showrev.out

       sh -c "LC_ALL=C /usr/bin/df -F ufs -k | /usr/bin/tail +2;/usr/bin/df  -F vxfs -k | 

/usr/bin/tail +2" > $direc/dfFufsk.out

       sh -c "LC_ALL=C /usr/platform/`uname -m`/sbin/prtdiag -v " > $direc/prtdiagv`uname -m`.out

       sh -c "LC_ALL=C /usr/platform/`uname -i`/sbin/prtdiag -v " > $direc/prtdiagv`uname -i`.out

       file=usr/kvm/prtdiag
       if [  -f "/$file" ]; then
          sh -c "LC_ALL=C /$file -v "  > $direc/prtdiagvkvm.out
       fi

       file=etc/system
       if [  -f "/$file" ]; then
          /usr/bin/cp /$file  $direc/$file
       fi

       sh -c "LC_ALL=C /usr/sbin/modinfo"   > $direc/modinfo.out
       sh -c "LC_ALL=C /usr/sbin/swap -l"   > $direc/swapl.out
       sh -c "LC_ALL=C /usr/sbin/ifconfig -a" > $direc/ifconfiga.out
       sh -c "LC_ALL=C /usr/bin/isalist"     > $direc/isalist.out

       /usr/bin/ipcs -a
       sh -c "LC_ALL=C /usr/sbin/sysdef -i"  > $direc/sysdefi.out
       sh -c "LC_ALL=C /usr/bin/getconf -a"  > $direc/getconfa.out

       sh -c "LC_ALL=C /usr/sbin/ndd /dev/tcp \? | grep write"  > $direc/ndddev/tcp.out
       sh -c "LC_ALL=C /usr/sbin/ndd /dev/udp \? | grep write"  > $direc/ndddev/udp.out
       
       file=etc/mnttab
       if [  -f "/$file" ]; then
          /usr/bin/cp /$file  $direc/$file
       fi

       file=etc/default/init
       if [  -f "/$file" ]; then
          /usr/bin/cp /$file  $direc/$file
       fi

       file=etc/defaultrouter
       if [  -f "/$file" ]; then
          /usr/bin/cp /$file  $direc/$file
       fi

       file=etc/resolv.conf
       if [  -f "/$file" ]; then
          /usr/bin/cp /$file  $direc/$file
       fi

       file=var/sadm/pkg
       if [  -d "/$file" ]; then
          cd   /$file
          tar  -cvf $direc/pkg/pkg.tar */pkginfo
          cd $direc
       fi
       
# Manual Collection
#       sh -c "LC_ALL=C /usr/sbin/arp   $inet " > $direc/arp.out
#       sh -c "LC_ALL=C /usr/bin/getent hosts $inet " > $direc/getent/$inet.out
#       sh -c "LC_ALL=C /usr/sbin/ndd /dev/tcp \? | grep write ; /usr/sbin/ndd /dev/udp \? | grep write"  > $direc/ndddevtcpvalues.out

# Get Gold Files

#scriptsdir=$EMDAGENT/sysman/admin/scripts
#perl $scriptsdir/ecmSysData1.pl ALL $scriptsdir > $direc/all.xml

cd $currdir
perl ecmSysData1.pl ALL             .  > $direc/all.xml
perl ecmSysData1.pl HARDWARE        .  > $direc/hw.xml
perl ecmSysData1.pl OS_SOFTWARE     .  > $direc/os.xml
perl ecmSysData1.pl VENDOR_SOFTWARE .  > $direc/rs.xml

# Bundle all the files into a tar file
 cd /$direc
 tar -cvf /tmp/`hostname`_Snapshot.tar *
 cd /tmp
 rm -rf $direc

echo "End time"
date "+ %m/%d/%y %H:%M:%S"

# End of the program
