#!/bin/sh
#
# $Header: swapList.sh 14-oct-2004.06:06:42 sacgoyal Exp $
#
# swapList.sh
#
# Copyright (c) 2002, 2004, Oracle. All rights reserved.  
#
#    NAME
#      swapList.ksh - List status of swap areas
#
#    DESCRIPTION
#      Lists the status of all areas. Obtains the swaplen value for the
#      area and the number of free blocks (in kilobytes)
#
#    NOTES
#      Currently this script is specific to Sun Solaris OS. For other OS,
#      the script may need to be modified.
#
#    MODIFIED   (MM/DD/YY)
#    sacgoyal    10/14/04 - for fixing bug # 3845407 & 3841061 
#    mbhoopat    03/10/04 - linux port 
#    vsekuboy    10/09/02 - Changes for HP and Linux
#    dmshah      04/03/02 - dmshah_support_host_metris
#    dmshah      04/02/02 - Creation
#

uname=`uname -s`

if [ "$uname" = "HP-UX" ] ; then
   PATH=/usr/bin:/usr/sbin
   export PATH

   swapinfo -d | grep -v PCT | grep -v TYPE | awk '{printf "em_result=%s|%s|%s\n", $9,$2,$4}'
   swapinfo -f | grep -v PCT | grep -v TYPE | awk '{printf "em_result=%s|%s|%s\n", $9,$2,$4}'
   exit
elif [ "$uname" = "Linux" ] ; then
  if [ -x /usr/bin/awk ] ; then
    AWK=/usr/bin/awk
  elif [ -x /usr/local/bin/awk ] ; then
    AWK=/usr/local/bin/awk
  else
    echo "Cannot find awk - exiting."
    exit
  fi
  cat /proc/swaps | grep -v -i size | $AWK ' {printf "em_result=%s|%s|%s\n",$1,$3,($3-$4)}'
  exit
elif [ "$uname" = "OSF1" ] ; then
   PATH=/usr/bin:/usr/sbin
   export PATH

   page_size=`getconf PAGE_SIZE`;
   swapon -s | awk 'BEGIN {i=0}
                      /Total/ {exit}
                      /partition/ {i++; part[i] = $3}
                      /Allocated/ {alloc[i] = $3}
                      /Free/ {free[i] = $3}
                    END {for (j = 1; j <= i; j++) {
                          split(part[j], device, ":");
                          printf("em_result=%s|%s|%s\n",
                                  device[1], alloc[j]*'$page_size'/1024,
                                  free[j]*'$page_size'/1024)
                          }
                        }'

   exit 0
elif [ "$uname" = "AIX" ] ; then
   PATH=/usr/bin:/usr/sbin
   export PATH
 
   lsps -t lv | tail +2 |
                awk 'BEGIN {i=0}
                     {i++; part[i] = $2; alloc[i] = $4; pctu[i] = $5}
                     END {for (j = 1; j <= i; j++) {
                           split(alloc[j], mb, "MB");
                           printf("em_result=%s|%d|%d\n",
                                   part[j], mb[1]*1024,
                                   (mb[1]-((mb[1]*pctu[j])/100))*1024)
                           }
                         }'
   exit 0
elif [ "$uname" = "Darwin" ] ; then
   $EMDROOT/bin/nmupm osLoad | awk -F'|' '{ printf("em_result=/private/var/vm|%d|%d\n", ($NF+$(NF-1))/1024, $NF/1024); }'
   exit 0
elif [ "$uname" = "SunOS" ] ; then
  # Which awk to use?
  if [ -x /bin/nawk ] ; then
    AWK=/bin/nawk
  elif [ -x /usr/bin/nawk ] ; then
    AWK=/usr/bin/nawk
  elif [ -x /bin/awk ] ; then
    AWK=/bin/awk
  else
    echo "Cannot find awk - exiting."
    exit
  fi

 if [ -x /usr/sbin/swap ] ; then
    SWAP=/usr/sbin/swap
  elif [ -x /bin/swap ] ; then
    SWAP=/bin/swap
  elif [ -x /etc/swap ] ; then
    SWAP=/etc/swap
  elif [ -x /sbin/swap ] ; then
    SWAP=/sbin/swap
  elif [ -x /bin/swap ] ; then
    SWAP=/bin/swap
  else
    SWAP=swap
  fi

# The swap -l returns information in 512 byte blocks. To convert it to kb
# we divide by 2.

  $SWAP -l | grep -v 'blocks' | $AWK ' { printf "em_result=%s|%s|%s\n", $1, ($4/2), ($5/2) } '
else
  echo "$uname  not supported"
  exit
fi
