#  $Header: sysxml.pl 05-may-2003.13:02:23 vsekuboy Exp $
#
# Copyright (c) 2001, 2003, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      sysxml.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vsekuboy    05/05/03 - Replaced uname with ^O
#    vsekuboy    04/29/03 - corrected oraInst.loc for platforms
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    agor        07/17/01 - Creation
#

##*********************************************************
##
## Program:	SysInfo.perl
## Authour:	Gopi Ramamoorthy
## CopyRight:	Oracle Corporation, USA
## Date:	03/20/2001
##
##*********************************************************
## Flow of the program
##
## BEGIN & Initialize
##
## HW Detection
##	Files Declaration
##	Data Collection
##	Data Format
##	Data Summarizing
##	End
##
## SW Detection
##	Files Declaration
##	Software Version Detection
##	Software components (Packages,Patches) Detection
##	End
##
## Finalize & END
##
##*********************************************************

#Special Procedures
# BEGIN
# END
# sub AUTOLOAD

BEGIN{ 
	#print "Processing..... please wait\n\n ";
	#print `date "+ %m/%d/%y %H:%M:%S"`;
}

##Initialization
 Initialize();
 XMLInitialize();

##Start of the Hardware Detection 

##Initialization
 HWInitialize();

##Process
 
 ReadImageReleaseFile();
 
 GetSystemHWDetails();
 FilterCollectedData();
 FormatCollectedData();
 
##Finanlization
 HWFinalize();
 
## End of Hardware Detection

##Start of the Software Detection

##Initialization
 SWInitialize();
 
## Process

#C  ExtractSunOSVersion();
#C  ExtractSunPackages();
# ExtractSunPackageVersions();

#C ExtractVeritasVersion();
#C ExtractVeritasPackages();
# ExtractVeritasPackageVersions();

ExtractSunPatches();
#C ExtractSunObsoletePatches();

#C ExtractVeritasPatches();
#C ExtractVeritasObsoletePatches();

#C ExtractOracleDBVersion();
#C ExtractOracleFileDiffs();

#C ExtractOraclePackages();
#C ExtractOraclePatches();
#C ExtractOracleObsoletePatches();

##Release Resources and finalize
#C SWFinalize();

##Error Handling Subroutines
# ErrorHandling();

## End of the Software Detection
 Finalize();
## End of the Detection Program SystemInfoCollect.pl
 
##================================================
## SUBROUTINES  
##================================================
sub  Initialize{
  $CurrPos="Initialize";
}

##================================================
## H A RD W A RE DETECTION SUBROUTINES  
##================================================
sub HWInitialize{
	$CurrPos="HWInitialize";
        $l=1; ##Special variable to flush the buffer;

        print "<NODE_CONFIGURATION>";
        print "<NC_DATA NAME=\"Hardware\" TYPE=\"HW_TYPE\" DESCRIPTION=\"General System Hardware Information.\">" ;

        $RawHWData = tmp1;
        $FormatHWData=tmp2;
        $PerlHWSum=tmp3;
	$Release=tmp4;


}
sub ReadImageReleaseFile{
	$CurrPos="ReadImageReleaseFile";

        system `/usr/bin/showrev > $RawHWData `;

        open(IN19,$RawHWData);
        while(<IN19>) 
        {

           ($Id,$Value)=split(":",$_);chomp($value);


	   print $strdata, $Id, $middata, $Value, $enddata;
#           print $Id, ":", "\n", $Value;
            
        }
           
        close(IN19);
        
        #For VOS configuraions, the release file is at /etc/opt/SUNWvosr/release 

        $i=0;

#        system `cp /etc/opt/SUNWvosr/release  $Release ` || warn "Release File does not exist";
#        system `cp /etc/opt/SUNWvosr/release  $RawHWData ` || die "Release File does not exist";
         #system `cp /etc/opt/SUNWvosr/release  $Release `;
#Ayyappan commented it ...to be fixed latter
#C         system `cp /export/home/goramamo/SUNWvosr/release  $Release `;
#       if -r /etc/opt/SUNWvosr/release; 
        open(IN1,$Release);
        while(<IN1>) 
        { 
                        $i++;
        }   
        close(IN1);
		$vosimage="$strdata VOS Image Version $middata $value $enddata";
		$vosdate="$strdata VOS Image Build Date $middata $value $enddata";
        if($i>0){
		open(IN1,$Release);
		$i=0;
		
	        while(<IN1>)
	        {
                        if ($i==0){$value=$_;chomp($value);print $vosimage;}
                        if ($i==1){$value=$_;chomp($value);print $vosdate;}
                        $i++;
	        }
	        close(IN1);

	        #while(<IN1>)
	        #{
                #        if ($i==0){print "VOS Image Version : \n", $_;}
                #        if ($i==1){print "VOS Image Build Date : \n",$_;}
                #        $i++;
	        #}
	        #close(IN1);

        }
	else{
               $value=" ";print $vosimage;
               $value=" ";print $vosdate;

	#	print "VOS Image Version : \n";
	#	print " Not Found\n";
	#	print "VOS Image Build Date : \n";
	#	print " Not Found\n";

	}


}

sub GetSystemHWDetails{
  $CurrPos="GetSystemHWDetails";
        #print  "Start of System Hardware Data Collection\n";

        system `/usr/platform/sun4u/sbin/prtdiag -v > $RawHWData`;
 

}

sub FilterCollectedData{
  $CurrPos="FilterCollectedData";
        #print  "In FilterCollectedData\n";
        @id=(   "System Configuration",
                "System clock frequency",
                "Memory size ",
                "CPUs ",
                "Memory ", ##optional
                "IO Cards",
                "Fans",
                "Power Supplies",
                "System Failures",
                "HW Revisions");


        open(IN1,"$RawHWData")|| die "Present   Packages file  pkgPre cannot be opened IN mode";
        #open(IN1,"lotharHW")|| die "Present   Packages file  pkgPre cannot be opened IN mode";            
        open(OUT2,">$FormatHWData");

        ##Initialization
        $basic=1;
        $FanFlag=0;
        $PowerFlag=0;

        while(<IN1>){
                if((substr($_,1,2) ne "==") && ($basic==1)){
                        @input=split(":",$_);
                        if(@input>1){
                                #if (@input[0] eq @id[$j]){
 
                                        #for ($i=0;$i<@input;$i++){
                                                #print  $input[$i];
                                                #print OUT2 "GENER:", $input[$i];
                                                print OUT2 "GENER:", $_;
                                        #}
                                #}
                        }
                }

                else{
                        $basic=0;
                        $Row=$_;
                        #print " SubString is " , substr($_,26,5), "\n";
                        if(substr($_,1,10) eq "=========="){
                                $RowID=substr($_,26,5);
                                print OUT2 $RowID, ":", $Row;
                        }
                        ##New Additions
                        elsif((substr($_,0,5) eq "Fans:") || ($FanFlag==1)){

                                $RowID="FANS ";

                                $FanFlag=1;
                                if(substr($_,0,15) eq "Power Supplies:") {
                                        $FanFlag=2;$RowID="POWER";
                                        #$PowerFlag=1;
                                }
                                print OUT2 $RowID, ":", $_;
                        }
                        elsif((substr($_,0,15) eq "Power Supplies:") || $PowerFlag==1){
                                $RowID="POWERSE";
                                $FanFlag=2;
                                $PowerFlag=1;
                                if (substr($_,0,5) eq "====="){
                                        $PowerFlag=2;
                                }
                                print OUT2 "POWER:", $_;
                        }
                        else{   print OUT2 $RowID, ":", $_; }
                }
        }

        close(OUT2);

 GetMemoryDetails();
 GetIOCardDetails();
 
 GetHWRevisionDetails();

}

sub FormatCollectedData{
  $CurrPos="FormatCollectedData";

        $NoOfBrd=0;
        $NoOfCPU=0;
        $NoOfCards=0;
        $NoOfFan=0;
        $NoOfPower=0;
        $CPUDone=0;
        $FanDone=0;
        $MemoryDone=0;
        $IOCardsDone=0;
        @BrdName[0]="dummy";

        open(IN2,"$FormatHWData")|| die "cannot open PerlHWData in IN mode";
        open(OUT3 ,">$PerlHWSum");


        while(<IN2>){
                #print   "==>",$_;
                ($RefRecID,$RefArray)=split(":",$_);
                if($RefRecID eq "GENER"){
                        ($RecID,$RecData)=split(":",(substr($_,6)));
                        #print  $RecID ,":\n", $RecData ; 
                        print  $strdata, $RecID, $middata, $RecData, $enddata ; 
                }
                if($RefRecID eq "CPUs "){
                        #print "\n substr(RefArray,0,3)", substr($RefArray,0,3);
                        if((substr($RefArray,0,3) eq "   ")||
                           (substr($RefArray,0,3) eq "===")||
                           (substr($RefArray,0,3) eq "Brd")||
                           (substr($RefArray,0,3) eq "---")||
                           (substr($RefArray,0,1) eq "\n")){
                        }
                        else{
                                #print  "RefArray ", $RefArray, "<br>\n";
                                @RefArray2=split(" ",$RefArray,4);
                                #print  "RefArray2[3] ", @RefArray2[3], "<br>\n";
			chomp(@RefArray2[3]);
                        print  $strdata, "CPU", $middata, @RefArray2[3], $enddata ; 
                                #C print   "CPU:\n";
                                #C print    @RefArray2[3];
                                $NoOfCPU++;

                                ##Number of boards calculation
                                $BrdNameSize=@BrdName;
                                #print "BoardName Actual ", $RefArray2[0], "\n"; 
                                for($m=0;$m<$BrdNameSize;$m++){
                                   if($RefArray2[0] eq @BrdName[$m]){
                                        last;
                                   }
                                   elsif($m==($BrdNameSize-1)){
                                        $BrdName[$m+1]=$RefArray2[0];
                                   }
                                }

                        }
                }
                if($RefRecID eq "Memor"){
                        if ($CPUDone==0){ WriteCPUDetails();}
                        $CPUDone=1;
                        #print  "Memory $CPUDOne ", $CPUDone;
                }
                if($RefRecID eq "IO Ca"){
                        #print  "IO Ca $CPUDOne ", $CPUDone;
                        if ($CPUDone==0){ WriteCPUDetails();}
                        $CPUDone=1;

                        if(substr($RefArray,0,11) eq "No failures"){
			chomp($NoOfCards);
			chomp($RefArray);
                        print  $strdata, "NoOfCard", $middata, $NoOfCards, $enddata ; 
                        print  $strdata, "SYSTEM STATUS", $middata, $RefArray, $enddata ; 
                                #C print   "NoOfCard:\n" , $NoOfCards, "\n";
                                #C print   "SYSTEM STATUS:\n" , $RefArray;
                        }
                        elsif((substr($RefArray,0,3) eq "   ")||
                           (substr($RefArray,0,3) eq "===")||
                           (substr($RefArray,0,3) eq "Brd")||
                           (substr($RefArray,0,3) eq "---")||
                           (substr($RefArray,0,1) eq "\n")){
                        }
                        else{
                                #print  "RefArray ", $RefArray, "<br>\n";
                                @RefArray4=split(" ",$RefArray,2);
                                #print  "RefArray4[1] ", @RefArray4[1], "<br>\n";
			chomp(@RefArray4[1]);
                        print  $strdata, "IOCARD", $middata, @RefArray4[1], $enddata ; 
                                #C print   "IOCARD:\n";
                                #C print    @RefArray4[1];
                                $NoOfCards++;
                        }

                }
                if($RefRecID eq "FANS "){
                        #print "\n substr(RefArray,0,3)", substr($RefArray,0,3);
                        if((substr($RefArray,0,4) eq "Fans")||
                           (substr($RefArray,0,3) eq "===")||
                           (substr($RefArray,0,8) eq "Fan Bank")||
                           (substr($RefArray,0,3) eq "---")||
                           (substr($RefArray,0,3) eq "   ")||
                           (substr($RefArray,0,1) eq "\n")){
                        }
                        else{
                                #print  "RefArray ", $RefArray, "<br>\n";
                                @RefArray2=split(" ",$RefArray);
                                #print  "RefArray2[3] ", @RefArray2[3], "<br>\n";
				chomp(@RefArray2);
				print $strdata, "FAN", $middata, @RefArray2, $enddata;
                                #C print   "FAN:\n";
                                #C $RefArraySize=@RefArray2;
                               # print    @RefArray2[0], " ",@RefArray2[$RefArraySize-1], "\n";
                                $NoOfFan++;
                        }

                }
                if($RefRecID eq "POWER"){
                        #print "\n substr(RefArray,0,3)", substr($RefArray,0,3);
                        if((substr($RefArray,0,3) eq "   ")||
                           (substr($RefArray,0,3) eq "===")||
                           (substr($RefArray,0,6) eq "Supply")||
                           (substr($RefArray,0,6) eq "Power ")||
                           (substr($RefArray,0,3) eq "---")||
                           (substr($RefArray,0,1) eq "\n")){
                        }
                        else{
                                #print  "RefArray ", $RefArray, "<br>\n";
                                @RefArray2=split(" ",$RefArray);
                                #print  "RefArray2[3] ", @RefArray2[3], "<br>\n";
                               # print   "POWER:\n";
                                $RfArraySize=@RefArray2;
                                print   $strdata,"POWER", $middata, @RefArray2[$RfArraySize-1], $enddata ;
                                $NoOfPower++;
                        }

                }
                if($RefRecID eq "HW Re"){
                        if($FanDone==0){WriteFanAndPowerSupply();}
                        if(substr($_,6,5) ne "====="){}
                }

        }
}

sub WriteCPUDetails{
  $CurrPos="WriteCPUDetails";
        print  $strdata, "NoOfCPU", $middata, $NoOfCPU, $enddata;
        $NoOfBrd=@BrdName;
        print  $strdata, "NoOfBrd", $middata, $NoOfBrd-1, $enddata;

        #for($i=0;$i<$NoOfBrd;$i++){
        #    print "Board Name :", @BrdName[$i];
        #}

}

sub WriteFanAndPowerSupply{
  $CurrPos="WriteFanAndPowerSupply";
        print $strdata,  "NoOfFan", $middata;
        if ($NoOfFan<1){print  ""}
        else{ print $NoOfFan ;}
        print $enddata;

        print  $strdata, "NoOfPower Supplies",$middata; 
        if($NoOfPower<1){print ""}
        else{ print $NoOfPower;}
        print $enddata;

        $FanDone=1;
}

sub GetCPUDetails{
  $CurrPos="GetCPUDetails";

}

sub GetMemoryDetails{
  $CurrPos="GetMemoryDetails";
}

sub GetIOCardDetails{
  $CurrPos="GetIOCardDetails";
}

sub GetHWRevisionDetails{
  $CurrPos="GetHWRevisionDetails";
}

sub HWFinalize{
  $CurrPos="HWFinalize";

        close IN2;
        close  OUT3;
       # print "\$ \n" ;
        
        print "</NC_DATA>" ;
}

sub Commented{
  $CurrPos="Commented";

}



##================================================##
##   S O F T W A R E DETECTION SUBROUTINES        ##
##================================================##

##------------------------------------------------##
sub SWInitialize{
  $CurrPos="SWFinalize";

##Files Declaration

 $PCF=tmp5;
 $ComRep=CompleteReportFile;
 $FilRep=FilteredReportFile;


 $i=0;
   
   #print  "Start of System Software Data Collection\n";
   
   open(OUT2,">$ComRep");
   print OUT2  " ================================================\n";
   print OUT2 "             Oracle Corporation \n";
   print OUT2 "       Certified Configuration Checker \n";
   print OUT2 "                    Results \n";
   print OUT2 "                ", `date "+ %m/%d/%y %H:%M:%S"`; 
   print OUT2  " ================================================\n";
   
   open(OUT3,">$FilRep");
   print OUT3  " ================================================\n";
   print OUT3 "              Oracle Corporation \n";
   print OUT3 "       Certified Configuration Checker \n";
   print OUT3 "                  Results \n";
   print OUT3 "                ", `date "+ %m/%d/%y %H:%M:%S"`; 
   print OUT3  " ================================================\n";
}
##-------------------------------------------##

sub ExtractSunOSVersion{
  $CurrPos="ExtractSunOSVersion";

#Operating System

        #system `/usr/bin/uname -X  > $PCF `;

        #open(IN8,$PCF);
        #while(<IN8>) 
        #{
        #  ($Id,$Value)=split("=",$_);
        #   if($Id eq "System "){
        #       print "Operating System:\n";
        #       print $Value;
        #  }
        #   if($Id eq "Release "){
        #       print "Version:\n";
        #       print $Value;
        #   }
        #
        #}
        #close(IN8);
        
        system `/usr/bin/showrev > $PCF `;

        open(IN18,$PCF);
        while(<IN18>) 
        {
           ($Id,$Value)=split(":",$_);
           if($Id eq "Kernel version"){
                print "Operating System:\n";
                print $Value;
           }
           
        }
        close(IN18);
        
}
#Veritas
sub ExtractVeritasVersion{
  $CurrPos="ExtractVeritasVersion";
        #system `/opt/VRTSvmsa/bin/vmsa_server -V > $PCF `;

#    @pkg={"VRTSvxvm","VRTSdbed","VRTSvxfs"};
#    $NoOfPkg=@pkg;
#    for($i=0;$i<$NoOfPkg;$i++){
#       $Name=`pkginfo -l $pkg[$i] | grep NAME`;
#       $Version=`pkginfo -l $pkg[$i] | grep VERSION`;
        #@Name=split(/:/,$vsoft);
        #@Version=split(/:/,$Version);
        #$len0=index(@Name[1],"VERITAS");
        #$len=index(@Name[1],"\n")-$len0;
        #print substr(@Name[1],$len0,$len), ":\n";
        #print @Version[1];
#    }

system `/usr/bin/pkginfo | tr -cs "[:alpha:]" "[\n*]" | grep VRTS |
                awk '{ print $2}' |sort -u | tr -s "\n*]" " "> $PCF`;

        open(IN22,$PCF);

        while(<IN22>){
                if(index($_,"VRTSvxvm")>-1){$vm=1;}
                if(index($_,"VRTSdbed")>-1){$db=1;}
                if(index($_,"VRTSvxfs")>-1){$fm=1;}

        }
        close(IN22);

    if($vm==1){
        $vsoft=`pkginfo -l VRTSvxvm | grep NAME`;
        $Version=`pkginfo -l VRTSvxvm | grep VERSION`;
        @Name=split(/:/,$vsoft);
        @Version=split(/:/,$Version);
        $len0=index(@Name[1],"VERITAS");
        $len=index(@Name[1],"\n")-$len0;
        print substr(@Name[1],$len0,$len), ":\n";
        print @Version[1];
    }
    if($db==1){
        $vsoft=`pkginfo -l VRTSdbed | grep NAME`;
        $Version=`pkginfo -l VRTSdbed | grep VERSION`;
        @Name=split(/:/,$vsoft);
        @Version=split(/:/,$Version);
        $len0=index(@Name[1],"VERITAS");
        $len=index(@Name[1],"\n")-$len0;
        print substr(@Name[1],$len0,$len), ":\n";
        print @Version[1];
    }

    if($fm==1){
        $vsoft=`pkginfo -l VRTSvxfs | grep NAME`;
        $Version=`pkginfo -l VRTSvxfs | grep VERSION`;
        @Name=split(/:/,$vsoft);
        @Version=split(/:/,$Version);
        $len0=index(@Name[1],"VERITAS");
        $len=index(@Name[1],"\n")-$len0;
        print substr(@Name[1],$len0,$len), ":\n";
        print @Version[1];
    }

}

#Oracle
sub ExtractOracleDBVersion{
   $CurrPos="ExtractOracleDBVersion";

   $uname = $^O;

   if ($uname eq "solaris" || $uname eq "hpux") {
      system `cp /var/opt/oracle/oraInst\.loc $PCF`;
   }
   else {
      system `cp /etc/oraInst\.loc $PCF`;
   }

   open(IN20,"$PCF") || die "Not able to open PCF file in IN mode";
   
   while(<IN20>){
        ($RecId,$RecValue)=split("=");
        if($RecId eq "inventory_loc"){
            #next; #Get out of loop
            $OraHome=$RecValue;
            #print "Ora Home ", $OraHome;
            last;
        }
   }
   close(IN20);
   
   #print "Oracle Home", $OraHome;
   $len=index($OraHome,"\n");
   $Compons=substr($OraHome,0,$len) . "/Components/*";
   $Patches=substr($OraHome,0,$len) . "/Patches/*";
   $PatSets=substr($OraHome,0,$len) . "/PatchSets/*";
      
   system `ls $OraHome > $PCF`;
   
   $PatchFlag=0;
   $PatchSetFlag=0;

   open(IN22,"$PCF") || die "Not able to open PCF file in IN mode";
   while(<IN22>){
        if($_ eq "Patches"){
                $PatchFlag=1;
        } 
        if($_ eq "PatchSets"){
                $PatchSetFlag=1;
        }
   }
   close(IN22);
   print "\$\n" ;
   
   system "ls $Compons | grep 8. > $PCF";
   verfind();
   print "Oracle Database Release:\n" , $Version ;

   if ($PatchFlag==1){system "ls $Patches | grep 8. > $PCF";}
   verfind();
   print "Oracle Patches Release:\n" , $Version ;

   if ($PatchSetFlag==1){system "ls $PatSets | grep 8. > $PCF";}
   verfind();
   print "Oracle Patch Sets Release:\n" , $Version ;

     
}


##SUN Packages Extraction
sub ExtractSunPackages{
        #print  " ExtractSunPackages\n";
        print OUT2 " ExtractSunPackages\n";
        print OUT3 " Extracting Sun Packages Details\n";
        system `/usr/bin/pkginfo | tr -cs "[:alpha:]" "[\n*]" | grep SUNW |
                awk '{ print $2}' |sort -u | tr -s "\n*]" " "> $PCF`;

        open(IN1,$PCF);


        print   "SUN OS PACKAGES: \n";

        while(<IN1>){
        # print "i is", $i, "\n";
         $i++;
         @SUNPACKARRAY=split(" ",$_);
        $SUNPACKARRAYSIZE=@SUNPACKARRAY;
        for($i=0;$i<$SUNPACKARRAYSIZE;$i++){
           print @SUNPACKARRAY[$i], "\n" ;
         }
        }
       # print   "\n";
        close(IN1);
}



##SUN Packages Version Extraction
sub ExtractSunPackageVersions{
  $CurrPos="ExtractSunPackages";
        #print  " ExtractSunPackages\n";
        print OUT2 " ExtractSunPackages\n";
        print OUT3 " Extracting Sun Packages Details\n";
        system `/usr/bin/pkginfo | tr -cs "[:alpha:]" "[\n*]" | grep SUNW | 
                awk '{ print $2}' |sort -u | tr -s "\n*]" " "> $PCF`;

        open(IN1,$PCF);


        print   "SUN OS PACKAGES: \n";

        while(<IN1>){
        # print "i is", $i, "\n";
         $i++;
         @SUNPACKARRAY=split(" ",$_);
        $SUNPACKARRAYSIZE=@SUNPACKARRAY; 
        for($i=0;$i<$SUNPACKARRAYSIZE;$i++){
           print @SUNPACKARRAY[$i], "\n" ;
                $SunPkgVer=`pkginfo -l @SUNPACKARRAY[$i] | grep VERSION`;
                @SunPkgVers=split(":",$SunPkgVer);
                $SunPkg=join(" ",@SUNPACKARRAY[$i],@SunPkgVers[1]);
                print $SunPkg;
       #    print @SUNPACKARRAY[$i], "\n" ;
         } 
        }
       # print   "\n";
        close(IN1);
        die;
}

##VERITAS Packages Extraction
sub ExtractVeritasPackages{
  $CurrPos="ExtractVeritasPackages";
        #print  " Extracting Veritas Packages Details\n";
        print OUT2 " ExtractVeritasPackages\n";
        print OUT3 " Extracting Veritas Packages Details\n";
        system `/usr/bin/pkginfo | tr -cs "[:alpha:]" "[\n*]" | grep VRTS | 
                awk '{ print $2}' |sort -u | tr -s "\n*]" " "> $PCF`;

        open(IN2,$PCF);

        print   "VERITAS PACKAGES:\n";

        while(<IN2>){
         #print "i is", $i, "\n";
         $i++;
         @VERPACKARRAY=split(" ",$_);
        $VERPACKARRAYSIZE=@VERPACKARRAY; 
        for($i=0;$i<$VERPACKARRAYSIZE;$i++){
           print @VERPACKARRAY[$i], "\n" ;
         } 
        }
       # print   "\n";
        close(IN2);
}

##VERITAS Packages Version Extraction
sub ExtractVeritasPackageVersions{
  $CurrPos="ExtractVeritasPackages";
        #print  " Extracting Veritas Packages Details\n";
        print OUT2 " ExtractVeritasPackages\n";
        print OUT3 " Extracting Veritas Packages Details\n";
        system `/usr/bin/pkginfo | tr -cs "[:alpha:]" "[\n*]" | grep VRTS |
                awk '{ print $2}' |sort -u | tr -s "\n*]" " "> $PCF`;

        open(IN2,$PCF);

        print   "VERITAS PACKAGES:\n";

        while(<IN2>){
         #print "i is", $i, "\n";
         $i++;
         @VERPACKARRAY=split(" ",$_);
        $VERPACKARRAYSIZE=@VERPACKARRAY;
        for($i=0;$i<$VERPACKARRAYSIZE;$i++){
           print @VERPACKARRAY[$i], "\n" ;
         }
        }
       # print   "\n";
        close(IN2);

#    @pkg={"VRTSvxvm","VRTSdbed","VRTSvxfs"};
#    $NoOfPkg=@pkg;
#    for($i=0;$i<$NoOfPkg;$i++){
#       $Name=`pkginfo -l $pkg[$i] | grep NAME`;
#       $Version=`pkginfo -l $pkg[$i] | grep VERSION`;
#       @Name=split(/:/,$Name);
#       @Version=split(/:/,$Version);
#       print @Name[1], ":\n";
#       print @Version[1];
#    }

}

##Extraction of ORACLE Packages
sub ExtractOraclePackages{
  $CurrPos="ExtractOraclePackages";
        #print  " Extracting Oracle Details\n";
        print OUT2 " ExtractOraclePackages\n";
        print OUT3 " Extracting Oracle Packages Details\n";
        # 
}

##Extraction of SUN Patches
sub ExtractSunPatches{
  $CurrPos="ExtractSunPatches";
        #print  " ExtractSunPatches\n";
        print OUT2 " ExtractSunPatches\n";
        print OUT3 " Extracting Sun Patches Details\n";

        system `/usr/bin/showrev -p | tr -s "RO" "[\n*]" | grep Patch | tr -s ":" "[\n*]" | grep "-" |sort -u | tr -s "\n*]" " " > $PCF `;

        open(IN4,$PCF);

        print   "<NC_DATA NAME=\"OS Software Patches\" TYPE=\"OS_SW\" DESCRIPTION=\"Sun Microsystems operating system patch software.\">";

        while(<IN4>){
           #print "i is", $i, "\n";
           $i++;
           @SUNPATARRAY=split(" ",$_);
           $SUNPATARRAYSIZE=@SUNPATARRAY; 
           for($i=0;$i<$SUNPATARRAYSIZE;$i++){
               print $strdata, "SUN OS PATCHES", $middata, @SUNPATARRAY[$i], $enddata ;
           } 
        }
        print "</NC_DATA>";	
       # print   "\n";
        close(IN4);
}

##Extraction of SUN Obsolete Patches
sub ExtractSunObsoletePatches{
  $CurrPos="ExtractSunObsoletePatches";
        #print  " ExtractSunObsoletePatches\n";
        print OUT2 " ExtractSunObsoletePatches\n";
        print OUT3 " Extracting Sun Obsolete Patches Details\n";

        system `/usr/bin/showrev -p | tr -s "RO" "[\n*]" | grep bsolete | tr -s ":" "[\n*]" | grep "-" |sort -u | tr -s "," " " | tr -s "\n*]" " "> $PCF `;
        ##system `/usr/bin/showrev -p | tr -s "RO" "[\n*]" | grep bsolete | sort -u | tr -s ":/," " "> $PCF `;


        open(IN5,$PCF);
        print   "SUN OS OBSOLETE PATCHES: \n";

        while(<IN5>){
         @patches=split(/:/,$_);
         
        # print "i is", $i, "\n";
         $i++;
         @SUNOBPATARRAY=split(" ",$_);
        $SUNOBPATARRAYSIZE=@SUNOBPATARRAY; 
        for($i=0;$i<$SUNOBPATARRAYSIZE;$i++){
           print @SUNOBPATARRAY[$i], "\n" ;
         } 
        }
       # print   "\n";
        close(IN5);
}

##Extraction of VERITAS Patches
sub ExtractVeritasPatches{
  $CurrPos="ExtractVeritasPatches";
   #print  " ExtractVeritasPatches\n";
   print OUT2 " ExtractVeritasPatches\n";
   print OUT3 " Extracting Veritas Patches Details\n";
        ##cat vxpat | tr -cs "[:alpha:]" "[\n*]" | grep vx | tr -s "\n*]" " " > $PCF
        #system `/usr/sbin/modinfo | grep vx | tr -cs "[:alpha:]" "[\n*]" | grep vx | tr -s "\n*]" " " > $PCF`;
        system `/usr/sbin/modinfo | grep vx  > $PCF`;
        print   "VERITAS PATCHES: \n";
        open(IN6,$PCF);

        while(<IN6>){
                @patches=split(" ",$_,6);
                print @patches[5];
        }
#        while(<IN6>){
#         @patches=split(/:/,$_);
#         
#        # print "i is", $i, "\n";
#         $i++;
#         @VERPATARRAY=split(" ",$_,5);
#        $VERPATARRAYSIZE=@VERPATARRAY; 
#        for($i=0;$i<$VERPATARRAYSIZE;$i++){
#           print @VERPATARRAY[$i], "\n" ;
#         } 
#        }
       # print   "\n";
        close(IN6);
}

##Extraction of VERITAS Obsolete Patches
sub ExtractVeritasObsoletePatches{
  $CurrPos="ExtractVeritasObsoletePatches";
}

##Extraction of ORACLE Patches
sub ExtractOraclePatches{
  $CurrPos="ExtractOraclePatches";
print OUT3 " Extracting Oracle Database and Patch Details\n";
}

##Extraction of ORACLE Obsolete Patches
sub ExtractOracleObsoletePatches{
  $CurrPos="ExtractOracleObsoletePatches";
}

sub SWFinalize{
  $CurrPos="SWFinalize";
  print OUT2 "\n End of System Software Data Collection\n";
  print OUT3 "\n End of System Software Data Collection\n";
  
  close(OUT2);
  close(OUT3);
  
  
}
sub verfind{
open(IN10,"$PCF") || die "Not able to open PCF file in IN mode";

   $highver1=0; $highver2=0;

   while(<IN10>){

        #print $_;
        @num=split(/\./);
        $size=@num;

        $j=0;$V1=0;$V2=0;
        while($j<$size){

            SWITCH:{
                $j==0 && do {   $V1=@num[$j]*10000;
                                last SWITCH;
                            };
                $j==1 && do {   $V1=$V1 + @num[$j]*100;
                                last SWITCH;
                            };
                $j==2 && do {   $V1=$V1 + @num[$j];
                                last SWITCH;
                            };
                $j==3 && do {   $V2=@Val[$j]*100;
                                last SWITCH;
                            };
                $j==4 && do {   $V2=$V2 + @Val[$j];
                                last SWITCH;
                            };
                $j>4  && do {   #print "**** Version Number is greater
                                #than Six digits\n";
                                last SWITCH;
                            };
            }##End of SWITCH
            $j++;
        } ## End of While

        if($V1>$highver1){$highver1=$V1; $highver2=$V2;$Version=$_;}
        elsif(($V1==$highver1)&&(V2>$highver2)){$highver2=$V2;$Version=$_;}



   }## End of File

   #print "Version :", $highver1, "  ", $highver2, "  Version " , $Version, "\n"
;
#   print "Oracle Database Release:\n" , $Version ;

   close(IN10);
}

sub ErrorHandling{
  #   $CurrPos="ErrorHandling";
   print "The control was in ", $CurrPos;
}
 
sub Finalize{
        $CurrPos="Finalize";
        print "</NODE_CONFIGURATION>";
}

sub AUTOLOAD{
        my(@arguments)=@_;
        $args=join(',',@arguments);
        print"$AUTOLOAD was never defined.\n";
        print "The arguments passed were $args. \n";
}

END {
#   print "The last subroutine to run was ", $CurrPos, "\n";
#   print "The last line executed was ", _LINE_, "\n";
#   print "The system error message $!\n";
#   print `date "+ %m/%d/%y %H:%M:%S"`;
}

sub ExtractOracleFileDiffs{
	print "MISSING FILES:\n";
	print "CHANGED FILES:\n";
	print "MISSING OBJECTS:\n";
	print "CHANGED OBJECTS:\n";
	print "MISSING ARCHIVES:\n";



}

sub XMLInitialize{

	   $strdata="<NC_OBJECT NAME=\"";
	   $middata="\" VALUE=\"";
	   $enddata="\"/>\n";
}
