#  $Header: topProcs.pl 30-jan-2005.23:06:13 sacgoyal Exp $
# 
# Copyright (c) 2001, 2005, Oracle. All rights reserved.  
#
#    NAME
#      topProcs.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This script lists up to 20 processes including: 
#      -  the top 10 processes that comsume the most CPU time in %
#      -  the top 10 processes that use the most memory (on Solaris in the order 
#         of percentage memory used, on HP in the order physical memory in Kb)  
#  
#    MODIFIED  (MM/DD/YY)
#       sacgoyal 01/21/05 - fix bug#4007330: %cpu-util correction 
#       vsekuboy 10/10/02 - Added changes for HP, Linux, AIX and OSF1
#       xxu     06/25/02 - remove /usr/local/bin/perl
#       lnhan   03/14/01 - Creation
#

use English;
use hostGenFunctions;

#utility function
sub convertTimeToSecs {
    local($time) = @_;
    $secs = 0;
    @t_array = split(":", $time);
    if(@t_array == 3) {
	($h,$m,$s) = @t_array;
	$secs = ($h*3600);
    } else {
	($m, $s) = @t_array;
    }
    $secs += ($m*60)+$s;
    return $secs;
}

# This method is required for Tru64 (OSF1). The memory usage on Tru64 is
# given with the size suffix (e.g. 2.04M). This should be parsed and
# converted to KB.
sub convertSizeToKB
{
   @splitArray = split(//, $_[0]);
   $sizeKB = "";

   for ($i = 0; $i < $#splitArray; $i++)
   {
      $sizeKB = $sizeKB.$splitArray[$i];
   }

   if ($splitArray[$#splitArray] eq 'M')
   {
        $sizeKB = $sizeKB * 1024;
   }
   if ($splitArray[$#splitArray] eq 'G')
   {
        $sizeKB = $sizeKB * 1024 * 1024;
   }
   return $sizeKB;
}

@processList = ();
@sortProcessList = ();
%topPmemS = ();
%topProcS = ();
$count=0;

$ENV{PATH} = "/usr/bin:/usr/sbin:/bin:/usr/local/bin";
# Get the type of Operating System
chomp ($os = `uname -s`) or die "Failed to run the uname command";
SWITCH: {
  $os eq "SunOS" && do {
                         chomp ($ver = `uname -r`);
                         if ( $ver !~ /^4./ ) {
			     $os = "SOL";
                             @processList = `/bin/ps -efo \"pmem, pcpu, time, vsz, rss, user, pid, args\"` or die "Failed to run ps\n";
                             last SWITCH;
                         }
                       };
  $os eq "HP-UX" && do {
                            $ENV{UNIX95} = "XPG4";
			    $os = "HP-UX";
			    $pgsize=`getconf SC_PAGE_SIZE`;
                            @processList = `/bin/ps -efo vsz,sz,pcpu,time,user,pid,args` or die "Failed to run ps\n";
                            last SWITCH; 
                       }; 
  $os eq "Linux" && do {
			      $os = "Linux";
			      @processList = `/bin/ps -www -eo "pmem pcpu time vsz rss user pid args"` or die "Failed to run ps\n";
			      last SWITCH;
                       };
  $os eq "AIX" && do {
                        @processList = `/bin/ps au` or die "Failed to run ps\n";
                        last SWITCH;
                     };
  $os eq "OSF1" && do {
                            @processList = `ps -eo "pmem pcpu time vsz rss user pid args"` or die "Failed to run ps\n";
                            last SWITCH;
                       };
  die "Unupported Operating System\n";
}
shift @processList;
# sort in reverve numeric order
@sortedProcessList = sort { $b <=> $a } @processList; 

foreach $process (@sortedProcessList) {
   chomp($process);

   #discount perl and ps processes
   if ($process ne '') {
       if($os eq "SOL") {
	   ($pmem, $pcpu, $time, $size, $res, $user, $pid, $comm) = split (" ", $process,8);
       } elsif ($os eq "HP-UX") {
	   ($size, $sz, $pcpu, $time, $user, $pid, $comm) = split (" ", $process,7);
       } elsif ($os eq "Linux") {
           ($pmem, $pcpu, $time, $size, $res, $user, $pid, $comm) = split (" ", $process,8);
       } elsif ($os eq "OSF1") {
           ($pmem, $pcpu, $time, $size, $res, $user, $pid, $comm) = split (" ", $process,8);
       } elsif ($os eq "AIX") {
	   if ((index($process,'perl') == -1) and (index($process,"/bin/ps au")==-1))
	   {
              ($user, $pid, $pcpu, $pmem, $size, $res, $junk, $junk, $rest) = split(" ", $process,9);
              ($junk , $comm) = split (" ", $rest, 2);
              if ( $junk=~m/:/ )
              {
                   ($junk, $time, $comm) = split (" ", $rest, 3);
              }
              else
              {
                   ($junk, $junk, $time, $comm) = split (" ", $rest, 4);
              }
	   }
       }
       next if $pid == $$; #eliminate current perl process.

      # put value in array pidS
      $pidS{$pid}=$process;

      # put the top 10 processes (On Solaris in the order of % memory used, on HP virtual memory) 
      # in hash topProcS 
      if ($count <10) {
         $topProcS{$pid}=$process;
         $count++;
      }
      # put value in hash pcpuS
      $pcpuS{$pid}=$pcpu;
   }
}


$count=0;
foreach $sorted_item (sort {$pcpuS{$b} <=> $pcpuS{$a}} keys %pcpuS) { 
   # add the top 10 processes (in terms of pcpu usage) to hash pmemS
   if ($count < 10) {
      $topProcS{$sorted_item} = $pidS{$sorted_item}; 
      $count++;
   }
   else {
      last;
   }
}

# split hash topProcS and put values in hash topPmemS 
foreach $line (%topProcS) {
   chomp($line);
       if($os eq "SOL") {
	   ($pmem, $pcpu, $time, $size, $res, $user, $pid, $comm) = split (" ", $line,8);
       }elsif ($os eq "HP-UX") {
	   ($size, $sz, $pcpu, $time, $user, $pid, $comm) = split (" ", $line,7);
	   $res=$sz*($pgsize/1024);
	   $pmem = `$ENV{EMDROOT}/bin/nmupm mempct $res`;
       }elsif ($os eq "Linux") {
           ($pmem, $pcpu, $time, $size, $res, $user, $pid, $comm) = split (" ", $line,8);
       }elsif ($os eq "OSF1") {
           ($pmem, $pcpu, $time, $size, $res, $user, $pid, $comm) = split (" ", $line,8);
       }elsif ($os eq "AIX") {
           ($user, $pid, $pcpu, $pmem, $size, $res, $junk, $junk, $rest) = split(" ", $line,9);
           ($junk , $comm) = split (" ", $rest, 2);
           if ( $junk=~m/:/ )
           {
                ($junk, $time, $comm) = split (" ", $rest, 3);
           }
           else
           {
                ($junk, $junk, $time, $comm) = split (" ", $rest, 4);
           }
       }
   $topPmemS{$pid} = $pmem; 
}


# sort hash topPmemS by values (pmem) in reverse order
foreach $sorted_line  (sort {$topPmemS{$b} <=> $topPmemS{$a}} keys %topPmemS) {
   $ps_line = $topProcS{$sorted_line}; 
   chomp($ps_line);   

   if ($ps_line ne '') { 
       if($os eq "SOL") {
	   ($pmem, $pcpu, $time, $size, $res, $user, $pid, $comm) = split (" ", $ps_line,8);
       }elsif ($os eq "HP-UX") {
           ($size, $sz, $pcpu, $time, $user, $pid, $comm) = split (" ", $ps_line,7);
	   $res=$sz*($pgsize/1024);
	   $pmem = `$ENV{EMDROOT}/bin/nmupm mempct $res`;
	   chomp ($pmem); 
       }elsif ($os eq "Linux") {
	   ($pmem, $pcpu, $time, $size, $res, $user, $pid, $comm) = split (" ", $ps_line,8);
        my ($cpuCount, $exitStatus) = getCpuCount();  # bug-4007330
        EMD_PERL_ERROR("error in grep from /proc/cpuinfo file") if($exitStatus != 0);
        $pcpu = $pcpu / $cpuCount;
       }elsif ($os eq "OSF1") {
           ($pmem, $pcpu, $time, $size, $res, $user, $pid, $comm) = split (" ", $ps_line,8);
           $size = convertSizeToKB($size);
           $res = convertSizeToKB($res);
       }elsif ($os eq "AIX") {
           ($user, $pid, $pcpu, $pmem, $size, $res, $junk, $junk, $rest) = split(" ", $ps_line,9);
           ($junk , $comm) = split (" ", $rest, 2);
           if ( $junk=~m/:/ )
           {
                ($junk, $time, $comm) = split (" ", $rest, 3);
           }
           else
           {
                ($junk, $junk, $time, $comm) = split (" ", $rest, 4);
           }
       }

       $time = convertTimeToSecs($time);
       print "em_result=$pmem|$pcpu|$time|$size|$res|$user|$pid|$comm\n";
   } 
}
