discover(@ARGV);
sub discover
{
    #open(ERROR,">error.txt") || die $!;
    
    while(<@_>)
    {
        ($weblogicusername, $weblogicpassword, $servertype,$port, 
            $lib, $host,$keyStoreFile) = 
                                split(/\|/);
    }
    #print ERROR "UserName=$weblogicusername\n";
    #print ERROR "Password=$weblogicpassword\n";    
    #print ERROR "ServerType=$servertype\n";
    #print ERROR "Port=$port\n";
    #print ERROR "Lib=$lib\n";
    #print ERROR "Host=$host\n";
    #print ERROR "KeystoreFile=$keyStoreFile\n";
    

    $servertype = trim($servertype);
    $port = trim($port);
    $lib = trim($lib);
    $host = trim($host);
    
    my $oraHome = $ENV{ORACLE_HOME};
    my $home = $ENV{HOME};
    my $wlJarLocation;
    #my $beaHome;
    #my $wsHome;
    my $thirdPartyHome;
    my $classpath;
    chomp($os = $^O);
    if ($host and $host ne /^$/)
    {
        #print ERROR "Command with host given".$host."**\n";
        if ($servertype and $servertype ne "weblogic")
        {
            if( -e $lib."/lib/admin.jar")
            {
                $classpath = getClasspath($servertype, $lib);
                $command = $oraHome."/jdk/bin/java -Doracle.home=".$oraHome;
                if($keyStoreFile and $keyStoreFile ne /^$/)
                {
                    $command = $command." -Djavax.net.ssl.trustStore=".$keyStoreFile;
                }
                $command = $command." -cp ".$classpath." oracle.sysman.util.discover.WebsphereDiscovery  ".$port." ".$weblogicusername." ".$weblogicpassword." ".$lib." ".$host." ".$servertype;
            }
            else
            {
                print "13";
                exit(0);
            }
        }
        else
        {
            
            if( -e $lib."/weblogic.jar")
            {
                $classpath = getClasspath($servertype, $lib);
                $command = $oraHome."/jdk/bin/java -Doracle.home=".$oraHome;
                if($keyStoreFile and $keyStoreFile ne /^$/)
                {
                    $command = $command." -Dweblogic.security.SSL.trustedCAKeyStore=".$keyStoreFile;
                }
                $command = $command." -cp ".$classpath." oracle.sysman.util.discover.WeblogicDiscovery  ".$port." ".$weblogicusername." ".$weblogicpassword." ".$lib." ".$host;
            }
            else
            {
                print "12";
                exit(0);
            }
    
        }
    }
    else
    {
        if ($lib and $lib ne /^$/)
        {
            if($servertype eq "weblogic")
            {
                if( -e $lib."/weblogic.jar")
                {
                   $thirdPartyHome = $lib; 
                }
                else
                {
                    print "12";
                    exit(0);
                }
            }
            else
            {
                if( -e $lib."/lib/admin.jar")
                {
                   $thirdPartyHome = $lib; 
                }
                else
                {
                    print "13";
                    exit(0);
                }
            }
            
        }
        else
        {
            if($servertype eq "weblogic")
            {
                #print ERROR "calling getBEAHome\n";
                $thirdPartyHome = getBEAHome();
            }
            else
            {
                #print ERROR "calling getWSHome\n";            
                $thirdPartyHome = getWSHome();
            }
        }

        if ($thirdPartyHome eq "")
        {
            #the ThirdPartyConstants.NO_LIBRARY_FOUND                
            print "11";
            exit(0);
        }            

        my $ports;
        if ($port and $port ne /^$/)
        {
            $ports = $port;
        }
        else
        {
            my %openPorts = getOpenPorts();
            #system("perl $oraHome/emdw/sysman/admin/scripts/openports.pl > t");
            # print %openPorts;

            foreach $p (%openports)
            {
                chomp($p);
                if ($p > 1023)
                {
                    $ports = $p.":".$ports;
                }
            }
        }

        #print "Open Port $ports\n";
        if ($servertype and $servertype ne "weblogic")
        {
            #print ERROR "creating comand for websphere\n";
            $classpath = getClasspath($servertype, $thirdPartyHome);
            $command = $oraHome."/jdk/bin/java -Doracle.home=".$oraHome;
            if($port and $port ne /^$/)
            {
                $command = $command." -DportSpecified=".$port;
            }            
            if($keyStoreFile and $keyStoreFile ne /^$/)
            {
                $command = $command." -Djavax.net.ssl.trustStore=".$keyStoreFile;
            }            
            $command = $command." -cp ".$classpath." oracle.sysman.util.discover.WebsphereDiscovery  ".$ports." ".$weblogicusername." ".$weblogicpassword." ".$thirdPartyHome." ".$servertype;
        }
        else
        {
            my $wlLibPath;
            if ($lib and $lib ne /^$/)
            {
                $wlLibPath = $thirdPartyHome;
            }
            else
            {
                my $installDir = getWLInstallDir($thirdPartyHome);
                if($installDir eq "")
                {
                    print 11;
                    exit(0);
                }
                $wlLibPath = $installDir."/server/lib";
            }
            
            $classpath = getClasspath($servertype, $wlLibPath);
            $command = $oraHome."/jdk/bin/java -Doracle.home=".$oraHome;
            if($port and $port ne /^$/)
            {
                $command = $command." -DportSpecified=".$port;
            }
            if($keyStoreFile and $keyStoreFile ne /^$/)
            {
                $command = $command." -Dweblogic.security.SSL.trustedCAKeyStore=".$keyStoreFile;
            }            
            $command = $command." -cp ".$classpath." oracle.sysman.util.discover.WeblogicDiscovery  ".$ports." ".$weblogicusername." ".$weblogicpassword." ".$wlLibPath;
            
        }
    }

    my $libraryPath;
    if ($lib and $lib ne /^$/)
    {
        $libraryPath = "<LibraryPath path=\"".$lib."\"/>";
    }
    else
    {
        if ($servertype eq "weblogic")
        {
            $jarLoc = getWLInstallDir($thirdPartyHome);            
            $libraryPath = 
                 "<LibraryPath path=\"".$jarLoc."/server/lib\"/>";
        }
        else
        {
            $libraryPath = "<LibraryPath path=\"".$thirdPartyHome."\"/>";
        }
    }
    
    #print ERROR "command:$command*** \n";
    my $result =`$command`;
    #print "$result\n";
    if ( $result =~ m/<DiscoveredDomains>/)
    {
        my $ind = index($result, "<DiscoveredDomains>");
        my $in = $ind + length("<DiscoveredDomains>");
        my $r1 = substr($result, $in);
        my $r2 = substr($result, 0, $in);
        $result = $r2."\n".$libraryPath.$r1;
        print $result;
    }
    else
    {
        print $result;
    }
    

    #print $ports;


    sub getOpenPorts()
    {
        $ENV{PATH} = "$ENV{PATH}:/usr/bin:/usr/sbin:/usr/ucb:/bin";
        chomp($os = $^O);
        if (($os ne "MSWin32") && ($os ne "MSWin64")) 
        {
            chomp($os = `uname -s`);
        }


        @NETSTAT = `netstat -an `;
        LINE: for $userline (@NETSTAT) 
        {
            if (index($userline, "127.0.0.1") >= 0) { next LINE; }

            if (index($userline, "LISTEN") < 0 && index($userline, "IDLE") < 0) { 
                next LINE; 
            }

            # for unix  domain sockets $userline has LISTENING, skip those lines
            if ($os eq "Linux" && index($userline, "LISTENING") >= 0) { 
                next LINE; 
            }
#	print "NETSTAT: $userline\n";

            # $userline looks like on solaris:
            #	*.*                  *.*                0      0 24576      0 IDLE
            #	*.7000               *.*                0      0 24576      0 LISTEN
            #	*.3201               *.*                0      0 24576      0 LISTEN
            #	130.35.38.158.3101   *.*                0      0 24576      0 LISTEN
            #	*.*                  *.*                0      0 24576      0 IDLE
            # $userline looks like on windows:
            #	(udp|tcp) [0-9\.]*:port                  *.*                IDLE

            @points = split(/[\t\ ]+/, $userline);


            # window windows there is a : in the  line
            if (index($userline, ":") > 0) 
            {
                if ($os eq "Linux") {
                    $p1 = $points[3];
                } else {
                    $p1 = $points[2];  # windows
                }

                @point = split(/:/, $p1);

                $p = $point[$#point];	# last item within <numeric ip>:<port number>, i.e. port
                $openports{$p} += 1;	# add <port> as a key to the lookup table
            } 
            else 
            {
                if ($os eq "HP-UX" || $os eq "OSF1" || $os eq "AIX") {
                    $p1 = $points[3];
                } else {
                    $i = index($userline, " ");
                    if ($i > 0)
                    {
                        $p1 = $points[0];
                    }
                    else
                    {
                        $p1 = $points[1];
                    }
                }
#    print "NETSTAT[1] : $i \"$p1\" of \"$userline\"\n";

                if ($p1 ne "*\.*")
                {
                    @point = split(/\.+/, $p1);

                    $pl = @point;
                    $p = $point[$pl - 1];	# last item within <numeric ip>.<port number>, i.e. port
                    $openports{$p} += 1;	# add <port> as a key to the lookup table
                }
            }
        }

        return @openports;
    }

    sub trim 
    {
        my @out = @_;
        for (@out) 
        {
            s/^\s+//;
            s/\s+$//;
        }
        return wantarray ? @out : $out[0];
    }
    
    sub getWSHome
    {
        
        my $lineToParse;
        my $ws;
        my $wsHome;
        chomp($os = $^O);

        #print ERROR "getWSHome method:$os\n";

        if (($os ne "MSWin32") && ($os ne "MSWin64")) 
        {
            $ws = $home."/vpd.properties";
            #print ERROR "getWSHome method ws=$ws\n"
        }
        else
        {
        
        }

        if ( -e $ws)
        {

            open( WS, "<$ws" ) or die "Can't open $ws";

            while ( my $line = <WS> ) 
            {
                my @tempArray = split(/=/,$line);
                
                if(($tempArray[1] =~ /^WebSphere Application Server\|/) or
                    ($tempArray[1] =~ /^WebSphere Network Deployment\|/))
                {
                    $lineToParse=$tempArray[1];
                    last;
                }
            }

            #print ERROR "Out side while: $lineToParse";
            my @tokens = split(/\|/,$lineToParse);
            my $token;
            foreach $token (@tokens)
            {
                if($token =~ /:\\/ or $token =~ /\//)
                {
                    $wsHome = $token;
                    last;
                }
            }
            
        }
        else
        {
            #print ERROR "vpd.properties file doesn't exist. Discovery not possible";
        }
        
        #print ERROR "getWSHome Ws Home =$wsHome**\n";
        close WS;
        return $wsHome;
    }    

    sub getBEAHome
    {
        my $bea;
        my $beaHome;
        chomp($os = $^O);
        if (($os ne "MSWin32") && ($os ne "MSWin64")) 
        {
            $bea = $home."/bea/beahomelist";
        }
        else
        {
        }
        if ( -e $bea)
        {

            #print "File exists $bea\n";
            open(BEAH, $bea);
            @rawdat = <BEAH>;
            @temArr = split(/;/,$rawdat[0]);
            my $token;
            foreach $token (@temArr)
            {
                chomp($token);
                my $installDir = getWLInstallDir($token);
                if(-e $installDir."/server/lib/weblogic.jar")
                {
                    $beaHome = $token;
                    last;
                }
            }            
            #print ERROR "BEA Home=$beaHome**";
        }
        else
        {
            #print ERROR "BEA homelist file doesn't. Discovery not possible";
        }
        return $beaHome;
    }

    sub getClasspath
    {
        my $type = @_[0];
        my $libpath = @_[1];
        my $classpath;
	    my $pathSep;
        chomp($os = $^O);
        if (($os ne "MSWin32") && ($os ne "MSWin64")) 
        {
            $pathSep=":";
        }
        else
        {
	        $pathSep=";";
        }        
        if($type eq "weblogic")
        {
            $classpath= $oraHome."/lib/xmlparserv2.jar".$pathSep.$libpath."/weblogic.jar".$pathSep.$oraHome."/sysman/jlib/log4j-core.jar".$pathSep.$oraHome."/jlib/http_client.jar".$pathSep.$oraHome."/sysman/jlib/emagentSDK.jar".$pathSep.$oraHome."/jlib/emConfigInstall.jar";
        }
        else
        {
            my $wasVer = getWASVersion($libpath);
            #print ERROR "wasVer$wasVer\n";
            if($wasVer =~ /^5/)
            {
                $classpath = $libpath."/lib/admin.jar".$pathSep.$libpath."/lib/jmxc.jar".$pathSep.$libpath."/lib/wsexception.jar".$pathSep.
                $libpath."/lib/wasjmx.jar".$pathSep.$libpath."/lib/wlmclient.jar".$pathSep.$libpath."/lib/soap.jar".$pathSep.$libpath."/lib/idl.jar".$pathSep.$libpath."/java/jre/lib/security.jar".$pathSep.$libpath."/java/jre/lib/ext/mail.jar".$pathSep.$libpath."/java/jre/lib/ext/log.jar".$pathSep.$oraHome."/lib/xmlparserv2.jar".$pathSep.$oraHome."/sysman/jlib/log4j-core.jar".$pathSep.$oraHome."/jlib/http_client.jar".$pathSep.$oraHome."/sysman/jlib/emagentSDK.jar".$pathSep.$oraHome."/jlib/emConfigInstall.jar";
            }
            else
            {
                $classpath = $libpath."/lib/admin.jar".$pathSep.
                             $libpath."/lib/management.jar".$pathSep.
                             $libpath."/lib/wsexception.jar".$pathSep.
                             $libpath."/lib/wssec.jar".$pathSep.
                             $libpath."/lib/utils.jar".$pathSep.
                             $libpath."/lib/ras.jar".$pathSep.
                             $libpath."/lib/bootstrap.jar".$pathSep.                             
                             $libpath."/lib/emf.jar".$pathSep.
                             $libpath."/lib/sas.jar".$pathSep.
                             $libpath."/lib/ffdc.jar".$pathSep.
                             $libpath."/lib/soap.jar".$pathSep.
                             $libpath."/lib/wasjmx.jar".$pathSep.
                             $libpath."/lib/wlmclient.jar".$pathSep.
                             $libpath."/lib/j2ee.jar".$pathSep.
                             $libpath."/lib/classloader.jar".$pathSep.
                             $libpath."/lib/wasproduct.jar".$pathSep.
                             $libpath."/lib/runtime.jar".$pathSep.
                             $libpath."/lib/iwsorb.jar".$pathSep.
                             $libpath."/lib/idl.jar".$pathSep.
                             $libpath."/lib/security.jar".$pathSep.
                             $libpath."/java/jre/lib/ibmcertpathprovider.jar".$pathSep.
                             $libpath."/java/jre/lib/ext/ibmjceprovider.jar".$pathSep.
                             $oraHome."/lib/xmlparserv2.jar".$pathSep.
                             $oraHome."/sysman/jlib/log4j-core.jar".$pathSep.
                             $oraHome."/jlib/http_client.jar".$pathSep.
                             $oraHome."/sysman/jlib/emagentSDK.jar".$pathSep.
                             $oraHome."/jlib/emConfigInstall.jar";
            }
        }

        return $classpath;
    }
    
    sub getWLInstallDir
    {
        my $wlHome = @_[0];
        #print ERROR "getWLInstallDir$wlHome\n";
        open(REGISTRY,$wlHome."/registry.xml");
        while ( my $line = <REGISTRY> ) 
        {
            # get the line which has the text "InstallDir"
            if($line =~ m/InstallDir/i)
            {
                @tempArr = split(/=/,$line);
                my $firstInd = index($tempArr[1], "/");
                my $secondInd = index($tempArr[1], "\"",$firstInd);
                $installDir = substr($tempArr[1],$firstInd,$secondInd-1);
                #print ERROR "Weblogic Install Dir=$installDir\n";
                last;
            }
        }
        close(REGISTRY);
        return $installDir;
    }

    sub getWASVersion
    {
        my $wasHome = @_[0];
        my $productFile;
        my $version;
        opendir(DIR,$wasHome."/properties/version");
        while ($file = readdir(DIR) )
        {
            if($file =~ m/product$/)
            {
                $productFile= $file;
                last;
            }
       }
       closedir(DIR);
       open(PF,$wasHome."/properties/version/".$productFile);
       while ( my $line = <PF> ) 
       {
           if($line =~ m/<version>/i)
           {
               my $firstInd = index($line, ">");
               my $secondInd = index($line, "<",$firstInd);
               $version = substr($line,$firstInd+1,$secondInd-($firstInd+1));
               last;
            }
        }
        close(PF);
        return $version;
    }
    
    #close(ERROR);
}



