#!/bin/sh
#
# *************************************************************** 
#  This software and related documentation are provided under a   
#  license agreement containing restrictions on use and           
#  disclosure and are protected by intellectual property          
#  laws. Except as expressly permitted in your license agreement  
#  or allowed by law, you may not use, copy, reproduce,           
#  translate, broadcast, modify, license, transmit, distribute,   
#  exhibit, perform, publish or display any part, in any form or  
#  by any means. Reverse engineering, disassembly, or             
#  decompilation of this software, unless required by law for     
#  interoperability, is prohibited.                               
#  The information contained herein is subject to change without  
#  notice and is not warranted to be error-free. If you find any  
#  errors, please report them to us in writing.                   
#                                                                 
# Copyright (c) 1988, 2010, Oracle and/or its affiliates. All rights reserved. 
# *************************************************************** 

main()
{

# Initialize the path of non-shell built in functions
# dirname,awk and tr

# Init dirname command
if [ -f /bin/dirname ]; then
	DIRNAME="/bin/dirname"
elif [ -f /usr/bin/dirname ]; then
	DIRNAME="/usr/bin/dirname"
else
	DIRNAME="dirname"
fi

# Init awk. some Solaris shells have nawk 
if [ -f /bin/awk ]; then
	AWK=/bin/awk
elif [ -f /usr/bin/awk ]; then
	AWK=/usr/bin/awk
elif [ -f /bin/nawk ]; then
	AWK=/bin/nawk
elif [ -f /usr/bin/nawk ]; then
	AWK=/usr/bin/nawk
else
	AWK=awk
fi

# Find the path to the current shell 
SRC_DIR=`$DIRNAME $0`

CUR_DIR=`pwd`
cd $SRC_DIR
CLASSPATH=../lib/psft_ccr.jar:../lib/psft_queries.jar
CCR_HOME=./../../..
JAVA_PATH="${CCR_HOME}/../jre/bin/java"
jverCheck="false"

# Verify java exists in PS_HOME
# When java does not exist in PS_HOME( This is very unlikey)
# Check for JAVA_HOME set

if [ ! -f "${JAVA_PATH}" ]; then
	if [ "${JAVA_HOME}" = "" ] ; then
		echo "ERROR: The PS_HOME \"${CCR_HOME}\" does not contain java."
		echo "ERROR: Redefine JAVA_HOME to refer to a JRE 1.6.0 or greater.."
		return;
	elif [ -f "${JAVA_HOME}"/bin/java ] ; then
		JAVA_PATH="${JAVA_HOME}/bin/java"
        else
		echo "ERROR: Invalid \"${JAVA_HOME}\" ."
		return;
	fi
fi
# Check for Major mand Maintenance version
# Requires java version "1.6.0" or above

checkVersion;
if [ "${jverCheck}" = "true" ]; then
	"${JAVA_PATH}" -Djava.util.logging.config.file=psft_logging.properties -cp "${CLASSPATH}" com.peoplesoft.pt.ccr.qry.pub.client.ConsolePublisher -CCRHOME $CCR_HOME $@
else
	echo "ERROR: Redefine JAVA_HOME to refer to a JRE 1.6.0 or greater.."
fi
cd $CUR_DIR
}

# Verify the provided vm is JRE 1.6.0 or later
checkVersion()
{	# java version "1.6.0"
	# Parse and take version part "1.6.0"
	# Remove quotes
	# Split version by "." 
	# Take major and Maintenance part ie 1.6
	eval `$JAVA_PATH -version 2>&1 | $AWK '$3 ~ /"[0-9]\.[0-9]\.[0-9][^"]*"$/{
	gsub ("[\"]", "", $3)
	split ($3, ver, ".")
	printf "curMaj=%s\ncurMain=%s\n",ver[1],ver[2]
	}'`
	# Required version 1.6
	reqMaj=1
	reqMain=6
	# In case the java -version did not return
	if [ "$curMaj" = "" ]; then
		jverCheck="false"
		return;
	fi
	if [ $curMaj -ge $reqMaj -a $curMain -ge $reqMain ]; then
		jverCheck="true"
	else
		jverCheck="false"
	fi
}

main "$@"
