#
# $Header: emagent/sysman/admin/scripts/OH_ConfigClasses.pm /main/8 2012/05/30 23:07:19 irraju Exp $
#
# OH_ConfigClasses.pm
#
# Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      OH_ConfigClasses.pm - <Package to collect all the metrics related to OUI homes>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#        <>
#
#    MODIFIED   (MM/DD/YY)
#    irraju      05/15/12 - adding primary columsn to each metric to
#                           remove duplicates across plugins
#    hmodawel    04/05/11 - fix columns
#    ravpatel    03/31/11 - Adding HOME_RW_STATUS to HomeInfo Metric
#    chkaushi    03/10/11 - Adding Bug Description
#    ravpatel    12/29/10 - Adding PATCH_TYPE to patch metric
#    schaluva    07/22/10 - Adding User and Group Info to HomeInfo
#    irraju      05/25/10 - adding error and warning class
#    irraju      05/17/10 - Class definitions of all the classs used
#                           Oracle home configuration collections.
#    irraju      05/17/10 - Creation
# 

## USE DIRECTIVES
use strict;
use warnings;
# Various classes used in inventory collection

## CLASSES
{
package ComponentClass;
use fields qw(_NAME _VER _CURR_VER _TIMESTAMP 
               _IS_TOP_LEVEL _EXT_NAME _DESC _LANGS _INST_LOC
                _INST_VER _DEINST_VER _INST_TYPE_LIST _DEP_LIST _CLONABLE);
my @cols = qw(_NAME _VER _CURR_VER _TIMESTAMP _IS_TOP_LEVEL
               _EXT_NAME _DESC _LANGS _INST_LOC _INST_VER
                _DEINST_VER);
my @primaryCols = qw(_NAME _VER _CURR_VER);#uniquely identifies the component
sub new
{
  my $class = shift;
  my $self = fields::new(ref($class)||$class);
  return $self;
}
#Get all columns
sub getColumns
{
    return @cols;
}

#Get Primary Columns 

sub getPrimaryColumns
{
  return @primaryCols;
}


}

{
package CompDepClass;
use fields qw( _DEP_NAME _DEP_VER _REF_NAME _REF_VER _DEP_HOME_GUID);
my @cols = qw( _DEP_NAME _DEP_VER _REF_NAME _REF_VER _DEP_HOME_GUID);
my @primaryCols = qw( _DEP_NAME _DEP_VER _REF_NAME _REF_VER);
sub new
{
  my $class = shift;
  my $self = fields::new(ref($class)||$class);
  return $self;
}
sub getColumns
{
    return @cols;
}

#Get Primary Columns

sub getPrimaryColumns
{
  return @primaryCols;
}

}

{

package CompInstTypeClass;
use fields qw(_COMP_NAME _COMP_VER _NAME_ID _NAME _DESC_ID);
my @cols = qw(_COMP_NAME _COMP_VER _NAME_ID _NAME _DESC_ID);
my @primaryCols = qw(_COMP_NAME _COMP_VER _NAME_ID);
sub new
{
  my $class = shift;
  my $self = fields::new(ref($class)||$class);
  return $self;
}
sub getColumns
{
    return @cols;
}

#Get Primary Columns

sub getPrimaryColumns
{
  return @primaryCols;
}

}

{
package PatchClass;
use fields qw( _PATCH_ID _UPI _LANG _TIMESTAMP  _ROLLBACK _IS_PSU 
                 _PROFILE _PATCH_TYPE _DESC _XML_INV_LOC 
                 _ACT_INST_VER _BUG_LIST _FILE_LIST 
                 _REF_LIST );
my @cols = qw(_PATCH_ID _UPI _LANG _TIMESTAMP
                _ROLLBACK _IS_PSU _PROFILE _PATCH_TYPE _DESC
                 _XML_INV_LOC _ACT_INST_VER );
my @primaryCols = qw(_PATCH_ID _UPI _LANG );
sub new
{
  my $class = shift;
  my $self = fields::new(ref($class)||$class);
  return $self;
}
sub getColumns
{
    return @cols;
}

#Get Primary Columns

sub getPrimaryColumns
{
  return @primaryCols;
}
}

{
package PatchCompClass;
use fields qw(_PATCH_ID _UPI _LANG _NAME _VER _FROM_VER _TO_VER );
my @cols = qw(_PATCH_ID _UPI _LANG _NAME _VER _FROM_VER _TO_VER );
my @primaryCols = qw(_PATCH_ID _UPI _LANG _NAME _VER);
sub new
{
  my $class = shift;
  my $self = fields::new(ref($class)||$class);
  return $self;
}
sub getColumns
{
    return @cols;
}

#Get Primary Columns

sub getPrimaryColumns
{
  return @primaryCols;
}
}

{
package PatchBugClass;
use fields qw(_PATCH_ID _UPI _LANG _BUGS _DESC);
my @cols = qw(_PATCH_ID _UPI _LANG _BUGS _DESC);
my @primaryCols = qw(_PATCH_ID _UPI _LANG _BUGS);
sub new
{
  my $class = shift;
  my $self = fields::new(ref($class)||$class);
  return $self;
}
sub getColumns
{
    return @cols;
}

#Get Primary Columns

sub getPrimaryColumns
{
  return @primaryCols;
}
}


{
package PatchFileClass;
use fields qw(_PATCH_ID _UPI _LANG _FILE_NAME _COMP_NAME _COMP_VER );
my @cols = qw(_PATCH_ID _UPI _LANG _FILE_NAME _COMP_NAME _COMP_VER );
my @primaryCols = qw(_PATCH_ID _UPI _LANG _FILE_NAME _COMP_NAME _COMP_VER);
sub new
{
  my $class = shift;
  my $self = fields::new(ref($class)||$class);
  return $self;
}
sub getColumns
{
    return @cols;
}

#Get Primary Columns

sub getPrimaryColumns
{
  return @primaryCols;
}
}

{
package VerPatchClass;
use fields qw(_NAME _VER _BASE_VER _PS_NAME _PS_VER _TIMESTAMP _EXT_NAME 
              _DESC _LANGS _INST_LOC _ACT_INST_VER _DEINST_VER _INST_TYPE_LIST);
my @cols = qw(_NAME _VER _BASE_VER _PS_NAME _PS_VER _TIMESTAMP _EXT_NAME
              _DESC _LANGS _INST_LOC _ACT_INST_VER _DEINST_VER);
my @primaryCols = qw(_NAME _VER);
sub new
{
  my $class = shift;
  my $self = fields::new(ref($class)||$class);
  return $self;
}
sub getColumns
{
    return @cols;
}
#Get Primary Columns

sub getPrimaryColumns
{
  return @primaryCols;
}
}

{
package PatchsetClass;
use fields qw(_NAME _VER _TIMESTAMP _EXT_NAME _DESC _INV_LOC _ACT_INST_VER _DEINST_VER _PS_PATCH_LIST);
my @cols = qw(_NAME _VER _TIMESTAMP _EXT_NAME _DESC _INV_LOC _ACT_INST_VER _DEINST_VER);
my @primaryCols = qw(_NAME _VER);
sub new
{
  my $class = shift;
  my $self = fields::new(ref($class)||$class);
  return $self;
}
sub getColumns
{
    return @cols;
}
#Get Primary Columns

sub getPrimaryColumns
{
  return @primaryCols;
}
}

{

package HomeInfoClass;
use fields qw(_HOME_LOC _NAME _HOME_GUID _TYPE _INVENTORY _CLONABLE _CRS _ARU_ID _OUI_PLATFORM_ID _HOME_SIZE _RW_STATUS _ORACLE_BASE _OH_OWNER_ID _OH_OWNER _OH_GROUP_ID  _OH_GROUP _OH_OWNER_GROUPS_ID  _OH_OWNER_GROUPS);
my @cols = qw(_HOME_LOC _NAME _HOME_GUID _TYPE _INVENTORY _CLONABLE _CRS _ARU_ID _OUI_PLATFORM_ID _HOME_SIZE _RW_STATUS _ORACLE_BASE _OH_OWNER_ID _OH_OWNER _OH_GROUP_ID  _OH_GROUP _OH_OWNER_GROUPS_ID  _OH_OWNER_GROUPS);
my @primaryCols = @cols;
sub new
{
 my $class = shift;
 my $self = fields::new(ref($class)||$class);
 return $self;
}
sub getColumns
{
    return @cols;
}
#Get Primary Columns

sub getPrimaryColumns
{
  return @primaryCols;
}
}

{
package DepHomeClass;
use fields qw(_LOC);
my  @cols = qw(_LOC);
my @primaryCols = @cols;
sub new
{
  my $class = shift;
  my $self = fields::new(ref($class)||$class);
  return $self;
}
sub getColumns
{
    return @cols;
}
#Get Primary Columns

sub getPrimaryColumns
{
  return @primaryCols;
}
}


{
package CRSNodesClass;
use fields qw(_NAME);
my @cols = qw(_NAME);
my @primaryCols = @cols; 
sub new
{
  my $class = shift;
  my $self = fields::new(ref($class)||$class);
  return $self;
}
sub getColumns
{
    return @cols;
}
#Get Primary Columns

sub getPrimaryColumns
{
  return @primaryCols;
}
}

{
package PropertyClass;
use fields qw(_NAME _VAL);
my @cols= qw(_NAME _VAL);
my @primaryCols = @cols;
sub new
{
  my $class = shift;
  my $self = fields::new(ref($class)||$class);
  return $self;
}
sub getColumns
{
    return @cols;
}
#Get Primary Columns

sub getPrimaryColumns
{
  return @primaryCols;
}
}
#******* OH CONFIG METRIC CLASS **********************************************
#
#
package OHConfigMetric;
use fields qw (ROWS STATUS);
sub new
{
  my $class = shift;
  my $self = fields::new(ref($class)||$class);
  return $self;
}
sub getRows
{
 my $self = shift;
 return $self->{ROWS};

} 

1;
