#
# $Header: emagent/sysman/admin/scripts/OH_Error.pm /main/3 2011/01/04 02:27:43 ravpatel Exp $
#
# OH_Error.pm
#
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      OH_Error.pm - <Package to collect all the metrics related to OUI homes>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#        <>
#
#    MODIFIED   (MM/DD/YY)
#    irraju      05/17/10 - Package to define all the methods to  
#                             define all error constants.                           .
#    irraju      05/17/10 - Creation
#
use strict;
use warnings;
use Fcntl ':mode';

package OH_Error;

use Exporter;
use base 'Exporter';
our @EXPORT = qw(
         %errorValue
         %errorMessage
         );


use constant {
   	SUCCESS             =>  0,
   	FILE_NOT_FOUND      =>  1,
   	FILE_PERM_DENIED    =>  2,
   	FILE_CANNOT_OPEN    =>  3,
   	XML_PARSE_ERR       =>  4,
   	FAILED_TO_LOAD_MOD  =>  5,
   	INVALID_ARGUMENTS   =>  6,
        MAND_ARG_MISSING    =>  7,
	UNKNOWN_ENCODING_XML=>  8,
        INVALID_HOME_TYPE   =>  9,
        INVALID_METRIC_NAME =>  10,
        RETURNED_NULL       => 11
	};


our %errorMessage =
	(
	  0 	=> "Success",
          1     => "Path does not exist :",
          2     => "Read permission denied :",
          3     => "Cannot open :",
          4     => "XML file corrupt, cannot parse :",
          5     => "Failed to load module for parsing :",
          6     => "Invalid arguments :",
          7     => "Missing one or more arguments :",
          8     => "Unknown XML encoding :",
          9     => "Invalid home type :",
         10     => "Invalid metric name :",
         11     => "Returned Null:"
       
	);

sub getErrorMessage
{
  my $err_code = shift;
  my $arg = shift;
  return $errorMessage{$err_code}.$arg;
}

package Error;
use fields qw(CODE ARG);
sub new
{
  my $class = shift;
  my $self = fields::new(ref($class)||$class);
  return $self;
}

sub setError
{
  my $self = shift;
  my %args = @_;
  $self->{CODE} = $args{CODE}; 
  $self->{ARG}  = $args{ARG};
}

sub getErrorString
{
 my $self = shift;
 return $OH_Error::errorMessage{$self->{CODE}} . $self->{ARG};
}

package Warn;
use fields qw (WARN_COUNT WARNINGS);
sub new
{
 my $class = shift;
 my $self = fields::new(ref($class)||$class);
 $self->{WARN_COUNT} = 0;
 return $self;
}

sub addWarning
{
 my $self = shift;
 $self->{WARNINGS}->{$self->{WARN_COUNT}} = shift;
 $self->{WARN_COUNT} = $self->{WARN_COUNT}+1;

}

sub getWarnings
{
 my $self = shift;
 return $self->{WARNINGS};
}

sub reset
{
  my $self = shift;
  $self->{WARN_COUNT} = 0;
  $self->{WARNINGS} = {};
}

1;
