#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/OH_InventoryOrCompositeHome.pm /main/4 2011/12/16 04:06:52 hmodawel Exp $
#
# OH_InventoryOrCompositeHome.pm
# 
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      OH_InventoryOrCompositeHome.pm - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hmodawel    12/16/11 - remove warning
#    hmodawel    03/27/11 - fix issues
#    ravpatel    01/21/11 - CCR Convergence
#    ravpatel    08/25/10 - Class to hold Composite Home or Inventory
#                           Information
#    ravpatel    08/25/10 - Creation
# 

package OH_InventoryOrCompositeHome;

use strict;
use warnings;
no warnings qw(redefine);
use Carp;
use File::Spec;
#use OH_ParseCompsXml;
#use OH_OUI;
#use OH_ConfigClasses;
use OH_ParseInvXml;
#use OH_ParseOHPropXml;
#use OH_ParseCloneXml;
use OH_Utilities;
use OH_Error;

use emdcommon_ocm;

# Dont use a constant, as OH_ParseInvXML uses this package and vice versa, redefinition warnings.
#use constant INV_XML   => File::Spec->catfile("ContentsXML","inventory.xml");


## FIELDS
use fields qw (  LOC
                 ROOT_INV
                 WARNINGS
                 ERROR
                 HOMES
                 COMPOSITE_HOMES
             );


sub new
{
  my ($class, %vals) = @_;
  my $self = fields::new(ref($class)||$class);
  $self->{LOC} = $vals{LOC}; #absolute location of the inventory / Composite Home
  $self->{WARNINGS} = $vals{WARNINGS};
  $self->{ROOT_INV} = $vals{ROOT_INV} ? $vals{ROOT_INV} : $self;

  if($vals{LOC})
  {
    my $failed = OH_Utilities::checkPermissions($vals{LOC});
    if($failed)
    {
      $self->{WARNINGS}->addWarning(OH_Error::getErrorMessage($failed, $vals{LOC}));
      my $error = new Error();
      $error->setError(CODE => $failed, ARG => $vals{LOC});
      $self->{ERROR} = $error;
    }
    else
    {
      my $inv_xml = File::Spec->catfile("ContentsXML","inventory.xml");
      emdcommon_ocm::EMD_PERL_DEBUG("Started collection of inventory ".$self->{LOC});
      my $invXmlLoc = File::Spec->catfile($self->{LOC}, $inv_xml);

      unless (-e $invXmlLoc) # May be a Composite Home
      {
        $invXmlLoc = File::Spec->catfile($self->{LOC}, "inventory", $inv_xml);
      } 

      
      my $invXmlObj = new OH_ParseInvXml(INV_LOC  => $self->{LOC},
                                         XML_FILE => $invXmlLoc,
                                         WARNINGS => $self->{WARNINGS});

      $self->{HOMES} = $invXmlObj->getData('HOMES');

      my $compositeHomesRef = $invXmlObj->getData('COMPOSITE_HOMES');
      
      if (defined $compositeHomesRef)
      {
        foreach my $compHomeLoc (keys %$compositeHomesRef)
        {
          my $compHomeInfo = $compositeHomesRef->{$compHomeLoc};
          OH_Utilities::appendHash($self->{HOMES}, $compHomeInfo->getHomes());
          OH_Utilities::appendHash($compositeHomesRef, $compHomeInfo->getCompositeHomes());
        }
        $self->{COMPOSITE_HOMES} = $compositeHomesRef;
      }

      my $error = $invXmlObj->getError();
      if($error)
      {
        $self->{ERROR} = $error;
      }
      emdcommon_ocm::EMD_PERL_DEBUG("Finished collection of inventory ".$self->{LOC});
    }
  }
  else
  {
    my $error = new Error();
    $error->setError(CODE => OH_Error::MAND_ARG_MISSING, ARG =>"OH_InventoryOrCompositeHome::new");
    $self->{ERROR} = $error;
    emdcommon_ocm::EMD_PERL_ERROR("Insufficient Arguments in call to $class"."::new");
  }
  return $self;
}

sub getError
{
  my $self = shift;

  return (exists $self->{ERROR}) ? $self->{ERROR} : undef;
}

sub getHomeInvInfo
{
  my $self = shift;
  my $homeLoc = shift;

  ## -- check if this home is present in the list of homes or not
  if(defined($homeLoc))
  {
    $homeLoc = removeTrailingSlash($homeLoc);

    if(exists $self->{HOMES}->{$homeLoc})
    {
      emdcommon_ocm::EMD_PERL_DEBUG("Found $homeLoc in this inventory");
      return $self->{HOMES}->{$homeLoc};
    }
    else
    {
      # tell that this home deosn't exist
      my $msg = "Oracle Home $homeLoc not found in inventory ".$self->{LOC};
      emdcommon_ocm::EMD_PERL_WARN($msg);
      return undef;
    }
  }
}

sub getHomes
{
  my $self = shift;

  return $self->{HOMES};
}

sub getCompositeHomes
{
  my $self = shift;
  return $self->{COMPOSITE_HOMES};
}

1;

