#
# $Header: emagent/sysman/admin/scripts/OH_ParseCloneXml.pm /main/3 2011/04/20 03:41:24 hmodawel Exp $
#
# OH_ParseCloneXml.pm
#
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      OH_ParseCloneXml.pm - <Package to collect all the metrics related to OUI homes>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#        <>
#
#    MODIFIED   (MM/DD/YY)
#    sanjkuma    02/14/11 - Update to correct package for encTable
#    ravpatel    01/21/11 - CCR Convergence
#    irraju      05/17/10 - Package to define all the methods to extract 
#                             information from Clone xml.                           
#    irraju      05/17/10 - Creation
#
package OH_ParseCloneXml;

## USE DECLARATIONS
use strict;
use warnings;
use XML::Parser;
use OH_Error;
use File::Spec;
use OH_Utilities qw(@encTable);
use fields qw(XML_FILE CLONE_PROPS ERROR WARNINGS);

use emdcommon_ocm;

## GLOBAL VARIABLES

my $propFound = 0;
my %cloneProps = ();

## NEW ###
sub new
{
  my ($class,%vals) = @_;
  my $self = fields::new(ref($class)||$class);
  $self->{XML_FILE}= $vals{XML_FILE};
  init();
  return $self;
}

#******* collectCloneProperties************************************************

sub collectCloneProperties
{
  my  $self = shift;
  my %args  = @_;
  $self->{ERROR}   = $args{ERROR};
  $self->{WARNINGS}= $args{WARNINGS};
  my $cloneFile =  $self->{XML_FILE};

  {
    my $p2 = new XML::Parser(ErrorContext => 2);
    emdcommon_ocm::EMD_PERL_DEBUG("Starting parsing of $self->{XML_FILE}");
    $p2->setHandlers(Start => \&startTagHandler,
                       End => \&endTagHandler);

    eval {$p2->parsefile($self->{XML_FILE})};

    if ($@)
    {
      emdcommon_ocm::EMD_PERL_DEBUG("Failed to parse using default encoding:$@");
      foreach $_ (@OH_Utilities::encTable)
      {
        init();
        emdcommon_ocm::EMD_PERL_DEBUG("Trying with $_ eincoding..");
        eval '$p2->parsefile($self->{XML_FILE}, ProtocolEncoding => $_)';
        
        if ($@)
        {
          emdcommon_ocm::EMD_PERL_DEBUG("Failed again :$@");
        }
        else
        {
          #SUCCESSFUL in parsing
          last;
        }
      }
    }
    if ($@)
    {
      $self->{ERROR}->setError(CODE=>OH_Error::XML_PARSE_ERR,
                       ARG => $self->{XML_FILE});
      return OH_Error::XML_PARSE_ERR;
    }
  }
  $self->{CLONE_PROPS} = \%cloneProps;
  return OH_Error::SUCCESS;
 }

#**** sub getCloneProperties **************************************************
# returns the clone properties collected
# 
sub getCloneProperties
{
  my $self = shift;
  return $self->{CLONE_PROPS};
}



sub startTagHandler
{
  my ($p , $el) = (shift, shift);
  #print " __ $el __ \n ";
  if($el eq "VAR")
   {
    my %atts = @_;
    if($atts{COMPUTE_AT_CLONE} eq "T")
    {
      # we need to collect this property
      my ($name, $val) = ($atts{NAME},$atts{VAL});
      if($name && $val)
      {
       my $propRef = {};
       $cloneProps{$propFound++} = bless ($propRef,"PropertyClass");
       if(exists($propRef->{$name}))
       {
        my $msg = "Duplicate clone property found for $name:$propRef->{$name}, New Value $val";
        emdcommon_ocm::EMD_PERL_WARN($msg);
       }
       else
       {
        $propRef->{_NAME} = $name;
        $propRef->{_VAL}  = $val;
       }
             
      }
      
    }
   }
}

sub endTagHandler
{
}

sub init()
{
  %cloneProps = ();
  $propFound = 0;
}  
    
1;
