#
# $Header: emagent/sysman/admin/scripts/OH_ParseCompsXml.pm /main/6 2011/12/16 04:06:52 hmodawel Exp $
#
# OH_ParseCompsXml.pm
#
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      OH_ParseCompsXml.pm - <Package to collect all the metrics related to OUI homes>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#        <OUI API interanll calles these methods to collect the metrics>
#
#    MODIFIED   (MM/DD/YY)
#    hmodawel    12/13/11 - set defaults to avoid warnings
#    hmodawel    04/26/11 - handle different targets in make file
#    hmodawel    03/28/11 - fix issues
#    sanjkuma    01/24/11 - bug 10376956
#    chkaushi    03/10/11 - Adding Bug Description
#    hmodawel    06/22/10 - Bug is number in repos, not string
#    irraju      06/16/10 - Fixing Is Clonable
#    irraju      05/17/10 - Package to define all the methods to extract 
#                             information from comps xml.                    
#    irraju      05/17/10 - Creation
#
package OH_ParseCompsXml;

## USE DIRECTIVES
use strict;
use warnings;
require Exporter;
use XML::Parser;
use OH_Error;
use File::Spec;
use OH_Utilities;
use OH_ConfigClasses;
use OH_ParseOneoffActions;
use OH_Date;

use emdcommon_ocm;

use fields qw( XML_FILE HOME_LOC WARNINGS IS_CLONABLE);
#TODO
use vars qw ($warnings $homeLocation);
## CONSTANTS



## FUNCTIONS

# -- variable required only for parsing
  # -- Hashes to hold data
  my %comps;
  my %instTypes;
  my %patches;
  my %patchSets;
  my %verPatches;

  # -- count the number of each entry
  my $Cfound    = 0;	#component found
  my $CDfound   = 0;	# component dependency found
  my $PCfound   = 0;	# Patched component found
  my $PBfound   = 0;	# Patched bug found
  my $PFfound   = 0;	# patched file found
  my $Pfound    = 0;	# oneoff PATCH found
  my $PSfound   = 0;	# patchset found
  my $VPfound   = 0;	# versionpatch found
  my $PPDfound  = 0;  #patchset version patch dependency found
  my $ITinPfound   = 0;  # install type found in VerPatch
  my $ITinCfound   = 0;  # install type found in Component
  # -- place of control
  my $inComp     = "FALSE";
  my $inPatch    = "FALSE";
  my $inPatchSet = "FALSE";
  my $inVerPatch = "FALSE";
  my $inExtName  = "FALSE";
  my $inDesc     = "FALSE";
  my $inDepList  = "FALSE";
  my $inRefList  = "FALSE";
  my $inBugList  = "FALSE";
  my $inFileList = "FLASE";
  my $inBug      = "FALSE";
  my $inOneOff   = "FALSE";
  my $inTopLevel = "FALSE";
  my $skipGroup  = "FALSE";


 # INITIALIZE THE GLOBAL VARIABLES
 sub initGlobals_ParseCompXml
 {
  %comps = ();
  $Cfound   = 0;
  $CDfound   = 0;
  %instTypes = ();
  $ITinPfound = 0;
  $ITinCfound = 0;
  %patches = ();
  $Pfound   = 0;
  $PBfound = 0;
  $PCfound =0;
  %patchSets = ();
  $PSfound = 0;
  %verPatches =();
  $VPfound = 0;
  $PPDfound = 0; #patchset patch dependency
 }

## PARSE AND EXPORTED METHODS
sub new
{
  my ($class, %args) = @_;
  my $self           = fields::new(ref($class)||$class);
  $self->{XML_FILE}  = $args{XML_FILE};
  $self->{HOME_LOC}  = $args{HOME_LOC};
  $self->{WARNINGS}  = $args{WARNINGS};
  init();#TODO
  return $self;
}

sub collectInventory
{
  # -- get the xml file from object
  my $self      =  shift; 
  my $warnings  =  shift; 
  my $error     =  shift; 

  emdcommon_ocm::EMD_PERL_DEBUG("Started parsing $self->{XML_FILE}");
  {
    ## -- Create a parser object
    my $p2 = new XML::Parser(ErrorContext => 2);
    ## -- Set the TAG handlers
    $p2->setHandlers(Start => \&startTagHandler,
                     End   => \&endTagHandler,
                     Char  => \&charTagHandler);
    ## -- Parse the comps.xml file
    eval {$p2->parsefile($self->{XML_FILE})};
    if ($@)
    {
      emdcommon_ocm::EMD_PERL_DEBUG("Failed:$@. Trying with the other encdoing");
      foreach $_ (@OH_Utilities::encTable)
      {
        # -- init the hashes
        &initGlobals_ParseCompXml();
        emdcommon_ocm::EMD_PERL_DEBUG(" Trying with $_ encoding");
        eval {$p2->parsefile($self->{XML_FILE}, ProtocolEncoding => $_)};
        if ($@)
        {
          emdcommon_ocm::EMD_PERL_DEBUG("Failed again: $@");
        }
        else
        {
          last;#SUCCESS
        }
      }
    }
    if ($@)
    {
     $error->setError( CODE  => OH_Error::XML_PARSE_ERR,
                       ARG   => "$self->{XML_FILE} :$@");
      return OH_Error::XML_PARSE_ERR;
    }

    # Create a hash to store reference hashes and the keys to be deleted
    my  %delHash = ();
    # -- validate components,patchsets and version patches for possible errors and duplicates
    $self->_LogDuplicates($warnings, \%delHash);
    $self->_fixVersions($warnings, \%delHash);
    $self->_cleanupHashes(\%delHash);
    
    # set the is clonable info
    # find if this home is clonable or not
    $self->{IS_CLONABLE} = getIsClonable();#TODO why package variable?
  }
  emdcommon_ocm::EMD_PERL_DEBUG("Finished parsing $self->{XML_FILE}");
  return OH_Error::SUCCESS;# PARSING SUCCESSFUL 
}


# This is to 
#        clean up duplicate components
#        clean up duplicate Versioned Patches
#        clean up PATCHSETS which were not removed when new one was applied
#        clean up VERSIONED PATCHES in the removed PATCHSETS
#        clean up duplicate oneoffs and PSUs
sub _cleanupHashes
{
  my $self = shift;
  my $delHashRef = shift;
  foreach my $idx (sort  {$a<=>$b} keys %$delHashRef)
  {
    my $hashRef = $delHashRef->{$idx}->{REF_HASH};
    my $key = $delHashRef->{$idx}->{DEL_KEY};

    delete $hashRef->{$key};
  }
}


sub _LogDuplicates
{
  my $self = shift;
  my ($warnings, $delHashRef) = @_;
  my $delHashCount = scalar keys %$delHashRef;
  my $msg;

  # Check for duplicates in comps
  # Log and remove them if found
  foreach my $compidx (sort {$a<=>$b} keys %comps)
  {
    my $loopctrl = $compidx + 1;
    while  ($loopctrl < scalar keys %comps)
    {
      if (($comps{$compidx}->{_NAME} eq $comps{$loopctrl}->{_NAME}) &&
           ($comps{$compidx}->{_VER}  eq $comps{$loopctrl}->{_VER}) )
      {
         #duplicate found
         $msg = "Duplicate component found $comps{$loopctrl}->{_NAME} $comps{$loopctrl}->{_VER}";
         emdcommon_ocm::EMD_PERL_WARN($msg);
         #dont send it to OMS, some customers are picky about this
         $delHashRef->{$delHashCount}->{REF_HASH} = \%comps;
         $delHashRef->{$delHashCount}->{DEL_KEY} = $loopctrl; 
         $delHashCount++;
      }
      $loopctrl++;
    }
  }
  # dont clean up anything now

  # Check for duplicates in VerPatches
  # Log and remove them if found
  foreach my $verpatch (sort {$a<=>$b} keys %verPatches)
  {
    my $loopctrl = $verpatch + 1;
    while  ($loopctrl < scalar keys %verPatches)
    {
      if (($verPatches{$verpatch}->{_NAME} eq $verPatches{$loopctrl}->{_NAME}) &&
          ($verPatches{$verpatch}->{_VER}  eq $verPatches{$loopctrl}->{_VER} ))
      {
         #duplicate found
         $msg = "Duplicate Versioned Patch found $verPatches{$loopctrl}->{_NAME} $verPatches{$loopctrl}->{_VER}";     
         emdcommon_ocm::EMD_PERL_WARN($msg);
         #dont send it to OMS, some customers are picky about this
         $delHashRef->{$delHashCount}->{REF_HASH} = \%verPatches;
         $delHashRef->{$delHashCount}->{DEL_KEY} = $loopctrl;
         $delHashCount++;
      }
      $loopctrl++;
    }
  } 
  # dont clean up anything now

  # Store primary key defaults and check for duplicates in oneoffs
  # ideally the defaults should have been in place wheninfo was collected..
  # Since we are anyways going through each oneoff, lets do it here...
  foreach my $patchidx (sort {$a<=>$b} keys %patches)
  {
     emdcommon_ocm::EMD_PERL_DEBUG("READING UPI from Patch inventory file");
     my $patchConfigFolder = File::Spec->catfile($self->{HOME_LOC},"inventory",$patches{$patchidx}->{_XML_INV_LOC},"etc","config");
     $self->_fetchUPI($patchConfigFolder, $patchidx); 

    # put defaults for PKs
    if ( (not defined $patches{$patchidx}->{_UPI}) ||
           ($patches{$patchidx}->{_UPI} eq '') )
    {
        $patches{$patchidx}->{_UPI} = 'N/A';
    }
    if ( (not defined $patches{$patchidx}->{_LANG}) ||
           ($patches{$patchidx}->{_LANG} eq '') )
    {
        $patches{$patchidx}->{_LANG} = 'en';
    }
    $patches{$patchidx}->{_ROLLBACK} =  ($patches{$patchidx}->{_ROLLBACK} eq 'T') ? 'T' : 'F';

    my $loopctrl = $patchidx + 1;
    while  ($loopctrl < scalar keys %patches)
    {
      # initialize keys for comparison
      if ( (not defined $patches{$loopctrl}->{_UPI}) ||
           ($patches{$loopctrl}->{_UPI} eq '') )
      {
         $patches{$loopctrl}->{_UPI} = 'N/A';
      }
      if ( (not defined $patches{$loopctrl}->{_LANG}) ||
           ($patches{$loopctrl}->{_LANG} eq '') )
      {
         $patches{$loopctrl}->{_LANG} = 'en';
      }
      $patches{$loopctrl}->{_ROLLBACK} =  ($patches{$loopctrl}->{_ROLLBACK} eq 'T') ? 'T' : 'F';

      if ( ($patches{$patchidx}->{_PATCH_ID} eq $patches{$loopctrl}->{_PATCH_ID}) &&
           ($patches{$patchidx}->{_UPI} eq $patches{$loopctrl}->{_UPI}) &&
           ($patches{$patchidx}->{_LANG} eq $patches{$loopctrl}->{_LANG}) )
      {
        #duplicate found
         $msg = "Duplicate Oneoff found $patches{$loopctrl}->{_PATCH_ID} $patches{$loopctrl}->{_UPI} $patches{$loopctrl}->{_LANG}";
        #dont send it to OMS, some customers are picky about this
         $delHashRef->{$delHashCount}->{REF_HASH} = \%patches;
         $delHashRef->{$delHashCount}->{DEL_KEY} = $loopctrl;
         $delHashCount++;
      }
      $loopctrl++;
    }
  }
}

sub _fixVersions
{
  my $self = shift;
  my ($warnings, $delHashRef) = @_;
  my $delHashCount = scalar keys %$delHashRef;

  # 1. If two or more Patchset exist with same name, different version
  # then pick the latest and reject the older ones
  my @delIdx = ();
  foreach my $patchidx (sort {$a<=>$b} keys %patchSets)
  {
      my $loopctrl = $patchidx + 1;
      while ($loopctrl < scalar keys %patchSets)
      {
        if ($patchSets{$patchidx}->{_NAME} eq $patchSets{$loopctrl}->{_NAME})
        {
          if($patchSets{$patchidx}->{_VER} lt $patchSets{$loopctrl}->{_VER})
          {
            #mark the earlier one for deletion and log the msg
            # dont delete it now as loop is running over it
            my $msg = "Two Patchsets exist with same name $patchSets{$patchidx}->{_NAME} but with different versions, $patchSets{$patchidx}->{_VER}, $patchSets{$loopctrl}->{_VER}";
            emdcommon_ocm::EMD_PERL_WARN($msg); 
            # dont send the msg to OMS as some customers are picky about it
            $delHashRef->{$delHashCount}->{REF_HASH} = \%patchSets;
            $delHashRef->{$delHashCount}->{DEL_KEY} = $patchidx;
            $delHashCount++;
            
            #also mark the Version Patches in that Patchset to be deleted
            my $PSPRef = $patchSets{$patchidx}->{_PS_PATCH_LIST};
            foreach my $PSPidx (sort {$a<=>$b} keys %{$PSPRef})
            {
               foreach my $verpidx (sort  {$a<=>$b} keys %verPatches)
               {
                  if (($verPatches{$verpidx}->{_NAME} eq $PSPRef->{$PSPidx}->{_NAME}) &&
                     ($verPatches{$verpidx}->{_VER}  eq $PSPRef->{$PSPidx}->{_VER} ))
                  {
                     $delHashRef->{$delHashCount}->{REF_HASH} = \%verPatches;
                     $delHashRef->{$delHashCount}->{DEL_KEY} = $verpidx;
                     $delHashCount++;
                  }
               }
            }
          }
          # what about components ?
          # Let the component be there as the current version is already updated.
          # That component was never uninstalled
        }
        $loopctrl++;
      }
   }
  
  #----------------------------------#
  # 2.  If a Versioned Patch exists, update the version of the respective component
  #      For all VERSIONED PATCHES, update the corresponding component version
    foreach my $vidx (sort {$a<=>$b} keys (%verPatches))
    {
      my $compUpdated = 0;
      my $verpRef = $verPatches{$vidx};
      foreach my $compidx (sort {$a<=>$b} keys %comps)
      {
        #since we are anyway looping through all components
        # do some dirty work for unsure code
        if (!defined($comps{$compidx}->{_IS_TOP_LEVEL}) || 
                ($comps{$compidx}->{_IS_TOP_LEVEL} eq ''))
        {
          $comps{$compidx}->{_IS_TOP_LEVEL} = 'N';
        }
        # one cannot load N/A in DATE in db
        #if (!defined($comps{$compidx}->{_TIMESTAMP}) ||
        #          ($comps{$compidx}->{_TIMESTAMP} eq '' ))
        #{
        #  $comps{$compidx}->{_TIMESTAMP} = "N/A";
        #}
        # Back to what we were doing 
        if (( ($comps{$compidx}->{_NAME} eq $verpRef->{_NAME}) &&
             ($comps{$compidx}->{_VER} eq $verpRef->{_BASE_VER}) ) &&
             ($comps{$compidx}->{_CURR_VER} lt $verpRef->{_VER} ) ) # 10.2.0.3 after 10.2.0.4
        {
            $comps{$compidx}->{_CURR_VER} = $verpRef->{_VER};
            $comps{$compidx}->{_INST_TYPE_LIST} = $verpRef->{_INST_TYPE_LIST};
            $compUpdated = 1;
            last;
        }
      }
      if (!$compUpdated) # component with that version was not found
      {
        my $msg = "Component on which Versioned Patch $verpRef->{_NAME} $verpRef->{_BASE_VER} is applied does not exist";
        emdcommon_ocm::EMD_PERL_WARN($msg);
        $warnings->addWarning($msg);
      }
    } 

  #----------------------------------#
  # 3. Linking Versioned Patch to Patchset, not required
  # as Patchset->{_PS_PATCH_LIST} contains the forward reference
  # verPatches{_PS_NAME} and {_PS_VER} will contain backward reference 
  foreach  my $patchidx (sort {$a<=>$b} keys %patchSets)
  {
    my $PSPRef = $patchSets{$patchidx}->{_PS_PATCH_LIST};
    foreach my $PSPidx (sort {$a<=>$b} keys %{$PSPRef})
    { 
      foreach my $verpidx (sort  {$a<=>$b} keys %verPatches)
      { 
        if (($verPatches{$verpidx}->{_NAME} eq $PSPRef->{$PSPidx}->{_NAME}) &&
            ($verPatches{$verpidx}->{_VER}  eq $PSPRef->{$PSPidx}->{_VER} ))
            {
              $verPatches{$verpidx}->{_PS_NAME} = $patchSets{$patchidx}->{_NAME};
              $verPatches{$verpidx}->{_PS_VER} = $patchSets{$patchidx}->{_VER};
              last;
            }
      }
    }
  }


  #----------------------------------#
  # 4. If there are any PSUs which update component LATEST Version
  # then update the component version
  # THIS CODE MAY ACTUALLY NOT BE USED as there no PSUs updating comp version
  # EVEN IF IT HAPPENS IN FUTURE, it might be a new tag altogether.
  # Handling it here as OUI metadata supports it, but OPATCH doesnt update it
  foreach my $psuIdx (sort  {$a<=>$b} keys (%patches))
  {
     # since we are anyways going through the patches, fetch UPI
     if ($patches{$psuIdx}->{_IS_PSU} eq 'Y')
     {
       my $patchCompRef = $patches{$psuIdx}->{_REF_LIST};
       # for each affected component in that PSU
       foreach my $pcompidx (sort {$a<=>$b} keys (%{$patchCompRef}))
       {
         my $compUpdated = 0;
         # go through the components hash to find matching name version
         # _VER contains Version in case of one offs and from_ver in case of PSUs
         my $patchCompVer = $patchCompRef->{$pcompidx}->{_VER}; 
         foreach my $compidx (sort {$a<=>$b} keys %comps)
         {
           if( ($patchCompRef->{$pcompidx}->{_NAME} eq $comps{$compidx}->{_NAME} ) &&
              ($patchCompVer eq $comps{$compidx}->{_CURR_VER}))
           {
             $comps{$compidx}->{_CURR_VER} = $patchCompRef->{$pcompidx}->{_TO_VER};
             $compUpdated = 1;
           }
         }
         if (!$compUpdated) # component with that version was not found
         {
            my $msg = "Component $patchCompRef->{$pcompidx}->{_NAME} version $patchCompVer on which PSU $patches{$psuIdx}->{_PATCH_ID} is applied does not exist";
            emdcommon_ocm::EMD_PERL_WARN($msg);
            $warnings->addWarning($msg);
         }
       }
     }
     # else dont bother for oneoff
  }
}


sub _prepareCompDeps
{
  my $compDepsRef = shift;
  my $noDeps    = 0;

  foreach my $index (keys %comps)
  {
    # -- fetch component dependencies
    my ($name,$ver, $depList) = (
            $comps{$index}->{_NAME}, 
            $comps{$index}->{_CURR_VER},
            $comps{$index}->{_DEP_LIST}
           );

    foreach my $idx (keys %{$depList})
    {
      my ($refName , $refVer) = (
             $depList->{$idx}->{_NAME},
             $depList->{$idx}->{_VER}
            );
    
      # we need to fetch current version for deplists
      # components current version is already updated based on Versioned Patches and PSUs if any
      foreach my $cidx (keys %comps)
      {
        if ( ($refName eq $comps{$cidx}->{_NAME}) &&
             ($refVer  eq $comps{$cidx}->{_VER}) )
        {
          $refVer = $comps{$cidx}->{_CURR_VER};
        }
      }
       
      $compDepsRef->{$noDeps++} = bless ({
             _DEP_NAME  => $name,
             _DEP_VER   => $ver,
             _REF_NAME  => $refName,
             _REF_VER   => $refVer
            },"CompDepClass");

    }
  }
}


sub _fetchUPI 
{
    my $self = shift;
    my ($patchConfigFolder, $index) = @_;
    my $bugList = $patches{$index}->{_BUG_LIST};
    my $invFileOldVer = File::Spec->catfile($patchConfigFolder,"inventory");
    my $invFile = $invFileOldVer.".xml" ;

    my $inventoryFile = $invFileOldVer;
    if ( my $retVal = OH_Utilities::checkPermissions($inventoryFile)) {
        emdcommon_ocm::EMD_PERL_DEBUG("Could not find $inventoryFile, now trying $invFile");
        $inventoryFile = $invFile;
    }

    if (!(my $retVal = OH_Utilities::checkPermissions($inventoryFile)) ) 
    {
        emdcommon_ocm::EMD_PERL_DEBUG("READING $inventoryFile for fetching UPI");
        # Read lines and grep for the string.
        # grepping because this is not an XML file
        if (open(ONE_OFF_INV_FILE,"<$inventoryFile")) 
        {
            my(@lines) = <ONE_OFF_INV_FILE>;
            my $all_lines = join ' ', @lines;
            if($all_lines =~ m|<unique_patch_id>(.*?)<\/unique_patch_id>|s) 
            {
               my $linesBtTags = $1;
               $linesBtTags =~s|\r?\n| |gs;
               if ($linesBtTags) {
                   emdcommon_ocm::EMD_PERL_DEBUG("Fetched UPI from PATCH INVENTORY -- $linesBtTags");
                   $patches{$index}->{_UPI} = $linesBtTags;
               }
            }
            if($all_lines =~ m|<patch_description>(.*?)<\/patch_description>|s)
            {
              my $patchDesc = $1;
              $patchDesc  =~s|\r?\n||gs;
              emdcommon_ocm::EMD_PERL_DEBUG("Fetched Patch Description from PATCH INVENTORY -- $patchDesc");
              $patches{$index}->{_DESC} = $patchDesc;
            }
            while ($all_lines =~ /(.*?\s*\<bug\s*number\s*=\s*\"\s*)([\d]+)(\s*\".*?\s*description\s*=\s*\"\s*)(.*?)(\".*?)$/sgm)
            {
              my $bugNumber = $2;
              my $bugDesc = $4 ;
              $bugNumber =~ s|\r?\n||gs;
              $bugDesc =~ s|\r?\n||gs;

              emdcommon_ocm::EMD_PERL_DEBUG("Fetched Bug Number-- $bugNumber and Bug Description -- $bugDesc from PATCH INVENTORY");
              foreach my $refIdx (keys %{$bugList})
              {
                  if($bugList->{$refIdx}->{_NUM} == $bugNumber)
                  {
                     emdcommon_ocm::EMD_PERL_DEBUG("Found Bug $bugNumber in the buglist, adding bug description");
                     $bugList->{$refIdx}->{_DESC} = $bugDesc;
                  }
              }
            }
            #close the file
            close(ONE_OFF_INV_FILE);
        }
    } else {
        emdcommon_ocm::EMD_PERL_DEBUG("Patch inventory file DOES NOT EXIST or IS NOT READABLE for $patches{$index}->{_PATCH_ID}");
        return undef;
    }
}

sub _fetchActions
{
   my $self = shift;
   my ($patchConfigFolder, $id, $upi, $lang, $patchFileRef) = @_;
   my $actionsFile = File::Spec->catfile($patchConfigFolder,"actions");
   my $actionsXmlFile = $actionsFile.".xml" ;
   my $actnFile = $actionsFile;
   $upi = 'N/A' if (!defined $upi); # this will never be the case

   if (my $retVal = OH_Utilities::checkPermissions($actionsFile)) {
       $actnFile = $actionsXmlFile;
   }

   # Read One of actions file
   if (!(my $retVal = OH_Utilities::checkPermissions($actnFile)) ) { # File exists and readable
      emdcommon_ocm::EMD_PERL_DEBUG("READING $actnFile for Oneoff Actions");

      my $OOObj = new OH_ParseOneoffActions ();
      my %actionsObj = ();  
      $OOObj->getActions($actnFile, \%actionsObj);

      foreach my $cIdx (sort keys(%actionsObj))
      {
        my $compName = $actionsObj{$cIdx}->{_NAME};
        my $compVer  = $actionsObj{$cIdx}->{_VERSION};

        foreach my $aIdx (keys(%{$actionsObj{$cIdx}->{_ACTIONS}}))
        {
           my $patchFileAdded;
           my $compAction = $actionsObj{$cIdx}->{_ACTIONS}->{$aIdx}->{_ACTION};
           my $fileName = undef;

           if( ($compAction eq "copy") || ($compAction eq "onewaycopy") ) {
               $fileName = File::Spec->catfile("$self->{HOME_LOC}", "$actionsObj{$cIdx}->{_ACTIONS}->{$aIdx}->{file_name}");
           } elsif ($compAction eq "archive") {
               $fileName = File::Spec->catfile("$self->{HOME_LOC}","$actionsObj{$cIdx}->{_ACTIONS}->{$aIdx}->{object_name}");
           } elsif ($compAction eq "jar") {
               $fileName = File::Spec->catfile("$self->{HOME_LOC}", "$actionsObj{$cIdx}->{_ACTIONS}->{$aIdx}->{class_name}");
           } elsif ($compAction eq "make") {
               $fileName = File::Spec->catfile("$self->{HOME_LOC}","$actionsObj{$cIdx}->{_ACTIONS}->{$aIdx}->{change_dir}" , "$actionsObj{$cIdx}->{_ACTIONS}->{$aIdx}->{make_file}");
               $fileName = $fileName . "->" . "$actionsObj{$cIdx}->{_ACTIONS}->{$aIdx}->{make_target}";
           }
           
           # check if the patch file has already been added (no duplicates)
           $patchFileAdded = 0;
           foreach my $idx (sort keys %$patchFileRef) 
           {
             if ( ($patchFileRef->{$idx}->{_PATCH_ID} == $id) &&
                  ($patchFileRef->{$idx}->{_UPI} eq $upi)     &&
                  ($patchFileRef->{$idx}->{_LANG} eq $lang)   &&
                  ($patchFileRef->{$idx}->{_COMP_NAME} eq $compName)   &&
                  ($patchFileRef->{$idx}->{_COMP_VER} eq $compVer)     &&
                  ($patchFileRef->{$idx}->{_FILE_NAME} eq $fileName) ) 
             {
                emdcommon_ocm::EMD_PERL_DEBUG("Patch file duplication .. $id $upi $lang $compName $compVer $fileName ");
                $patchFileAdded = 1;
                last;
             }
           }

           if (! $patchFileAdded) 
           {
               my $patchCompCount = scalar keys %$patchFileRef;
               $patchFileRef->{$patchCompCount} = bless({
                      _PATCH_ID        =>  $id,
                      _UPI       => $upi,
                      _LANG      => $lang,
                      _COMP_NAME => $compName,
                      _COMP_VER  => $compVer,
                      _FILE_NAME => $fileName
               }, "PatchFileClass");
           }
         }# actions
       }# keys
   } else {
       emdcommon_ocm::EMD_PERL_DEBUG("File Permission issue ... Couldn't read $actnFile for PATCH $id|$upi|$lang");
   }
   emdcommon_ocm::EMD_PERL_DEBUG("PATCH $id|$upi|$lang is FOUND");

}


# OPATCH NEVER POPULATED FILE LIST IN OUI's comps.xml, till late
# Even if they do, they already update the same in actions file (which we parse anyway)
# COMMENTING THIS OUT, if at all it gets used in future (for reference only)
#sub _fetchPatchFiles
#{
#   my $self = shift;
#   my ( $fileList, $id, $upi, $lang, $noFiles) = @_; 
#   $upi = 'N/A' if (!defined $upi);
#
#   foreach my $refIdx (keys %{$fileList})
#    {
#      my ($parent, $child) = (
#             $fileList->{$refIdx}->{_PARENT_PATH},
#             $fileList->{$refIdx}->{_CHILD_PATH});
#      my $filePath = File::Spec->catfile($parent,$child);
#      emdcommon_ocm::EMD_PERL_DEBUG("\t affects file $filePath ");
#      $patchFiles{$noFiles++} = bless({
#                 _PATCH_ID    =>  $id,
#                 _UPI         =>  $upi,
#                 _LANG        =>  $lang,
#                 _FILE_NAME   =>  $filePath
#              },"PatchFileClass");
#     }
#     return $noFiles;
#
#}
#

# -- get components
sub getComponents
{
  # return the component hash
  return \%comps;
}

# -- get Top Level componets
sub getTLComponents
{
  # create and return TLComps Hash
  my %TLcomps = ();

  foreach my $index (keys %comps)
  {
    if ($comps{$index}->{_IS_TOP_LEVEL} eq 'Y')
    {
        $TLcomps{keys %TLcomps} = $comps{$index};
    }
  }     
  # return the TL component hash
  return \%TLcomps; # How are we accessing %comps outside, 2 calls ?
}

# -- get component dependencies
sub getCompDeps
{
  #create and return compDeps hash
  my %compDeps = ();
  _prepareCompDeps(\%compDeps);
  # return the component deps
  return \%compDeps;
}


# -- get component install types
sub getCompInstTypes
{
  my %instTypes = ();
  my $noITs = 0;

  foreach my $index (keys %comps)
  {
    my $instListRef = $comps{$index}->{_INST_TYPE_LIST};
    foreach my $idx (keys %{$instListRef})
    {
      $instTypes{$noITs}= bless ({
             _COMP_NAME => $comps{$index}->{_NAME},
             _COMP_VER  => $comps{$index}->{_CURR_VER},
              %{$instListRef->{$idx}}
            },"CompInstTypeClass");
      $noITs++;
    }
  }

  #return the install types hash
  return \%instTypes;
}


# -- get patches
sub getPatches
{
  return \%patches;
}

# get patch comps
sub getPatchComps
{
  my $self = shift;
  my $warnings = $self->{WARNINGS};
  my %patchComps = ();

  foreach my $index (keys %patches)
  {
     my ($id, $upi, $lang, $refList) = (
          $patches{$index}->{_PATCH_ID},
          $patches{$index}->{_UPI},
          $patches{$index}->{_LANG},
          $patches{$index}->{_REF_LIST}
     );

     foreach my $refIdx (keys %{$refList})
     {
       my $compFound = 0;
       # check if the component exists ...
       # _VER contains Version in case of one offs and _FROM_VER in case of PSUs
       my $patchCompVer = $refList->{$refIdx}->{_VER};
       foreach my $cidx (keys %comps)
       {
          if ( ($comps{$cidx}->{_NAME} eq $refList->{$refIdx}->{_NAME}) &&
              (($comps{$cidx}->{_VER} eq $patchCompVer) ||
               ($comps{$cidx}->{_CURR_VER} eq $patchCompVer)))
          # check for current version is for cases where comp is affected by Patchset (VerPatch)
          {
            $compFound =1;
            last;
          }
          last if $compFound;
       }
       if (!($compFound))
       {
          my $msg = "Patch $id($upi-$lang) is affecting a component $refList->{$refIdx}->{_NAME}  Version $patchCompVer which does not exist";
          emdcommon_ocm::EMD_PERL_WARN($msg);
          $warnings->addWarning($msg);
 
       } else 
       {
         $patchComps{keys %patchComps} = bless ({
               _PATCH_ID =>  $id,
               _UPI      =>  $upi,
               _LANG     =>  $lang,
               _NAME     =>  $refList->{$refIdx}->{_NAME},
               _VER      =>  ($refList->{$refIdx}->{_VER} ? $refList->{$refIdx}->{_VER} : '0.0.0.0'),
               _FROM_VER =>  $refList->{$refIdx}->{_FROM_VER}, #only populated for PSUs
               _TO_VER   =>  $refList->{$refIdx}->{_TO_VER}  #only populated for PSUs
             }, "PatchCompClass");

       }
     }
  }
  return \%patchComps;

}

# get patch bugs
sub getPatchBugs
{
  my $self = shift;
  my $warnings = $self->{WARNINGS};
  my %patchBugs = ();
  foreach my $index (keys %patches)
  {
     my ($id, $upi, $lang, $bugList) = (
          $patches{$index}->{_PATCH_ID},
          $patches{$index}->{_UPI},
          $patches{$index}->{_LANG},
          $patches{$index}->{_BUG_LIST}
     );
     foreach my $refIdx (keys %{$bugList})
     {
        emdcommon_ocm::EMD_PERL_DEBUG("Fixes BUG $bugList->{$refIdx}->{_NUM} ");

         $patchBugs{scalar keys %patchBugs} = bless ({
              _PATCH_ID    =>  $id,
              _UPI         =>  $upi,
              _LANG        =>  $lang,
              _BUGS        =>  $bugList->{$refIdx}->{_NUM},
              _DESC        =>  $bugList->{$refIdx}->{_DESC}
         },"PatchBugClass");
     }
   }
   return \%patchBugs;
}

# get patched files
sub getPatchFiles
{
  my $self = shift;
  my %patchFiles = ();
  
  foreach my $index (keys %patches)
  {
     my ($id, $upi, $lang, $fileList) = (
          $patches{$index}->{_PATCH_ID},
          $patches{$index}->{_UPI},
          $patches{$index}->{_LANG},
          $patches{$index}->{_FILE_LIST}
         );

    # Construct Opatch's metadata file locations
    my $patchConfigFolder = File::Spec->catfile($self->{HOME_LOC},"inventory",$patches{$index}->{_XML_INV_LOC},"etc","config");
    
    emdcommon_ocm::EMD_PERL_DEBUG("READING Oneoff Actions from Oneoff actions file");
    _fetchActions($self, $patchConfigFolder, $id, $upi, $lang, \%patchFiles);

  }

  return \%patchFiles;
}

# -- get Patchsets
sub getPatchSets
{

 return \%patchSets;
}

# -- get version patches
sub getVersionPatches
{

 return \%verPatches;
}


# -- get isClonable info
sub getIsClonable
{
  my $self = shift;
  # by now we have all the components collected
  if(!scalar (keys %comps))
  {# that means this home has no components.. return not clonable
    return 'N';  
  }
  # If a component has CLONABLE as "Y". If CLONABLE tag is missing then if the OUI version that installed this
  # component is later than 2.3.0.0.0 then its clonable otherwise not
  foreach my $index (keys(%comps))
  {
    my ($clonable, $ouiVer)= ($comps{$index}->{_CLONABLE},$comps{$index}->{_INST_VER});
    if(defined($clonable))#that means it is not null and it has CLONABLE tag
    {
      if($clonable eq 'N')
      {
        #if one component is not clonable then home is not clonable
        return 'N'; 
      }
    }
    elsif($ouiVer && OH_Utilities::versionCompare("02.3.0.0.0",$ouiVer)) #TODO: We need to discuss what to return when ouiVer is not defined
    { 
      #CLONABLE tag is missing and OUI version that installed this component is later than 2.3.0.0.0 then 
      # the component is clonable otherwise not
      return 'N';
    }
  }
  return 'Y';
}


## -- HANDLER
 sub startTagHandler
{
  my $p = shift;
  my $el = shift;

  if ($el eq "TL_LIST")
  {
    $inTopLevel = "TRUE";
  }
  elsif ($el eq "COMP")
  {
    $inComp = "TRUE";
    my $compInf = $comps{$Cfound};
    if (not defined($compInf))
    {
      $comps{$Cfound++} = $compInf = new ComponentClass;

    }
    $compInf->{_IS_TOP_LEVEL} = (($inTopLevel eq "TRUE") ? 'Y' : 'N');
    my ($att, $val);
    while (@_)
    {
      $att = shift;
      $val = shift;
      if ($att eq "NAME")
      {
        $compInf->{_NAME} = $val;
      }
      elsif ($att eq "VER")
      {
        $compInf->{_VER} = ($val ? $val : '0.0.0.0');
        # initialize Current version to Base Version initially
        $compInf->{_CURR_VER} = ($val ? $val : '0.0.0.0');;
      }
      elsif ($att eq "LANGS")
      {
        $compInf->{_LANGS} = $val;
      }
      elsif ($att eq "INST_LOC")
      {
        $compInf->{_INST_LOC} = $val;
      }
      elsif ($att eq "ACT_INST_VER")
      {
        $compInf->{_INST_VER} = $val;
      }
      elsif ($att eq "DEINST_VER")
      {
        $compInf->{_DEINST_VER} = $val;
      }
      elsif ($att eq "INSTALL_TIME")
      {
        $compInf->{_TIMESTAMP} = OH_Date::conDateToYYYMMDD($val);
      }
      elsif($att eq "CLONABLE")
      {
        $compInf->{_CLONABLE} = $val;
      }

    }
  }
  elsif ($el eq "PATCH")
  {
    $inPatch = "TRUE";
    my $patchInf = $verPatches{$VPfound};
    if (not defined($patchInf))
    {
      $verPatches{$VPfound} = $patchInf = new VerPatchClass;
      $VPfound++;
    }
    my ($att, $val);
    while (@_)
    {
      $att = shift;
      $val = shift;
      if ($att eq "NAME")
      {
        $patchInf->{_NAME} = $val;
      }
      elsif ($att eq "VER")
      {
        $patchInf->{_VER} = $val;
      }
      elsif ($att eq "BASE_VER")
      {
        $patchInf->{_BASE_VER} = $val;
      }
      elsif ($att eq "LANGS")
      {
        $patchInf->{_LANGS} = $val;
      }
      elsif ($att eq "INST_LOC")
      {
        $patchInf->{_INST_LOC} = $val;
      }
      elsif ($att eq "ACT_INST_VER")
      {
        $patchInf->{_ACT_INST_VER} = $val;
      }
      elsif ($att eq "DEINST_VER")
      {
        $patchInf->{_DEINST_VER} = $val;
      }
      elsif ($att eq "INSTALL_TIME")
      {
        $patchInf->{_TIMESTAMP} = OH_Date::conDateToYYYMMDD($val);
      }
    }
  }
  elsif ($el eq "PATCHSET")
  {
    $inPatchSet = "TRUE";
    my $pSetInf = $patchSets{$PSfound};
    if (not defined($pSetInf))
    {
      $patchSets{$PSfound} = $pSetInf = new PatchsetClass;
      $PSfound++;
    }
    my ($att, $val);
    while (@_)
    {
      $att = shift;
      $val = shift;
      if ($att eq "NAME")
      {
        $pSetInf->{_NAME} = $val;
      }
      elsif ($att eq "VER")
      {
        $pSetInf->{_VER} = $val;
      }
      elsif ($att eq "INV_LOC")
      {
        $pSetInf->{_INV_LOC} = $val;
      }
      elsif ($att eq "ACT_INST_VER")
      {
        $pSetInf->{_ACT_INST_VER} = $val;
      }
      elsif ($att eq "DEINST_VER")
      {
        $pSetInf->{_DEINST_VER} = $val;
      }
      elsif ($att eq "INSTALL_TIME")
      {
        $pSetInf->{_TIMESTAMP} = OH_Date::conDateToYYYMMDD($val);
      }
    }
  }
  elsif ($el eq "PS_PATCH")
  {
    if ($inPatchSet eq "TRUE")
    {
      my $pspInfo = {};
      my ($att, $val);
      while (@_)
      {
        $att = shift;
        $val = shift;
        if ($att eq "NAME")
        {
          $pspInfo->{_NAME} = $val;
        }
        elsif ($att eq "VER")
        {
          $pspInfo->{_VER} = $val;
        }
        elsif ($att eq "BASE_VER")
        {
          $pspInfo->{_BASE_VER} = $val;
        }
      }
      #Store the index of PATCHSET it belongs to, backward reference
      $pspInfo->{_PS_IDX}=($PSfound-1);
      # Store this PS_PATCH information with PATCHSET, forward reference
      $patchSets{$PSfound-1}->{_PS_PATCH_LIST}->{$PPDfound} = $pspInfo;
      $PPDfound++;
    }
  }
  elsif ( ($el eq "ONEOFF") ||  ($el eq "PATCHSET_UPDATE"))
  {
    $inOneOff = "TRUE";
    my $ooInfo = $patches{$Pfound};
    if (not defined($ooInfo))
    {
      $patches{$Pfound} = $ooInfo = new PatchClass;
      $Pfound++;
    }
    my ($att, $val);
    while (@_)
    {
      $att = shift;
      $val = shift;
      if ($att eq "REF_ID")
      {
        $ooInfo->{_PATCH_ID} = $val;
      }
      elsif ($att eq "UNIQ_ID")
      {
        $ooInfo->{_UPI} = $val;
      }
      elsif ($att eq "LANG")
      {
        $ooInfo->{_LANG} = $val;
      }
      elsif ($att eq "ROLLBACK")
      {
        $ooInfo->{_ROLLBACK} = $val;
      }
      elsif ($att eq "XML_INV_LOC")
      {
        $ooInfo->{_XML_INV_LOC} = $val;
      }
      elsif ($att eq "ACT_INST_VER")
      {
        $ooInfo->{_ACT_INST_VER} = $val;
      }
      elsif ($att eq "INSTALL_TIME")
      {
        $ooInfo->{_TIMESTAMP} = OH_Date::conDateToYYYMMDD($val);
      }
    }
    $ooInfo->{_IS_PSU} = ($el eq "ONEOFF") ? 'N' : 'Y';
  }
  elsif ($el eq "EXT_NAME")
  {
    $inExtName = "TRUE";
  }
  elsif ($el eq "DESC")
  {
    $inDesc = "TRUE";
  }
  elsif ($el eq "DEP_LIST")
  {
    if ($skipGroup eq "FALSE")
    {
	# there can be DEP_LIST in PATCHSET as well
      if ($inComp eq "TRUE")
      {
        $inDepList = "TRUE";
        $comps{$Cfound-1}->{_DEP_LIST} = {};
      }
    }
  }
  elsif ($el eq "BUG_LIST")
  {
    if($inOneOff eq "TRUE")
    {
     $inBugList = "TRUE";
     $patches{$Pfound-1}->{_BUG_LIST} = {};
    }
  }
  elsif($el eq "FILE_LIST")
  {
  	if($inOneOff eq "TRUE")
  	{
  	 $inFileList = "TRUE";
  	 $patches{$Pfound-1}->{_FILE_LIST} = {};
  	}
  }
  elsif ( ($el eq "REF_LIST") || ($el eq "REFCOMP_LIST") )
  # handle both ONEOFF and PSU
  {
    if($inOneOff eq "TRUE")
    {
      $inRefList = "TRUE";
      $patches{$Pfound-1}->{_REF_LIST} = {};
    }
  }
  elsif ($el eq "DEP")
  {
    if ($skipGroup eq "FALSE")
    {
      # need to nest the dependencies
      # there can be DEP_LIST and DEP in PATCHSET as well
      if (($inDepList) && ($inComp eq "TRUE"))
      {
        my $depInfo = {};      
        my ($att, $val);
        while (@_)
        {
          $att = shift;
          $val = shift;
          if ($att eq "NAME")
          {
            $depInfo->{_NAME} = $val;
          }
          elsif ($att eq "VER")
          {
            $depInfo->{_VER} = $val;
            $depInfo->{_VER}='0.0.0.0' if ($depInfo->{_VER} eq '');
          }
        }
        $comps{$Cfound-1}->{_DEP_LIST}->{$CDfound} = $depInfo;
        $CDfound++;
      }
    }
  }
  elsif (($el eq "REF") || ($el eq "REFCOMP"))
  {
    if (($inRefList eq "TRUE") && ($inOneOff eq "TRUE"))
    {
      my $refInfo = {};
      my ($att, $val);
      while (@_)
      {
        $att = shift;
		$val = shift;
		if ($att eq "NAME")
		{
		  $refInfo->{_NAME} = $val;
		}
		elsif ($att eq "VER") #oneoff
		{
		  $refInfo->{_VER} = $val;
		}
                elsif ($att eq "FROM_VER") #PSU
                {
                  # in case of PSU, there is no Component Version
                  # but we cannot have component without version,
                  # hence set it to FROM_VER
                  $refInfo->{_VER} = $val;
                  $refInfo->{_FROM_VER} = $val;
                }
                elsif ($att eq "TO_VER") #PSU
                {
		  $refInfo->{_TO_VER} = $val;
		}

      }
      $patches{$Pfound-1}->{_REF_LIST}->{$PCfound} = $refInfo;
      $PCfound++;
    }
  }
  elsif ($el eq "BUG")
  {
    if (($inBugList eq "TRUE") && ($inOneOff eq "TRUE"))
    {
      $inBug = "TRUE";
      $patches{$Pfound-1}->{_BUG_LIST}->{$PBfound} = {};
      $PBfound++;
    }
  }
  elsif ($el eq "FILE")
  {
    if (($inFileList eq "TRUE") && ($inOneOff eq "TRUE"))
    {
      my $refInfo ={};
      my ($att, $val);

      while (@_)
      {
          $att = shift;
		  $val = shift;
		  if ($att eq "PARENT_PATH")
		  {
		    $refInfo->{_PARENT_PATH} = $val;
		  }
		  elsif ($att eq "CHILD_PATH")
		  {
		    $refInfo->{_CHILD_PATH} = $val;
		  }
      }
      $patches{$Pfound-1}->{_FILE_LIST}->{$PFfound} = $refInfo;
      $PFfound++;
    }
  }
  elsif (($el eq "DEP_GRP_LIST") || ($el eq "DEP_GRP"))
  {
    $skipGroup = "TRUE";
  }
  elsif($el eq "INST_TYPE")
  {
    # set the count
     if(($inPatch eq "TRUE") || ($inComp eq "TRUE"))
     { # we need oly install types of components and version patches
  	  my $refInfo = {};
  	  if($inPatch eq "TRUE")
  	  {
  	  	$verPatches{$VPfound-1}->{_INST_TYPE_LIST}->{$ITinPfound} = $refInfo;
  	  	$ITinPfound++;
  	  }
  	  elsif($inComp eq "TRUE")
  	  {
                $comps{$Cfound-1}->{_INST_TYPE_LIST}->{$ITinCfound} = $refInfo;
                $ITinCfound++;
          }
          my ($att, $val);
          while (@_)
          {
            $att = shift;
		$val = shift;
		if ($att eq "NAME")
		{
		  $refInfo->{_NAME} = $val;
		}
		elsif ($att eq "NAME_ID")
		{
		  $refInfo->{_NAME_ID} = $val;
		}
		elsif ($att eq "DESC_ID")
		{
		  $refInfo->{_DESC_ID} = $val;
		}
          }
      }
  }
}

sub endTagHandler
{
  my $p = shift;
  my $el = shift;
  #print "*__ $el __*\n";

  if ($el eq "TL_LIST")
  {
    $inTopLevel = "FALSE";
  }
  elsif ($el eq "COMP")
  {
    $inComp = "FALSE";
    $ITinCfound =0;

  }
  elsif ($el eq "PATCH")
  {
    $inPatch = "FALSE";
    $ITinPfound = 0;
  }
  elsif ($el eq "PATCHSET")
  {
    $inPatchSet = "FALSE";
    $PPDfound = 0; # reset PS_PATCH count within PATCHSET
  }
  elsif ($el eq "ONEOFF")
  {
    $inOneOff = "FALSE";
  }
  elsif ($el eq "PATCHSET_UPDATE")
  {
    $inOneOff = "FALSE";
  }
  elsif ($el eq "EXT_NAME")
  {
    $inExtName = "FALSE";
  }
  elsif ($el eq "DESC")
  {
    $inDesc = "FALSE";
  }
  elsif ($el eq "DEP_LIST")
  {
    $inDepList = "FALSE";
    $CDfound = 0;
  }
  elsif (($el eq "REF_LIST") ||  ($el eq "REFCOMP_LIST"))
  {
    $inRefList = "FALSE";
    $PCfound = 0;
  }
  elsif ($el eq "BUG_LIST")
  {
    $inBugList = "FALSE";
    $PBfound = 0;
  }
  elsif ($el eq "BUG")
  {
    $inBug = "FALSE";
  }
  elsif (($el eq "DEP_GRP_LIST") || ($el eq "DEP_GRP"))
  {
    $skipGroup = "FALSE";
  }
}

sub charTagHandler
{
  my $p = shift;
  my $info = shift;
  $info =~ s/\n/ /g;
  if (($inExtName eq "TRUE") || ($inDesc eq "TRUE"))
  {
    if ($inExtName eq "TRUE")
    {
      if ($inComp eq "TRUE")
      {
        $comps{$Cfound-1}->{_EXT_NAME} = defined($comps{$Cfound-1}->{_EXT_NAME}) ?
                                          $comps{$Cfound-1}->{_EXT_NAME}.$info : $info;
        $comps{$Cfound-1}->{_EXT_NAME} ='' if(!defined($comps{$Cfound-1}->{_EXT_NAME}));
      }
      elsif ($inPatch eq "TRUE")
      {
        $verPatches{$VPfound-1}->{_EXT_NAME} = defined($verPatches{$VPfound-1}->{_EXT_NAME}) ?
                                           $verPatches{$VPfound-1}->{_EXT_NAME}.$info : $info;
        $verPatches{$VPfound-1}->{_EXT_NAME} ='' if(!defined($verPatches{$VPfound-1}->{_EXT_NAME}));
      }
      elsif ($inPatchSet eq "TRUE")
      {
        $patchSets{$PSfound-1}->{_EXT_NAME} = defined($patchSets{$PSfound-1}->{_EXT_NAME}) ?
                                              $patchSets{$PSfound-1}->{_EXT_NAME}.$info : $info;
        $patchSets{$PSfound-1}->{_EXT_NAME} ='' if(!defined($patchSets{$PSfound-1}->{_EXT_NAME}));
      }
    }
    elsif ($inDesc eq "TRUE")
    {
      if ($inComp eq "TRUE")
      {
        $comps{$Cfound-1}->{_DESC} = defined($comps{$Cfound-1}->{_DESC}) ?
                                     $comps{$Cfound-1}->{_DESC}.$info : $info;
        $comps{$Cfound-1}->{_DESC}='' if(!defined($comps{$Cfound-1}->{_DESC}));
      }
      elsif ($inPatch eq "TRUE")
      {
        $verPatches{$VPfound-1}->{_DESC} = defined($verPatches{$VPfound-1}->{_DESC}) ?
                                       $verPatches{$VPfound-1}->{_DESC}.$info : $info;
        $verPatches{$VPfound-1}->{_DESC}='' if (!defined($verPatches{$VPfound-1}->{_DESC}));
      }
      elsif ($inPatchSet eq "TRUE")
      {
        $patchSets{$PSfound-1}->{_DESC} = defined($patchSets{$PSfound-1}->{_DESC}) ?
                                          $patchSets{$PSfound-1}->{_DESC}.$info : $info;
        $patchSets{$PSfound-1}->{_DESC}='' if (!defined($patchSets{$PSfound-1}->{_DESC}));
      }
      elsif ($inOneOff eq "TRUE")
      {
        $patches{$Pfound-1}->{_DESC} = defined($patches{$Pfound-1}->{_DESC}) ?
                                          $patches{$Pfound-1}->{_DESC}.$info : $info;
        $patches{$Pfound-1}->{_DESC}='' if (!defined($patches{$Pfound-1}->{_DESC}));
      }
    }
  }
  elsif($inBug eq "TRUE")
  {
    $patches{$Pfound-1}->{_BUG_LIST}->{$PBfound-1}->{_NUM} = $info;
  }
}

sub init
{
 %comps      = ();
 %instTypes  = ();
 %patches    = ();
 %patchSets  = ();
 %verPatches = ();
}

1;

