#
# $Header: emagent/sysman/admin/scripts/OH_ParseOHPropXml.pm /main/5 2011/04/20 03:41:24 hmodawel Exp $
#
# OH_ParseOHPropXml.pm
#
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      OH_ParseOHPropXml.pm - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    irraju      05/17/10 - Perl Module to extract info from 
#                           oraclehomeproperties xml.
#    irraju      05/17/10 - Creation
package OH_ParseOHPropXml;
## USE DIRECTIVES
use strict;
use warnings;
use OH_Utilities;
use XML::Parser;
use OH_Error;

use emdcommon_ocm;

use fields qw (HOME_GUID ARU_ID ARU_ID_DESC PROP_LIST NODE_LIST CRS XML_FILE );

## VARIABLES
my $inOHPropAruID    = "FALSE";
my $inOHPropGuid     = "FALSE";
my $inOHPropAruDesc  = "FALSE";
my $inOHPropProperty = "FALSE";
my $inNodeList       = "FALSE";

my %OHPropXml   = ();
my $OHPropFound = 0;
my $nodesFound  = 0;
sub new
{
  my ($class,%vals) = @_;
  my $self = fields::new(ref($class)||$class);
  $self->{XML_FILE}= $vals{XML_FILE};
  #DEFAULTS
  $self->{CRS}    = 'N';
  $self->{ARU_ID} = "-1";
  init();
  return $self;
}
sub getOHProperties
{
  my $self    = shift;
  my $warnings = shift;
  my $error    = shift; 
  my $OHPropXMLFile = $self->{XML_FILE};
  {
    my $p2 = new XML::Parser(ErrorContext => 2);
    emdcommon_ocm::EMD_PERL_INFO("Starting parsing of $OHPropXMLFile");
    $p2->setHandlers(Start => \&OHProp_start,
                     End   => \&OHProp_end,
		     Char  => \&OHProp_char);

    eval {$p2->parsefile($OHPropXMLFile)};

    if ($@)
    {
      emdcommon_ocm::EMD_PERL_INFO("Failed to parse using default encoding:$@");
      foreach $_ (@encTable)
      {
        initVariables();
        %OHPropXml = ();
        emdcommon_ocm::EMD_PERL_INFO("TRYING with $_ eincoding..");
        eval '$p2->parsefile($OHPropXMLFile, ProtocolEncoding => $_)';

        if ($@)
        {
          emdcommon_ocm::EMD_PERL_INFO("Failed again :$@. Trying with another encoding");
        }
        else
        {
         last; #SUCCESS
        }
      }
    }
    if ($@)
    {
      $error->setError( CODE => OH_Error::XML_PARSE_ERR,
                          ARG  => "$OHPropXMLFile");
      return OH_Error::XML_PARSE_ERR;
    }
  }

  # -- put things in the object
  $self->{HOME_GUID} = $OHPropXml{_GUID};
  $self->{ARU_ID} = $OHPropXml{_ARU_ID};
  # later change it to get it using platform
  $self->{ARU_ID_DESC} = $OHPropXml{_ARU_ID_DESC};
  $self->{PROP_LIST}   = $OHPropXml{_PROP_LIST};
  $self->{NODE_LIST}   = $OHPropXml{_NODE_LIST};
  $self->{CRS}         = $OHPropXml{_CRS};
  emdcommon_ocm::EMD_PERL_INFO("Finished parsing $OHPropXMLFile ...");

  return OH_Error::SUCCESS;
}



sub OHProp_start
{
  my $p = shift;
  my $el = shift;

  if ($el eq "ARU_ID")
  {
    $inOHPropAruID = "TRUE";
    if (!(%OHPropXml))
    {
      %OHPropXml = (); #new OHProp;
    }
  }
  elsif($el eq "GUID")
  {
    $inOHPropGuid  = "TRUE";
    if (!(%OHPropXml))
    {
      %OHPropXml = (); #new OHProp;
    }
  }
  elsif($el eq "ARU_ID_DESCRIPTION")
  {
    $inOHPropAruDesc = "TRUE";
    if (!(%OHPropXml))
    {
      %OHPropXml = (); #new OHProp;
    }
  }
  elsif($el eq "HOME")
  {
    my %atts = @_;
    if (!(%OHPropXml))
    {
      %OHPropXml = (); #new OHProp;
    }

    if(exists $atts{CRS})
    {
      $OHPropXml{_CRS} = ($atts{CRS} eq "T")? 'Y':'N';
    }
  }
  elsif($el eq "NODE_LIST")
  {
    $inNodeList = "TRUE";
    if (!(%OHPropXml))
    {
      %OHPropXml = (); #new OHProp;
    }
   
  }
  elsif($el eq "NODE")
  {
    my %atts = @_;
    if(exists $atts{NAME} and ($inNodeList eq "TRUE")) 
    {
     $OHPropXml{_NODE_LIST}->{$nodesFound++}= $atts{NAME};
    }
  }
  elsif($el eq "PROPERTY")
  {
    $inOHPropProperty = "TRUE";
    if (!(%OHPropXml))
    {
      %OHPropXml = (); #new OHProp;
    }

    my $propRef = $OHPropXml{_PROP_LIST}->{$OHPropFound};
    if(not defined($propRef))
    {
      $OHPropXml{_PROP_LIST}->{$OHPropFound} = $propRef = {};
    }
    my ($att, $val);
    while (@_)
    {
      $att = shift;
      $val = shift;
      if ($att eq "NAME")
      {
         $propRef->{_NAME} = $val;
      }
      elsif ($att eq "VAL")
      {
        $propRef->{_VAL} = $val;
      }
    }
    $OHPropFound++;
  }
}

sub OHProp_end
{
  my $p = shift;
  my $el = shift;

  if ($el eq "ARU_ID")
  {
    $inOHPropAruID = "FALSE";
  }
  elsif($el eq "GUID")
  {
    $inOHPropGuid  = "FALSE";
  }
  elsif ($el eq "ARU_ID_DESCRIPTION")
  {
    $inOHPropAruDesc = "FALSE";
  }
  elsif($el eq "PROPERTY")
  {
    $inOHPropProperty = "FALSE";
  }
  elsif($el eq "NODE_LIST")
  {
    $inNodeList = "FALSE";
    $nodesFound = 0;
  }
}
sub OHProp_char
{
  my $p = shift;
  my $info = shift;
  $info =~ s/\n/ /g;
  if($inOHPropAruID eq "TRUE")
  {
     $OHPropXml{_ARU_ID} = $info;
     $OHPropXml{_ARU_ID} =~ s/^\s*//g;
     if($OHPropXml{_ARU_ID} eq '')
     {
       $OHPropXml{_ARU_ID}=-1;
     }
  }
  elsif ($inOHPropGuid eq "TRUE")
  {
     $OHPropXml{_GUID} = $info;
  }
  elsif ($inOHPropAruDesc eq "TRUE")
  {
     $OHPropXml{_ARU_ID_DESC} = $info;
  }
}


sub initVariables
{
 $inOHPropAruID    = "FALSE";
 $inOHPropGuid     = "FALSE";
 $inOHPropAruDesc  = "FALSE";
 $inOHPropProperty = "FALSE";
 $inNodeList       = "FALSE";

 %OHPropXml   = ();
 $OHPropFound = 0;
 $nodesFound  = 0;
}
sub init
{
 %OHPropXml   = ();
 $OHPropFound = 0;
 $nodesFound  = 0;
}

1;
