#
# $Header: emagent/sysman/admin/scripts/OH_ParseOneoffActions.pm /main/6 2011/05/18 03:16:07 hmodawel Exp $
#
# OH_ParsePatchXml.pm
#
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      OH_ParsePatchXml.pm - <Package to collect all the metrics related to OUI homes>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#        <>
#
#    MODIFIED   (MM/DD/YY)
#    hmodawel    05/17/11 - fix for bug 12559045
#    hmodawel    05/11/11 - fix for bug 12545340
#    hmodawel    04/26/11 - remove end tags from file names
#    sanjkuma    02/14/11 - Address the issue when XML encoding isn't supported
#                           for actions.xml/actions
#    ravpatel    01/21/11 - CCR Convergence
#    irraju      05/17/10 - Package to define all the methods to extract 
#                             information from patch actions xml.
#    irraju      05/17/10 - Creation
#
#USE DIRECTIVES
use strict;
use warnings;
use OH_Utilities;
use emdcommon_ocm;


package OH_ParseOneoffActions;

#GLOBAL VARIABLE
# none, not recommended

sub new
{
  my $class = shift;
  my $self = {};
  bless ($self, $class);
  return $self;
}


#**************** getActions *************************************
# Parses the given actions file and returns the result in a hash

sub getActions
{
  my $self = shift;
  my $xmlFile = shift;
  my $ActionsComps = shift;

  if (!defined $xmlFile) { return $ActionsComps; };

  if (my $retVal = OH_Utilities::checkPermissions($xmlFile))
  {
    emdcommon_ocm::EMD_PERL_DEBUG("$xmlFile does not exist or is not readable");
    return $ActionsComps;
  }

  #Structure
  # $ActionsComps->{0}->{_NAME}
  #                   {_VERSION}
  #                   {_ACTIONS}->{0}->{ACTION} = copy (ex)
  #                                  ->file_name = "CPU.xml"
  #                   {_ACTIONS}->{1}->{ACTION} = make (ex)
  # $ActionsComps->{1}->{_NAME}
  #                   {_VERSION}
  #                   {_ACTIONS}->{0}->{ACTION} = copy (ex)
  #                                  ->file_name = "XYZ.xml"
  #                   {_ACTIONS}->{1}->{ACTION} = make (ex)
  #

  if (open(XML, "<$xmlFile")) 
  {
     my $numComps = scalar keys %$ActionsComps;
     my $numActsPerComp = 0;
     while (<XML>) 
     {
       chomp;
       $_ =~ s/^\s*//;
    
       # Identify and add product details
       if((/ version(\s)*=/) && (!(/ encoding(\s)*=/)) && (!(/ file_version(\s)*=/)) ) 
       {
         $numComps++;
         $ActionsComps->{$numComps} = (); # new action comp
         #can't assume the order here
         #<oracle.rdbms.rsf version="10.2.0.4.0" opt_req="O">
         #<oracle.rdbms.rsf opt_req="O" version="10.2.0.4.0">
         my $line = $_;
         my @tokens = split (/ /,$line);
         my $prod = $tokens[0];
         $prod =~ s/^<// if($prod);
         $ActionsComps->{$numComps}->{_NAME} = $prod;

         foreach my $pair (@tokens)
         {
           if ($pair =~ /=/) # to get rid of action and any patterns in future without '='
           {
             my ($att, $val) = split (/=/,$pair); # version "10.2.0.4.0">
             $val =~ s/"//g if ($val); # 10.2.0.4.0>
             $val =~ s/>$//g if ($val); # 10.2.0.4.0
             if($att eq 'version')
             {
               $ActionsComps->{$numComps}->{_VERSION} = $val;
             }
           }
         }
         #new comp, reset actions
         $numActsPerComp = 0;
         $ActionsComps->{$numComps}->{_ACTIONS} = (); # empty as of now

       }
       elsif ((/^<archive /) || (/^<copy/) || (/^<make/) || (/^<jar/) || (/^<onewaycopy/)) 
       {
#<copy name="bundledata_CPU.xml" path="%ORACLE_HOME%/rdbms/admin" file_name="rdbms/admin/bundledata_CPU.xml"/>
         my $line = $_;
         my @tokens = split (/ /,$line);
         my $action = $tokens[0];
         $action =~ s/^<// if($action);

         $ActionsComps->{$numComps}->{_ACTIONS}->{$numActsPerComp}->{_ACTION} = $action; #eg . copy
         foreach my $pair (@tokens) 
         {
           if ($pair =~ /=/) # to get rid of action and any patterns in future without '='
           {
             my ($att, $val) = split (/=/,$pair); # name bundledata_CPU.xml"
             $val =~ s/"//g if ($val); # name bundledata_CPU.xml
             $val =~ s/%ORACLE_HOME%\///g if ($val);
             $val =~ s/\/>//g if ($val);
             $ActionsComps->{$numComps}->{_ACTIONS}->{$numActsPerComp}->{$att}= $val if ($att);
           }
         }
         $numActsPerComp++;
       }
     }# while
     close(XML);
   }else 
   {
     emdcommon_ocm::EMD_PERL_DEBUG("COULD NOT OPEN actions file");
     return OH_Error::FILE_CANNOT_OPEN;
   }
   return $ActionsComps;
}

1;
