# 
# $Header: emagent/sysman/admin/scripts/OH_Target.pm /main/3 2011/12/27 00:12:29 hmodawel Exp $
#
# OH_Target.pm
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      OH_Target.pm - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hmodawel    12/26/11 - remove fix for 12907385
#    hmodawel    11/12/11 - new OH Target
#    ravpatel    09/28/11 - Oracle Home Target Package
#    ravpatel    09/28/11 - Creation
#

use strict;
use warnings;
require Exporter;

use OH_Discovery;

{
package OH_Target;

  use fields qw ( NAME DISPLAY_NAME ON_HOST PROPS );

  sub new
  {
    my ($class, %args) = @_;
    my $self = fields::new(ref($class)||$class);

    foreach my $key (keys %args)
    {
      $self->{$key} = $args{$key};
    }
    return $self;
  }

  #-- Procedure to print targets.xml snippet for discovered target.
  sub printXml
  {
    my $self = shift;
    my $props = $self->{PROPS};

    # Handle the case where target name is longer than 256 characters, take first 256
    $self->{NAME}=substr($self->{NAME}, 0, 255) if (length($self->{NAME}) > 256);

    my $home_loc = $props->{INSTALL_LOCATION};
    my $hostname = OH_Discovery::HOSTNAME_SHORT;
    my $hostNamefull = OH_Discovery::HOSTNAME_LONG;
    my $displayName = $self->{DISPLAY_NAME} ? $self->{DISPLAY_NAME} : $self->{NAME};

    print "\t<Target TYPE=\"oracle_home\" NAME=\"$self->{NAME}\" DISPLAY_NAME=\"$displayName\"";
    print " ON_HOST=\"$self->{ON_HOST}\"" if $self->{ON_HOST};

    print">\n";

    foreach my $prop (sort keys %$props)
    {
      # Please note that HOME_NAME is not a target property anymore. It has been passed till here
      # only to be used in target name and display name.
      print "\t\t<Property NAME=\"$prop\" VALUE=\"$props->{$prop}\" />\n" if ($prop ne "HOME_NAME");
    }
    print "\t</Target>\n";
  }
}

{
package OH_Target_Props;

  use fields qw(HOME_TYPE INSTALL_LOCATION INVENTORY MW_HOME HOME_NAME OcmProxyOracleHome);

  sub new
  {
    my ($class, %args) = @_;
    my $self = fields::new(ref($class)||$class);

    foreach my $key (keys %args)
    {
      $self->{$key} = $args{$key};
    }
    return $self;
  }

}

1; 
